/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonNavigatorManager;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;

public class UIUtil {
    public static void openBrowser(String url) {
        try {
            URL urlToOpen = new URL(url);
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            if (browser != null) {
                browser.openURL(urlToOpen);
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
    }

    public static JavaDecompilerClassFileEditor getActiveEditor() {
        final JavaDecompilerClassFileEditor[] editors = new JavaDecompilerClassFileEditor[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart editor = UIUtil.getActiveEditor(true);
                if (editor instanceof JavaDecompilerClassFileEditor) {
                    editors[0] = (JavaDecompilerClassFileEditor)editor;
                } else {
                    IEditorPart editorPart;
                    IWorkbenchPage pg;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (pg = window.getActivePage()) != null && (editorPart = pg.getActiveEditor()) instanceof JavaDecompilerClassFileEditor) {
                        editors[0] = (JavaDecompilerClassFileEditor)editorPart;
                    }
                }
            }
        });
        return editors[0];
    }

    public static JavaDecompilerClassFileEditor getActiveDecompilerEditor() {
        final JavaDecompilerClassFileEditor[] editors = new JavaDecompilerClassFileEditor[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPart editor = UIUtil.getActiveEditor(true);
                if (editor instanceof JavaDecompilerClassFileEditor) {
                    editors[0] = (JavaDecompilerClassFileEditor)editor;
                }
            }
        });
        return editors[0];
    }

    public static List getActiveSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        List classes = UIUtil.getSelectedElements(window.getSelectionService(), IClassFile.class);
        if (classes != null && !classes.isEmpty()) {
            return classes;
        }
        return null;
    }

    public static String getActivePerspectiveId() {
        final String[] ids = new String[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb == null) {
                    ids[0] = null;
                    return;
                }
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                if (win == null) {
                    ids[0] = null;
                    return;
                }
                IWorkbenchPage page = win.getActivePage();
                if (page == null) {
                    ids[0] = null;
                    return;
                }
                IPerspectiveDescriptor perspective = page.getPerspective();
                if (perspective == null) {
                    ids[0] = null;
                    return;
                }
                ids[0] = perspective.getId();
            }
        });
        return ids[0];
    }

    public static boolean isDebug() {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        boolean debug = showLineNumber && align || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode();
        return debug;
    }

    public static boolean isDebugPerspective() {
        return "org.eclipse.debug.ui.DebugPerspective".equals(UIUtil.getActivePerspectiveId());
    }

    public static List getSelectedElements(ISelectionService selService, Class eleClass) {
        Iterator selections = UIUtil.getSelections(selService);
        ArrayList elements = new ArrayList();
        while (selections != null && selections.hasNext()) {
            Object select = selections.next();
            if (!eleClass.isInstance(select)) continue;
            elements.add(select);
        }
        return elements;
    }

    public static Iterator getSelections(ISelectionService selService) {
        ISelection selection = selService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.iterator();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IWorkbenchPart getActiveEditor(boolean activePageOnly) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) return null;
        if (activePageOnly) {
            IWorkbenchPage pg = window.getActivePage();
            if (pg == null) return null;
            IWorkbenchPart activePart = pg.getActivePart();
            if (!(activePart instanceof ContentOutline)) return activePart;
            ContentOutline outline = (ContentOutline)activePart;
            IWorkbenchPart part = (IWorkbenchPart)ReflectionUtils.invokeMethod(outline, "getCurrentContributingPart");
            if (part != null) return null;
            return (IWorkbenchPart)ReflectionUtils.getFieldValue(outline, "hiddenPart");
        }
        IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPart part;
            IWorkbenchPage pg = iWorkbenchPageArray[n2];
            if (pg != null && (part = pg.getActivePart()) != null) {
                return part;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isOpenClassEditor() {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null) {
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n = iWorkbenchPageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart[] editorParts;
                    IWorkbenchPage pg = iWorkbenchPageArray[n2];
                    if (pg != null && (editorParts = pg.getEditors()) != null) {
                        IEditorPart[] iEditorPartArray = editorParts;
                        int n3 = editorParts.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IEditorPart part = iEditorPartArray[n4];
                            if (part instanceof JavaDecompilerClassFileEditor) {
                                return true;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        }
        return false;
    }

    public static List getExportSelections() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        List selectedJars = UIUtil.getSelectedElements(window.getSelectionService(), IPackageFragmentRoot.class);
        if (selectedJars.size() == 1) {
            return selectedJars;
        }
        if (selectedJars.size() > 1) {
            return null;
        }
        List selectedPackages = UIUtil.getSelectedElements(window.getSelectionService(), IPackageFragment.class);
        List selectedClasses = UIUtil.getSelectedElements(window.getSelectionService(), IClassFile.class);
        selectedClasses.addAll(selectedPackages);
        if (!selectedClasses.isEmpty()) {
            return selectedClasses;
        }
        return null;
    }

    public static boolean isPackageFlat() {
        boolean isFlat = false;
        try {
            IWorkbenchPart view = UIUtil.getActiveEditor(true);
            if (view != null) {
                if (view.getSite().getId().equals("org.eclipse.ui.navigator.ProjectExplorer")) {
                    CommonNavigator explorer = (CommonNavigator)view;
                    Field field = CommonNavigator.class.getDeclaredField("commonManager");
                    if (field != null) {
                        field.setAccessible(true);
                        CommonNavigatorManager manager = (CommonNavigatorManager)field.get(explorer);
                        field = CommonNavigatorManager.class.getDeclaredField("contentService");
                        if (field != null) {
                            field.setAccessible(true);
                            INavigatorContentService service = (INavigatorContentService)field.get(manager);
                            IExtensionStateModel model = service.findStateModel("org.eclipse.jdt.java.ui.javaContent");
                            isFlat = model.getBooleanProperty("isLayoutFlat");
                        }
                    }
                } else if (view.getSite().getId().equals("org.eclipse.jdt.ui.PackageExplorer")) {
                    PackageExplorerPart explorer = (PackageExplorerPart)view;
                    isFlat = explorer.isFlatLayout();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isFlat;
    }

    public static boolean isWin32() {
        return "win32".equalsIgnoreCase(Platform.getOS());
    }

    public static boolean isMacOS() {
        return "macosx".equalsIgnoreCase(Platform.getOS());
    }

    public static String getPathLocation(IPath path) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IResource resource = root.findMember(path);
        if (resource != null) {
            return resource.getLocation().toOSString();
        }
        return null;
    }

    public static boolean requestFromJavadocHover() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 12) {
            if (stacks[i].getClassName().indexOf("BinaryType") != -1 && stacks[i].getMethodName().equals("getJavadocRange")) {
                return false;
            }
            if (stacks[i].getClassName().indexOf("JavadocHover") != -1 && stacks[i].getMethodName().equals("getHoverInfo")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestFromDisassemblerSelection() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 10) {
            if (stacks[i].getMethodName().equals("doHandleCursorPositionChanged")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestCreateBuffer() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 12) {
            if (stacks[i].getClassName().indexOf("BinaryType") != -1 && stacks[i].getMethodName().equals("getJavadocRange")) {
                return false;
            }
            if (stacks[i].getClassName().indexOf("JavadocHover") != -1 && stacks[i].getMethodName().equals("getHoverInfo2")) {
                return true;
            }
            if (stacks[i].getClassName().indexOf("JavaSourceHover") != -1 && stacks[i].getMethodName().equals("getHoverInfo")) {
                return true;
            }
            if (stacks[i].getClassName().indexOf("FindOccurrencesInFileAction") != -1 && stacks[i].getMethodName().equals("getMember")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestFromShowMatch() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length) {
            if (stacks[i].getClassName().indexOf("JavaSearchResultPage") != -1 && stacks[i].getMethodName().equals("showMatch")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDark(Control textWidget) {
        if (textWidget != null && !textWidget.isDisposed()) {
            Color color = textWidget.getBackground();
            int red = color.getRed();
            int blue = color.getBlue();
            int green = color.getGreen();
            return red < 127 || blue < 127 || green < 127;
        }
        return false;
    }

    public static boolean requestFromLinkToSelection() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 10) {
            if (stacks[i].getMethodName().equals("linkToEditor") || stacks[i].getMethodName().equals("showSource")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean requestFromCopyOperation() {
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        int i = 0;
        while (i < stacks.length && i < 10) {
            if (stacks[i].getMethodName().equals("doCutCopyWithImportsOperation")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

