/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v138.extensions.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum StorageArea {
    SESSION("session"),
    LOCAL("local"),
    SYNC("sync"),
    MANAGED("managed");

    private String value;

    private StorageArea(String value) {
        this.value = value;
    }

    public static StorageArea fromString(String s) {
        return Arrays.stream(StorageArea.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within StorageArea "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static StorageArea fromJson(JsonInput input) {
        return StorageArea.fromString(input.nextString());
    }
}

