/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testcloud.dto;

import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudApplicationStatus;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.dto.ApplicationMetadata;
import java.time.LocalDateTime;

public class TestCloudApplicationDto {
    private String createdDate;
    private String fileName;
    private String id;
    private ApplicationMetadata metadata;
    private String name;
    private String organizationId;
    private String platform;
    private long size;
    private String status;
    private String storagePath;
    private String updatedDate;
    private String uploadedDate;

    public static TestCloudApplicationDto fromDomainModel(TestCloudApplication testCloudApplication) {
        TestCloudApplicationDto application = new TestCloudApplicationDto();
        application.setFileName(testCloudApplication.getFileName());
        application.setId(testCloudApplication.getId());
        application.setName(testCloudApplication.getName());
        application.setOrganizationId(testCloudApplication.getOrganizationId());
        application.setPlatform(testCloudApplication.getPlatform().toString());
        application.setSize(testCloudApplication.getSize());
        application.setStatus(testCloudApplication.getStatus().toString());
        application.setStoragePath(testCloudApplication.getStoragePath());
        application.setCreatedDate(DateUtil.convertIsoDateTimeToString((LocalDateTime)testCloudApplication.getCreatedDate()));
        application.setUpdatedDate(DateUtil.convertIsoDateTimeToString((LocalDateTime)testCloudApplication.getUpdatedDate()));
        application.setUploadedDate(DateUtil.convertIsoDateTimeToString((LocalDateTime)testCloudApplication.getUpdatedDate()));
        application.setMetadata(ApplicationMetadata.fromDomainModel(testCloudApplication.getMetadata()));
        return application;
    }

    public String getCreatedDate() {
        return this.createdDate;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getId() {
        return this.id;
    }

    public ApplicationMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getPlatform() {
        return this.platform;
    }

    public long getSize() {
        return this.size;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getUpdatedDate() {
        return this.updatedDate;
    }

    public String getUploadedDate() {
        return this.uploadedDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMetadata(ApplicationMetadata metadata) {
        this.metadata = metadata;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public void setUpdatedDate(String updatedDate) {
        this.updatedDate = updatedDate;
    }

    public void setUploadedDate(String uploadedDate) {
        this.uploadedDate = uploadedDate;
    }

    public TestCloudApplication toDomainModel() {
        TestCloudApplication tcApplication = new TestCloudApplication();
        tcApplication.setCreatedDate(DateUtil.convertIsoDateTimeStringToDate((String)this.createdDate));
        tcApplication.setFileName(this.fileName);
        tcApplication.setId(this.id);
        tcApplication.setName(this.name != null ? this.name : this.fileName);
        tcApplication.setOrganizationId(this.organizationId);
        tcApplication.setPlatform(this.platform.equalsIgnoreCase(TestCloudMobilePlatformName.ANDROID.name()) ? TestCloudMobilePlatformName.ANDROID : TestCloudMobilePlatformName.IOS);
        tcApplication.setSize(this.size);
        tcApplication.setStatus(TestCloudApplicationStatus.valueOf((String)this.status));
        tcApplication.setStoragePath(this.storagePath);
        tcApplication.setUpdatedDate(DateUtil.convertIsoDateTimeStringToDate((String)this.updatedDate));
        tcApplication.setUploadedDate(DateUtil.convertIsoDateTimeStringToDate((String)this.uploadedDate));
        tcApplication.setMetadata(this.metadata.toDomainModel());
        return tcApplication;
    }
}

