/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.TreeEntitySelectionDialog;
import com.kms.katalon.composer.components.impl.providers.AbstractEntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.EntityLabelProvider;
import com.kms.katalon.composer.components.impl.providers.EntityProvider;
import com.kms.katalon.composer.components.impl.providers.EntityViewerFilter;
import com.kms.katalon.composer.components.impl.providers.IEntityLabelProvider;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.dialogs.TestCaseFolderSelectionDialog;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportReportToTestCaseSelectionDialog
extends AbstractDialog {
    private Combo cbbExportOption;
    private StackLayout slExportDetails;
    private Composite exportDetailsComposite;
    private Map<ExportTestCaseOption, ExportOptionComposite> exportCompositeOptions = new HashMap<ExportTestCaseOption, ExportOptionComposite>();
    private ExportTestCaseOption selectedOption;
    private ExportTestCaseSelectionResult result;
    private ExportParentComposite refreshStateHandler = new ExportParentComposite(){

        @Override
        public void updateState() {
            ExportReportToTestCaseSelectionDialog.this.updateButtonState();
        }
    };

    public ExportReportToTestCaseSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void registerControlModifyListeners() {
        this.cbbExportOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportReportToTestCaseSelectionDialog.this.selectedOption = ExportTestCaseOption.fromText(ExportReportToTestCaseSelectionDialog.this.cbbExportOption.getText());
                ExportReportToTestCaseSelectionDialog.this.slExportDetails.topControl = ExportReportToTestCaseSelectionDialog.this.exportCompositeOptions.get((Object)ExportReportToTestCaseSelectionDialog.this.selectedOption).getCreatedContent();
                ExportReportToTestCaseSelectionDialog.this.exportDetailsComposite.layout();
                ExportReportToTestCaseSelectionDialog.this.updateButtonState();
            }
        });
    }

    protected void setInput() {
        this.updateButtonState();
    }

    private void updateButtonState() {
        this.getButton(0).setEnabled(this.exportCompositeOptions.get((Object)this.selectedOption).isAbleToOk());
    }

    protected Composite createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblExportSelection = new Label(container, 0);
        lblExportSelection.setText("Export Option");
        this.cbbExportOption = new Combo(container, 8);
        this.cbbExportOption.setItems(ExportTestCaseOption.textValues());
        this.cbbExportOption.select(0);
        this.selectedOption = ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE;
        this.exportDetailsComposite = new Composite(container, 0);
        this.exportDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.slExportDetails = new StackLayout();
        this.exportDetailsComposite.setLayout((Layout)this.slExportDetails);
        ExportNewTestCaseComposite exportNewTestCaseComposite = new ExportNewTestCaseComposite(this.refreshStateHandler);
        Composite exportNewTestCaseControl = exportNewTestCaseComposite.createContent(this.exportDetailsComposite);
        this.exportCompositeOptions.put(ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE, exportNewTestCaseComposite);
        AppendTestCaseComposite appendTestCaseComposite = new AppendTestCaseComposite(this.refreshStateHandler);
        appendTestCaseComposite.createContent(this.exportDetailsComposite);
        this.exportCompositeOptions.put(ExportTestCaseOption.APPEND_TO_TEST_CASE, appendTestCaseComposite);
        OverwriteTestCaseComposite overwriteTestCaseComposite = new OverwriteTestCaseComposite(this.refreshStateHandler);
        overwriteTestCaseComposite.createContent(this.exportDetailsComposite);
        this.exportCompositeOptions.put(ExportTestCaseOption.OVERWRITE_TEST_CASE, overwriteTestCaseComposite);
        this.slExportDetails.topControl = exportNewTestCaseControl;
        return container;
    }

    protected Point getInitialSize() {
        return new Point(500, super.getInitialSize().y);
    }

    protected void okPressed() {
        this.setResult(this.exportCompositeOptions.get((Object)this.selectedOption).getResult());
        super.okPressed();
    }

    public ExportTestCaseSelectionResult getResult() {
        return this.result;
    }

    public void setResult(ExportTestCaseSelectionResult result) {
        this.result = result;
    }

    private class AppendTestCaseComposite
    implements ExportOptionComposite {
        private CLabel lblMessage;
        private Button btnBrowserTestCase;
        private ExportParentComposite parentComposite;
        private Composite appendToTestCaseComposite;
        private TestCaseEntity testCase;
        private Text txtTestCaseId;

        public AppendTestCaseComposite(ExportParentComposite parentComposite) {
            this.parentComposite = parentComposite;
        }

        @Override
        public Composite createContent(Composite parent) {
            this.appendToTestCaseComposite = new Composite(parent, 0);
            this.appendToTestCaseComposite.setLayout((Layout)new GridLayout(2, false));
            new Label(this.appendToTestCaseComposite, 0);
            this.lblMessage = new CLabel(this.appendToTestCaseComposite, 0);
            this.lblMessage.setText("Select a test case");
            this.lblMessage.setImage(ImageManager.getImage((String)"info_16.png"));
            Label lblTestCase = new Label(this.appendToTestCaseComposite, 0);
            lblTestCase.setText("Test Case");
            Composite testCaseComposite = new Composite(this.appendToTestCaseComposite, 0);
            testCaseComposite.setLayoutData((Object)new GridData(768));
            GridLayout glTestCaseComposite = new GridLayout(2, false);
            glTestCaseComposite.marginWidth = 0;
            glTestCaseComposite.marginHeight = 0;
            testCaseComposite.setLayout((Layout)glTestCaseComposite);
            this.txtTestCaseId = new Text(testCaseComposite, 2056);
            this.txtTestCaseId.setLayoutData((Object)new GridData(768));
            this.btnBrowserTestCase = new Button(testCaseComposite, 8);
            this.btnBrowserTestCase.setText("Browse...");
            this.registerControlListeners();
            return this.appendToTestCaseComposite;
        }

        private void registerControlListeners() {
            this.btnBrowserTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntityProvider entityProvider = new EntityProvider();
                    TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(entityProvider));
                    try {
                        FolderEntity rootFolder = FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject());
                        dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
                        if (dialog.open() != 0) {
                            return;
                        }
                        TestCaseTreeEntity testCaseTree = (TestCaseTreeEntity)dialog.getFirstResult();
                        AppendTestCaseComposite.this.testCase = testCaseTree.getObject();
                        AppendTestCaseComposite.this.txtTestCaseId.setText(testCaseTree.getObject().getIdForDisplay());
                        AppendTestCaseComposite.this.parentComposite.updateState();
                    }
                    catch (Exception ex) {
                        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)GlobalStringConstants.WARN, (String)ex.getMessage());
                    }
                }
            });
        }

        @Override
        public boolean isAbleToOk() {
            return StringUtils.isNotEmpty((CharSequence)this.txtTestCaseId.getText());
        }

        @Override
        public Composite getCreatedContent() {
            return this.appendToTestCaseComposite;
        }

        @Override
        public ExportTestCaseSelectionResult getResult() {
            return new ExportTestCaseSelectionResult(ExportTestCaseOption.APPEND_TO_TEST_CASE, this.testCase.getName(), this.testCase.getParentFolder());
        }
    }

    private class ExportNewTestCaseComposite
    implements ExportOptionComposite {
        private ExportParentComposite parentComposite;
        private Text txtTestCaseName;
        private Button btnBrowserParent;
        private FolderEntity selectedFolder;
        private List<String> currentNames = new ArrayList<String>();
        private Text txtParentFolderId;
        private CLabel lblMessage;
        private Composite exportNewTestCaseComposite;

        public ExportNewTestCaseComposite(ExportParentComposite parentComposite) {
            this.parentComposite = parentComposite;
        }

        @Override
        public Composite createContent(Composite parent) {
            this.exportNewTestCaseComposite = new Composite(parent, 0);
            GridLayout glExportNewTestCase = new GridLayout(2, false);
            glExportNewTestCase.marginWidth = 0;
            glExportNewTestCase.marginHeight = 0;
            this.exportNewTestCaseComposite.setLayout((Layout)glExportNewTestCase);
            new Label(this.exportNewTestCaseComposite, 0);
            this.lblMessage = new CLabel(this.exportNewTestCaseComposite, 0);
            this.lblMessage.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.setInfoMessage();
            Label lblParentFolder = new Label(this.exportNewTestCaseComposite, 0);
            lblParentFolder.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblParentFolder.setText("Folder");
            Composite parentFolderComposite = new Composite(this.exportNewTestCaseComposite, 0);
            parentFolderComposite.setLayoutData((Object)new GridData(768));
            GridLayout glParentFolder = new GridLayout(2, false);
            glParentFolder.marginWidth = 0;
            glParentFolder.marginHeight = 0;
            glParentFolder.verticalSpacing = 10;
            parentFolderComposite.setLayout((Layout)glParentFolder);
            this.txtParentFolderId = new Text(parentFolderComposite, 2056);
            this.txtParentFolderId.setLayoutData((Object)new GridData(768));
            this.btnBrowserParent = new Button(parentFolderComposite, 8);
            this.btnBrowserParent.setText("Browse...");
            Label lblTestCaseName = new Label(this.exportNewTestCaseComposite, 0);
            lblTestCaseName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblTestCaseName.setText("Test Case Name");
            this.txtTestCaseName = new Text(this.exportNewTestCaseComposite, 2048);
            this.txtTestCaseName.setLayoutData((Object)new GridData(768));
            this.setInput();
            this.registerControlListeners();
            return this.exportNewTestCaseComposite;
        }

        private void setInput() {
            try {
                this.selectedFolder = FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject());
                this.updateParentFolderText(this.selectedFolder);
                String name = TestCaseController.getInstance().getAvailableTestCaseName(this.selectedFolder, "New Test Case");
                this.txtTestCaseName.setText(name);
                this.txtTestCaseName.forceFocus();
                this.txtTestCaseName.selectAll();
            }
            catch (ControllerException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }

        private void updateParentFolderText(FolderEntity folder) throws ControllerException {
            this.selectedFolder = folder;
            List siblings = FolderController.getInstance().getTestCaseChildren(this.selectedFolder);
            this.currentNames = siblings.stream().map(s -> s.getName()).collect(Collectors.toList());
            this.txtParentFolderId.setText(this.selectedFolder.getIdForDisplay());
        }

        private void registerControlListeners() {
            this.txtTestCaseName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExportNewTestCaseComposite.this.parentComposite.updateState();
                }
            });
            this.btnBrowserParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TestCaseFolderSelectionDialog dialog = new TestCaseFolderSelectionDialog(ExportNewTestCaseComposite.this.btnBrowserParent.getShell());
                    if (dialog.open() != 0) {
                        return;
                    }
                    try {
                        ExportNewTestCaseComposite.this.updateParentFolderText(dialog.getSelectedFolder().getObject());
                        ExportNewTestCaseComposite.this.parentComposite.updateState();
                    }
                    catch (Exception ex) {
                        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)GlobalStringConstants.WARN, (String)ex.getMessage());
                        LoggerSingleton.logError((Throwable)ex);
                    }
                }
            });
        }

        @Override
        public boolean isAbleToOk() {
            String text = this.txtTestCaseName.getText();
            if (StringUtils.isEmpty((CharSequence)text)) {
                this.setInfoMessage();
                return false;
            }
            if (!this.currentNames.contains(text)) {
                this.setInfoMessage();
                return true;
            }
            this.setDuplicatedErrorMessage();
            return false;
        }

        private void setDuplicatedErrorMessage() {
            this.lblMessage.setImage(ImageManager.getImage((String)"error_16.png"));
            this.lblMessage.setText("Inputted name already existed");
        }

        private void setInfoMessage() {
            this.lblMessage.setImage(ImageManager.getImage((String)"info_16.png"));
            this.lblMessage.setText("Enter a new test case name");
        }

        @Override
        public Composite getCreatedContent() {
            return this.exportNewTestCaseComposite;
        }

        @Override
        public ExportTestCaseSelectionResult getResult() {
            String testCaseName = this.txtTestCaseName.getText();
            return new ExportTestCaseSelectionResult(ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE, testCaseName, this.selectedFolder);
        }
    }

    private static interface ExportOptionComposite {
        public Composite createContent(Composite var1);

        public Composite getCreatedContent();

        public boolean isAbleToOk();

        public ExportTestCaseSelectionResult getResult();
    }

    private static interface ExportParentComposite {
        public void updateState();
    }

    public static enum ExportTestCaseOption {
        EXPORT_TO_NEW_TEST_CASE("Export to new test case"),
        APPEND_TO_TEST_CASE("Append to test case"),
        OVERWRITE_TEST_CASE("Overwrite test case");

        private final String text;

        private ExportTestCaseOption(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static String[] textValues() {
            ArrayList<String> textValues = new ArrayList<String>();
            ExportTestCaseOption[] exportTestCaseOptionArray = ExportTestCaseOption.values();
            int n = exportTestCaseOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportTestCaseOption option = exportTestCaseOptionArray[n2];
                textValues.add(option.text);
                ++n2;
            }
            return textValues.toArray(new String[0]);
        }

        public static ExportTestCaseOption fromText(String text) {
            ExportTestCaseOption[] exportTestCaseOptionArray = ExportTestCaseOption.values();
            int n = exportTestCaseOptionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportTestCaseOption option = exportTestCaseOptionArray[n2];
                if (option.getText().equals(text)) {
                    return option;
                }
                ++n2;
            }
            return null;
        }
    }

    public static class ExportTestCaseSelectionResult {
        private final ExportTestCaseOption option;
        private final String testCaseName;
        private final FolderEntity folder;

        public ExportTestCaseSelectionResult(ExportTestCaseOption option, String testCaseName, FolderEntity folder) {
            this.option = option;
            this.testCaseName = testCaseName;
            this.folder = folder;
        }

        public ExportTestCaseOption getOption() {
            return this.option;
        }

        public String getTestCaseName() {
            return this.testCaseName;
        }

        public FolderEntity getFolder() {
            return this.folder;
        }
    }

    private class OverwriteTestCaseComposite
    implements ExportOptionComposite {
        private CLabel lblMessage;
        private Button btnBrowserTestCase;
        private ExportParentComposite parentComposite;
        private Composite appendToTestCaseComposite;
        private TestCaseEntity testCase;
        private Text txtTestCaseId;

        public OverwriteTestCaseComposite(ExportParentComposite parentComposite) {
            this.parentComposite = parentComposite;
        }

        @Override
        public Composite createContent(Composite parent) {
            this.appendToTestCaseComposite = new Composite(parent, 0);
            this.appendToTestCaseComposite.setLayout((Layout)new GridLayout(2, false));
            new Label(this.appendToTestCaseComposite, 0);
            this.lblMessage = new CLabel(this.appendToTestCaseComposite, 0);
            this.lblMessage.setText("Select a test case");
            this.lblMessage.setImage(ImageManager.getImage((String)"info_16.png"));
            Label lblTestCase = new Label(this.appendToTestCaseComposite, 0);
            lblTestCase.setText("Test Case");
            Composite testCaseComposite = new Composite(this.appendToTestCaseComposite, 0);
            testCaseComposite.setLayoutData((Object)new GridData(768));
            GridLayout glTestCaseComposite = new GridLayout(2, false);
            glTestCaseComposite.marginWidth = 0;
            glTestCaseComposite.marginHeight = 0;
            testCaseComposite.setLayout((Layout)glTestCaseComposite);
            this.txtTestCaseId = new Text(testCaseComposite, 2056);
            this.txtTestCaseId.setLayoutData((Object)new GridData(768));
            this.btnBrowserTestCase = new Button(testCaseComposite, 8);
            this.btnBrowserTestCase.setText("Browse...");
            this.registerControlListeners();
            return this.appendToTestCaseComposite;
        }

        private void registerControlListeners() {
            this.btnBrowserTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EntityProvider entityProvider = new EntityProvider();
                    TreeEntitySelectionDialog dialog = new TreeEntitySelectionDialog(Display.getCurrent().getActiveShell(), (IEntityLabelProvider)new EntityLabelProvider(), (ITreeContentProvider)new EntityProvider(), (AbstractEntityViewerFilter)new EntityViewerFilter(entityProvider));
                    try {
                        FolderEntity rootFolder = FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject());
                        dialog.setInput((Object)TreeEntityUtil.getChildren(null, (FolderEntity)rootFolder));
                        if (dialog.open() != 0) {
                            return;
                        }
                        TestCaseTreeEntity testCaseTree = (TestCaseTreeEntity)dialog.getFirstResult();
                        OverwriteTestCaseComposite.this.testCase = testCaseTree.getObject();
                        OverwriteTestCaseComposite.this.txtTestCaseId.setText(testCaseTree.getObject().getIdForDisplay());
                        OverwriteTestCaseComposite.this.parentComposite.updateState();
                    }
                    catch (Exception ex) {
                        MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)GlobalStringConstants.WARN, (String)ex.getMessage());
                    }
                }
            });
        }

        @Override
        public boolean isAbleToOk() {
            return StringUtils.isNotEmpty((CharSequence)this.txtTestCaseId.getText());
        }

        @Override
        public Composite getCreatedContent() {
            return this.appendToTestCaseComposite;
        }

        @Override
        public ExportTestCaseSelectionResult getResult() {
            return new ExportTestCaseSelectionResult(ExportTestCaseOption.OVERWRITE_TEST_CASE, this.testCase.getName(), this.testCase.getParentFolder());
        }
    }
}

