/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.spy;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.windows.dialog.WindowsObjectDialog;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.core.enums.windows.LocatorStrategy;
import com.kms.katalon.core.testobject.WindowsTestObject;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.windows.keyword.helper.WindowsActionHelper;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class HighlightElementComposite {
    private WindowsObjectDialog parentDialog;
    private Label lblMessageVerifyObject;
    private CapturedWindowsElement editingElement;
    private Button btnHighlight;

    public HighlightElementComposite(WindowsObjectDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Composite createComposite(Composite parent) {
        Composite elementToolsComposite = new Composite(parent, 0x4000000);
        elementToolsComposite.setLayout((Layout)new GridLayout(2, false));
        elementToolsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnHighlight = new Button(elementToolsComposite, 0);
        this.btnHighlight.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.btnHighlight.setText(ComposerMobileObjectspyMessageConstants.DIA_BTN_HIGHLIGHT);
        this.btnHighlight.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_HIGHLIGHT_BUTTON);
        this.btnHighlight.setEnabled(false);
        this.btnHighlight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightElementComposite.this.findAndHighlightEditingElement();
            }
        });
        this.lblMessageVerifyObject = new Label(elementToolsComposite, 131136);
        this.lblMessageVerifyObject.setLayoutData((Object)new GridData(4, 128, true, true));
        return elementToolsComposite;
    }

    private void findAndHighlightEditingElement() {
        this.clearMessage();
        this.refreshButtonsState();
        if (this.editingElement == null) {
            return;
        }
        LocatorStrategy locatorStrategy = this.editingElement.getLocatorStrategy();
        String locatorStrategyName = locatorStrategy.getLocatorStrategy();
        String locator = this.editingElement.getLocator();
        try {
            try {
                WebElement firstElement;
                long startTime = System.currentTimeMillis();
                List<WebElement> webElements = this.findElements(this.editingElement);
                long elapsedTime = System.currentTimeMillis() - startTime;
                WebElement webElement2 = firstElement = webElements.size() > 0 ? webElements.get(0) : null;
                if (firstElement != null) {
                    Point location = firstElement.getLocation();
                    this.parentDialog.setSelectedElementByLocation(location.x, location.y);
                }
                List<Rectangle> elementRects = webElements.stream().map(webElement -> {
                    Point location = webElement.getLocation();
                    Dimension size = webElement.getSize();
                    return new Rectangle(location.x, location.y, size.width, size.height);
                }).collect(Collectors.toList());
                this.parentDialog.highlightElementRects(elementRects);
                if (webElements.size() > 0) {
                    this.displayFoundMessage(webElements.size(), locatorStrategyName, locator, elapsedTime);
                } else {
                    this.displayNotFoundMessage(locatorStrategyName, locator);
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.displayNotFoundMessage(locatorStrategyName, locator);
                this.refreshButtonsState();
            }
            catch (Exception e) {
                MultiStatusErrorDialog.showErrorDialog((String)"Unable to highlight element!", (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
                this.refreshButtonsState();
            }
        }
        finally {
            this.refreshButtonsState();
        }
    }

    private List<WebElement> findElements(CapturedWindowsElement targetElement) {
        if (targetElement == null) {
            return null;
        }
        WindowsTestObject windowsTestObject = new WindowsTestObject(targetElement.getName());
        windowsTestObject.setLocator(targetElement.getLocator());
        windowsTestObject.setLocatorStrategy(LocatorStrategy.valueOf((String)this.editingElement.getLocatorStrategy().name()));
        WindowsActionHelper windowsActionHelper = new WindowsActionHelper(this.parentDialog.getInspectorController().getWindowsSession());
        return windowsActionHelper.findElements(windowsTestObject);
    }

    private void displaySuccessfulMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getTextSuccessfulColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayErrorMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getTextErrorColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayFoundMessage(int numElements, String strategy, String selector, long elapsedTime) {
        String pluralPostfix = numElements > 1 ? "s" : "";
        this.displaySuccessfulMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_ELEMENT_FOUND, numElements, pluralPostfix, strategy, selector, elapsedTime));
    }

    private void displayNotFoundMessage(String strategy, String selector) {
        this.displayErrorMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_ELEMENT_NOT_FOUND, strategy, selector));
    }

    private void clearMessage() {
        this.lblMessageVerifyObject.setText("");
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    public CapturedWindowsElement getEditingElement() {
        return this.editingElement;
    }

    public void setEditingElement(CapturedWindowsElement editingElement) {
        this.editingElement = editingElement;
        this.refreshButtonsState();
        this.clearMessage();
    }

    private void refreshButtonsState() {
        boolean isEnableHightlightButton = this.editingElement != null;
        this.btnHighlight.setEnabled(isEnableHightlightButton);
    }
}

