/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.composer.keyword.constants.StringConstants;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import jakarta.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class DeleteKeywordHandler
implements IDeleteEntityHandler {
    @Inject
    private UISynchronize sync;
    @Inject
    private IEventBroker eventBroker;

    public Class<? extends ITreeEntity> entityType() {
        return KeywordTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (treeEntity == null || !(treeEntity instanceof KeywordTreeEntity)) {
                return false;
            }
            String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
            monitor.beginTask(taskName, 1);
            if (treeEntity.getObject() != null && treeEntity.getObject() instanceof ICompilationUnit) {
                ICompilationUnit unit = (ICompilationUnit)treeEntity.getObject();
                IFile iFile = (IFile)unit.getResource();
                KeywordController.getInstance().removeMethodNodesCustomKeywordFile(iFile, ProjectController.getInstance().getCurrentProject());
                if (unit.exists()) {
                    unit.getResource().refreshLocal(0, null);
                    this.closeEditor(iFile);
                    if (unit.isWorkingCopy()) {
                        unit = unit.getPrimary();
                        unit.discardWorkingCopy();
                    }
                    unit.delete(true, null);
                    this.eventBroker.post("CUSTOMKEYWORD/REFRESH", null);
                }
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MessageDialog.openError(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_DELETE_KEYWORD);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private void closeEditor(final IFile file) {
        this.sync.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart editorPart = workbenchPage.findEditor((IEditorInput)new FileEditorInput(file));
                if (editorPart != null) {
                    workbenchPage.closeEditor(editorPart, false);
                }
            }
        });
    }
}

