/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.keyword.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ExportFolderHandler {
    @Inject
    IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    private final String DOT_DILIMETER = ".";
    private final String OPEN_CONTAINING_FOLDER_WINDOW_CMD = "explorer.exe /select,";
    private final String OPEN_CONTAINING_FOLDER_MACOS_CMD = "open -R ";

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            Shell shell = Display.getCurrent().getActiveShell();
            DirectoryDialog directoryDialog = new DirectoryDialog(shell, 131072);
            directoryDialog.setMessage("Select output folder to export the keyword folder");
            String selectedOutputPath = directoryDialog.open();
            if (selectedOutputPath == null) {
                return;
            }
            File exportedFolder = new File(selectedOutputPath);
            if (exportedFolder != null && exportedFolder.exists() && exportedFolder.isDirectory()) {
                Trackings.trackExportKeywords();
                this.exportKeywordsDirectory(shell, selectedObjects[0], exportedFolder);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="FOLDER/EXPORT") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    private void exportKeywordsDirectory(Shell shell, Object selectedTreeEntity, File selectedExportFolder) throws Exception {
        FolderTreeEntity keywordRootFolder = new FolderTreeEntity(FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()), null);
        FolderEntity outputFolder = null;
        FolderEntity parentOutputFolder = null;
        FolderEntity sourceFolder = null;
        Object exportedFolderPath = "";
        boolean isExportPackageLevel = selectedTreeEntity instanceof PackageTreeEntity;
        if (isExportPackageLevel) {
            String packageName = ((PackageTreeEntity)selectedTreeEntity).getPackageName();
            exportedFolderPath = selectedExportFolder.getAbsolutePath() + File.separator + packageName.substring(0, packageName.indexOf("."));
            Path outputFolderPath = this.createFolderTreeBasePackageName(selectedExportFolder, packageName);
            outputFolder = FolderController.getInstance().getFolder(outputFolderPath.toString());
            outputFolder.setFolderType(FolderEntity.FolderType.KEYWORD);
            outputFolder.setName(outputFolderPath.getFileName().toString());
            parentOutputFolder = FolderController.getInstance().getFolder(outputFolderPath.getParent().toString());
            parentOutputFolder.setName(outputFolderPath.getParent().toString());
            String path = FolderController.getInstance().getKeywordRoot(ProjectController.getInstance().getCurrentProject()).getLocation() + File.separator + packageName.replace(".", File.separator);
            sourceFolder = FolderController.getInstance().getFolder(path);
            sourceFolder.setFolderType(FolderEntity.FolderType.KEYWORD);
            sourceFolder.setName(packageName.substring(packageName.lastIndexOf(".") + 1, packageName.length()));
            sourceFolder.setParentFolder(FolderController.getInstance().getFolder(new File(path).getParent()));
        } else {
            outputFolder = FolderController.getInstance().getFolder(selectedExportFolder.getAbsolutePath());
            outputFolder.setFolderType(FolderEntity.FolderType.KEYWORD);
            outputFolder.setName(selectedExportFolder.getName());
            exportedFolderPath = outputFolder.getLocation();
            parentOutputFolder = FolderController.getInstance().getFolder(selectedExportFolder.getParentFile().getAbsolutePath());
            parentOutputFolder.setName(selectedExportFolder.getParentFile().getAbsolutePath());
            sourceFolder = (FolderEntity)keywordRootFolder.getObject();
        }
        outputFolder.setParentFolder(parentOutputFolder);
        FolderEntity copiedFolder = FolderController.getInstance().copyFolder(sourceFolder, outputFolder);
        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)keywordRootFolder);
        this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordRootFolder);
        this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)keywordRootFolder);
        MessageDialog.openInformation((Shell)shell, (String)StringConstants.INFO, (String)"Export keyword folder successful !");
        String osName = System.getProperty("os.name");
        Object finalCommand = "";
        Object appendOpenExportFolderPath = "";
        if (!isExportPackageLevel) {
            appendOpenExportFolderPath = File.separator + copiedFolder.getName();
        }
        finalCommand = osName == null || osName.toLowerCase().contains("win") ? "explorer.exe /select," + (String)exportedFolderPath + (String)appendOpenExportFolderPath : "open -R " + (String)exportedFolderPath + (String)appendOpenExportFolderPath;
        Runtime.getRuntime().exec((String)finalCommand);
    }

    private Path createFolderTreeBasePackageName(File parentFolder, String packageName) throws Exception {
        packageName = packageName.substring(0, packageName.lastIndexOf("."));
        String relativePath = packageName.replace(".", File.separator);
        String absolutePath = parentFolder.getAbsolutePath() + File.separator + relativePath;
        Path path = Paths.get(absolutePath, new String[0]);
        return Files.createDirectories(path, new FileAttribute[0]);
    }
}

