/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testlistener.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.tree.TestListenerFolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestListenerTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.testlistener.constant.ComposerTestListenerMessageConstants;
import com.kms.katalon.composer.testlistener.dialog.RenameTestListenerDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestListenerController;
import com.kms.katalon.entity.file.TestListenerEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestListenerHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                if (object instanceof TestListenerTreeEntity) {
                    RenameTestListenerHandler.this.execute((TestListenerTreeEntity)object);
                }
            }
        });
    }

    private void execute(TestListenerTreeEntity testListenerTreeEntity) {
        try {
            TestListenerController testListenerController = TestListenerController.getInstance();
            TestListenerFolderTreeEntity parentTreeFolder = (TestListenerFolderTreeEntity)testListenerTreeEntity.getParent();
            TestListenerEntity renamedTestListener = testListenerTreeEntity.getObject();
            FolderEntity parentFolder = parentTreeFolder.getObject();
            RenameTestListenerDialog dialog = new RenameTestListenerDialog(this.parentShell, testListenerTreeEntity.getObject(), testListenerController.getSiblingTestListeners(renamedTestListener, parentFolder));
            if (dialog.open() != 0) {
                return;
            }
            String newName = dialog.getNewName();
            if (renamedTestListener.getName().equals(newName)) {
                return;
            }
            IFile iFile = GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()).getFile(Path.fromOSString((String)renamedTestListener.getRelativePath()));
            iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.createCompilationUnitFrom((IFile)iFile);
            unit.rename(newName + ".groovy", true, (IProgressMonitor)new NullProgressMonitor());
            TestListenerEntity newTestListener = testListenerController.renameTestListener(newName, renamedTestListener);
            testListenerTreeEntity.setObject((Object)newTestListener);
            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)testListenerTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)testListenerTreeEntity);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerTestListenerMessageConstants.HDL_MSG_UNABLE_TO_RENAME_TEST_LISTENER, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

