/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.kobiton.preferences;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.dialogs.FieldEditorPreferencePageWithHelp;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.integration.kobiton.constants.ComposerIntegrationKobitonMessageConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.integration.kobiton.exceptions.KobitonApiException;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class KobitonPreferencesPage
extends FieldEditorPreferencePageWithHelp {
    private Composite container;
    private BooleanFieldEditor enableKobitonIntegration;
    private StringFieldEditor serverEditor;
    private StringFieldEditor userNameEditor;
    private StringFieldEditor apiKeyEditor;
    private Link statusLabel;
    private Button btnTestConnection;
    private HelpComposite btnHelpApiKey;
    private Composite authComposite;

    public KobitonPreferencesPage() {
        this.setPreferenceStore((IPreferenceStore)PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.integration.kobiton"));
    }

    protected Control createContents(Composite parent) {
        this.container = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        this.enableKobitonIntegration = new BooleanFieldEditor("kobiton.integration.enable", ComposerIntegrationKobitonMessageConstants.LBL_ENABLE_KOBITON_INTEGRATION, this.container);
        this.addField((FieldEditor)this.enableKobitonIntegration);
        this.createAuthComposite(this.container);
        this.initialize();
        this.checkState();
        return this.container;
    }

    private void createAuthComposite(Composite parent) {
        this.authComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)3).fillHorizontal().build();
        this.serverEditor = new StringFieldEditor("kobiton.server.endpoint", ComposerIntegrationKobitonMessageConstants.LBL_SERVER_URL, this.authComposite);
        final Text txtServerEditor = this.serverEditor.getTextControl(this.authComposite);
        txtServerEditor.setEditable(true);
        txtServerEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!txtServerEditor.isDisposed() && StringUtils.isBlank((CharSequence)txtServerEditor.getText())) {
                    KobitonPreferencesPage.this.serverEditor.loadDefault();
                }
            }
        });
        this.addField((FieldEditor)this.serverEditor);
        this.userNameEditor = new StringFieldEditor("kobiton.authentication.username", ComposerIntegrationKobitonMessageConstants.LBL_USERNAME, this.authComposite);
        this.addField((FieldEditor)this.userNameEditor);
        this.apiKeyEditor = new StringFieldEditor("kobiton.authentication.apiKey", ComposerIntegrationKobitonMessageConstants.LBL_API_KEY, this.authComposite);
        this.apiKeyEditor.getTextControl(this.authComposite).setParent(parent);
        this.btnHelpApiKey = (HelpComposite)ComponentBuilder.helpButton((Composite)this.authComposite, (String)DocumentationMessageConstants.KOBITON_API_KEY).left().noFillHorizontal().build();
        this.apiKeyEditor.getTextControl(parent).setParent(this.authComposite);
        this.addField((FieldEditor)this.apiKeyEditor);
        Composite connectComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).fillHorizontal().build();
        this.statusLabel = (Link)ComponentBuilder.link((Composite)connectComposite).fillHorizontal().build();
        this.btnTestConnection = (Button)ComponentBuilder.button((Composite)connectComposite).text(ComposerIntegrationKobitonMessageConstants.BTN_TEST_CONNECTION).top().onClick(event -> this.testConnection()).build();
        ComponentUtil.getGridLayout((Composite)this.authComposite).numColumns = 3;
        ComponentUtil.setGridColSpan((Control)this.serverEditor.getLabelControl(this.authComposite), (int)2);
        ComponentUtil.setGridColSpan((Control)this.userNameEditor.getLabelControl(this.authComposite), (int)2);
    }

    protected void initialize() {
        String legacyApiKey;
        super.initialize();
        if (StringUtils.isBlank((CharSequence)this.apiKeyEditor.getStringValue()) && StringUtils.isNotBlank((CharSequence)(legacyApiKey = this.getPreferenceStore().getString("kobiton.apiKey")))) {
            this.apiKeyEditor.setStringValue(legacyApiKey);
        }
        this.updateControlStates();
    }

    private void testConnection() {
        String serverUrl = this.serverEditor.getStringValue().trim();
        String username = this.userNameEditor.getStringValue().trim();
        String apiKey = this.apiKeyEditor.getStringValue().trim();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{username, apiKey})) {
            ComponentUtil.showError((Control)this.statusLabel, (String)ComposerIntegrationKobitonMessageConstants.MSG_USERNAME_APIKEY_SHOULD_NOT_EMPTY);
            return;
        }
        try {
            if (KobitonApiProvider.testConnection((String)serverUrl, (String)username, (String)apiKey)) {
                ComponentUtil.showSuccess((Control)this.statusLabel, (String)ComposerIntegrationKobitonMessageConstants.MSG_CONNECT_SUCCESSFULLY);
            }
        }
        catch (KobitonApiException error) {
            ComponentUtil.showError((Control)this.statusLabel, (String)ExceptionUtils.getMessage((Throwable)error));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.handleFieldEditorValueChanged(event);
        }
        super.propertyChange(event);
    }

    private void handleFieldEditorValueChanged(PropertyChangeEvent event) {
        if (event.getSource() == this.enableKobitonIntegration) {
            this.updateControlStates();
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore().setToDefault("kobiton.authentication.token");
        this.updateControlStates();
        ComponentUtil.clearMessage((Control)this.statusLabel);
    }

    private void updateControlStates() {
        boolean isKobitonIntegrated = this.enableKobitonIntegration.getBooleanValue();
        this.serverEditor.setEnabled(isKobitonIntegrated, this.authComposite);
        this.serverEditor.getLabelControl(this.authComposite).setEnabled(isKobitonIntegrated);
        this.userNameEditor.setEnabled(isKobitonIntegrated, this.authComposite);
        this.userNameEditor.getLabelControl(this.authComposite).setEnabled(isKobitonIntegrated);
        this.apiKeyEditor.setEnabled(isKobitonIntegrated, this.authComposite);
        this.apiKeyEditor.getLabelControl(this.authComposite).setEnabled(isKobitonIntegrated);
        this.btnTestConnection.setEnabled(isKobitonIntegrated);
        this.btnHelpApiKey.setEnabled(isKobitonIntegrated);
        if (!isKobitonIntegrated) {
            ComponentUtil.clearMessage((Control)this.statusLabel);
        }
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        boolean performOk = super.performOk();
        String token = KobitonApiProvider.buildToken((String)this.userNameEditor.getStringValue(), (String)this.apiKeyEditor.getStringValue());
        if (performOk && token != null) {
            this.getPreferenceStore().setValue("kobiton.authentication.token", token);
        }
        return performOk;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_KOBITON;
    }

    protected void createFieldEditors() {
    }

    protected void adjustGridLayout() {
    }
}

