/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.constants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIAITestingConstants
extends NLS {
    private static final Logger logger = LoggerFactory.getLogger(APIAITestingConstants.class);
    private static final String BUNDLE_NAME = "com.kms.katalon.composer.webservice.constants.api-ai-testing";
    public static final String POSITIVE_TESTING = "Positive Testing";
    public static final String NEGATIVE_TESTING = "Negative Testing";
    public static final String SECURITY_TESTING = "Security Testing";
    public static final String EDGE_CASE_TESTING = "Edge Case Testing";
    private static final String POSITIVE_PREFIX = "positive.testing.";
    private static final String NEGATIVE_PREFIX = "negative.testing.";
    private static final String SECURITY_PREFIX = "security.testing.";
    private static final String EDGE_CASE_PREFIX = "edge.case.testing.";
    private static List<String> positiveTestingFuzzers;
    private static List<String> negativeTestingFuzzers;
    private static List<String> securityTestingFuzzers;
    private static List<String> edgeCaseTestingFuzzers;

    static {
        NLS.initializeMessages((String)BUNDLE_NAME, APIAITestingConstants.class);
        APIAITestingConstants.loadProperties();
    }

    private static void loadProperties() {
        positiveTestingFuzzers = new ArrayList<String>();
        negativeTestingFuzzers = new ArrayList<String>();
        securityTestingFuzzers = new ArrayList<String>();
        edgeCaseTestingFuzzers = new ArrayList<String>();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                String value = bundle.getString(key);
                if (value == null || value.trim().isEmpty()) continue;
                if (key.startsWith(POSITIVE_PREFIX)) {
                    positiveTestingFuzzers.add(value);
                    continue;
                }
                if (key.startsWith(NEGATIVE_PREFIX)) {
                    negativeTestingFuzzers.add(value);
                    continue;
                }
                if (key.startsWith(SECURITY_PREFIX)) {
                    securityTestingFuzzers.add(value);
                    continue;
                }
                if (!key.startsWith(EDGE_CASE_PREFIX)) continue;
                edgeCaseTestingFuzzers.add(value);
            }
            Collections.sort(positiveTestingFuzzers);
            Collections.sort(negativeTestingFuzzers);
            Collections.sort(securityTestingFuzzers);
            Collections.sort(edgeCaseTestingFuzzers);
            logger.info("Loaded AI Testing fuzzers - Positive: {}, Negative: {}, Security: {}, Edge Case: {}", new Object[]{positiveTestingFuzzers.size(), negativeTestingFuzzers.size(), securityTestingFuzzers.size(), edgeCaseTestingFuzzers.size()});
        }
        catch (Exception e) {
            logger.error("Failed to load aiTestingMapper.properties", (Throwable)e);
        }
    }

    public static List<String> getFuzzersForTestType(String testType) {
        if (POSITIVE_TESTING.equals(testType)) {
            return new ArrayList<String>(positiveTestingFuzzers);
        }
        if (NEGATIVE_TESTING.equals(testType)) {
            return new ArrayList<String>(negativeTestingFuzzers);
        }
        if (SECURITY_TESTING.equals(testType)) {
            return new ArrayList<String>(securityTestingFuzzers);
        }
        if (EDGE_CASE_TESTING.equals(testType)) {
            return new ArrayList<String>(edgeCaseTestingFuzzers);
        }
        return new ArrayList<String>();
    }

    public static List<String> getFuzzersForTestTypes(List<String> testTypes) {
        ArrayList<String> allFuzzers = new ArrayList<String>();
        if (testTypes != null && !testTypes.isEmpty()) {
            for (String testType : testTypes) {
                List<String> fuzzers = APIAITestingConstants.getFuzzersForTestType(testType);
                allFuzzers.addAll(fuzzers);
            }
        }
        return allFuzzers;
    }

    public static List<String> getPositiveTestingFuzzers() {
        return new ArrayList<String>(positiveTestingFuzzers);
    }

    public static List<String> getNegativeTestingFuzzers() {
        return new ArrayList<String>(negativeTestingFuzzers);
    }

    public static List<String> getSecurityTestingFuzzers() {
        return new ArrayList<String>(securityTestingFuzzers);
    }

    public static List<String> getEdgeCaseTestingFuzzers() {
        return new ArrayList<String>(edgeCaseTestingFuzzers);
    }

    public static String getTestTypeFromFuzzer(String fuzzer) {
        if (fuzzer == null || fuzzer.trim().isEmpty()) {
            return null;
        }
        if (positiveTestingFuzzers.contains(fuzzer)) {
            return POSITIVE_TESTING;
        }
        if (negativeTestingFuzzers.contains(fuzzer)) {
            return NEGATIVE_TESTING;
        }
        if (securityTestingFuzzers.contains(fuzzer)) {
            return SECURITY_TESTING;
        }
        if (edgeCaseTestingFuzzers.contains(fuzzer)) {
            return EDGE_CASE_TESTING;
        }
        return null;
    }

    private APIAITestingConstants() {
    }
}

