/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.editor;

import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditor;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.util.MimetypesFileTypeMapUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.webservice.FileBodyContent;
import java.io.File;
import java.text.DecimalFormat;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FileBodyEditor
extends HttpBodyEditor {
    private final long KB = 1024L;
    private final long MB = 0x100000L;
    private final DecimalFormat format = new DecimalFormat("#.##");
    private Text txtFilePath;
    private Button btnFolderChooser;
    private FileBodyContent fileBodyContent;
    private Label fileSizeLabel;
    private Label size;
    private long fileSize;
    Composite mainContent;
    private static final String currentProjectFolder = ProjectController.getInstance().getCurrentProject().getFolderLocation();

    public FileBodyEditor(Composite parent, int style) {
        super(parent, style);
        this.createComponentLayout();
        this.addControlModifyListeners();
    }

    @Override
    public String getContentType() {
        return this.getViewModel().getContentType();
    }

    @Override
    public String getContentData() {
        this.fileBodyContent.setFilePath(this.txtFilePath.getText());
        this.fileBodyContent.setFileSize(this.fileSize);
        String type = MimetypesFileTypeMapUtil.getContentType((String)FilenameUtils.getExtension((String)this.txtFilePath.getText()));
        this.setContentTypeUpdated(!StringUtils.isEmpty((String)type));
        if (StringUtils.isNotEmpty((String)type)) {
            this.fileBodyContent.setContentType(type);
        }
        this.updateViewModel();
        return this.getViewModel().getContentData();
    }

    @Override
    public void setInput(String rawBodyContentData) {
        this.fileBodyContent = StringUtils.isEmpty((String)rawBodyContentData) ? new FileBodyContent() : (FileBodyContent)JsonUtil.fromJson((String)rawBodyContentData, FileBodyContent.class);
        this.updateViewModel();
    }

    @Override
    public void onBodyTypeChanged() {
        if (this.fileBodyContent == null) {
            this.fileBodyContent = new FileBodyContent();
        }
        if (this.fileBodyContent.getFilePath() != null) {
            this.txtFilePath.setText(this.fileBodyContent.getFilePath());
            this.size.setText(this.fommatFileSize(this.fileBodyContent.getContentLength()));
            this.size.getParent().layout();
        }
        this.updateViewModel();
    }

    private void createComponentLayout() {
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        GridLayout filePartLayout = new GridLayout();
        filePartLayout.marginWidth = 15;
        Label filePathLabel = new Label((Composite)this, 0);
        filePathLabel.setText(StringConstants.LBL_FILE_PATH);
        this.txtFilePath = new Text((Composite)this, 2048);
        this.txtFilePath.setLayoutData((Object)new GridData(4, 4, true, false));
        this.txtFilePath.setMessage(currentProjectFolder);
        this.btnFolderChooser = new Button((Composite)this, 0x800000);
        this.btnFolderChooser.setText(StringConstants.DIA_BTN_BROWSE);
        this.fileSizeLabel = new Label((Composite)this, 0);
        this.fileSizeLabel.setText(StringConstants.LBL_FILE_SIZE);
        this.size = new Label((Composite)this, 0);
    }

    private void addControlModifyListeners() {
        if (this.btnFolderChooser == null) {
            return;
        }
        this.btnFolderChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(FileBodyEditor.this.btnFolderChooser.getShell());
                dialog.setFilterPath(currentProjectFolder);
                String path = dialog.open();
                if (path == null) {
                    return;
                }
                String type = MimetypesFileTypeMapUtil.getContentType((String)FilenameUtils.getExtension((String)FileBodyEditor.this.getRelativePath(path)));
                if (!FileBodyEditor.this.txtFilePath.getText().equals(path) && StringUtils.isNotEmpty((String)type)) {
                    FileBodyEditor.this.fileBodyContent.setContentType(type);
                    FileBodyEditor.this.setContentTypeUpdated(true);
                }
                FileBodyEditor.this.notifyListeners(24, new Event());
                File file = new File(path);
                String savePath = file.isAbsolute() && path.contains(currentProjectFolder) ? FileBodyEditor.this.getRelativePath(path) : path;
                FileBodyEditor.this.txtFilePath.setText(savePath);
                if (file.exists() && file.isFile()) {
                    FileBodyEditor.this.fileSize = file.length();
                    FileBodyEditor.this.size.setText(FileBodyEditor.this.fommatFileSize(FileBodyEditor.this.fileSize));
                    FileBodyEditor.this.size.getParent().layout();
                }
            }
        });
        this.txtFilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileBodyEditor.this.fireModifyEvent();
            }
        });
    }

    private String fommatFileSize(long fileSizeBytes) {
        if (fileSizeBytes > 0x100000L) {
            return this.format.format(fileSizeBytes / 0x100000L) + " " + StringConstants.MEGABYTES_UNIT;
        }
        if (fileSizeBytes > 1024L) {
            return this.format.format(fileSizeBytes / 1024L) + " " + StringConstants.KILOBYTES_UNIT;
        }
        return fileSizeBytes + " " + StringConstants.BYTES_UNIT;
    }

    private String getRelativePath(String filePath) {
        File file = new File(filePath);
        if (file.isAbsolute()) {
            return PathUtil.absoluteToRelativePath((String)filePath, (String)currentProjectFolder);
        }
        return filePath;
    }

    private void updateViewModel() {
        this.getViewModel().setContentData(JsonUtil.toJson((Object)this.fileBodyContent));
        this.getViewModel().setContentType(this.fileBodyContent.getContentType());
    }
}

