/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.kms.katalon.composer.ai.generation.dialogs.TestArtifactGenerationDialog;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.openapi.OpenApiImportNode;
import com.kms.katalon.composer.webservice.openapi.OpenApiImporter;
import com.kms.katalon.composer.webservice.openapi.OpenApiProjectImportResult;
import com.kms.katalon.composer.webservice.parser.SwaggerParserUtil;
import com.kms.katalon.composer.webservice.util.OpenAPIUtil;
import com.kms.katalon.composer.webservice.view.ImportOpenApiDialog;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.yaml.snakeyaml.LoaderOptions;

public class ImportOpenApiHandler {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private static final String IMPORTING_OPENAPI_V3_MESSAGE = "You are importing OpenAPI 3, which requires a Studio Enterprise license.";
    private static final int MAX_FILE_SIZE = 0x1400000;
    private static final String OPENAPI_KEY = "openapi";
    @Inject
    private IEclipseContext eclipseContext;

    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && !LauncherManager.getInstance().isAnyLauncherRunning();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Optional Object[] selectedObjects, @Named(value="activeShell") Shell shell) {
        Trackings.trackClickImportOpenAPI();
        String selectedFilePathOrURL = "";
        boolean isAITestCaseGenerate = false;
        String openAPIVersion = "";
        try {
            ApiCollectionEntity apiCollection;
            ImportOpenApiDialog dialog = (ImportOpenApiDialog)((Object)ContextInjectionFactory.make(ImportOpenApiDialog.class, (IEclipseContext)this.eclipseContext));
            if (dialog.open() != 0) return;
            selectedFilePathOrURL = dialog.getSwaggerSpecLocation();
            isAITestCaseGenerate = dialog.isAITestCaseGenerateEnable();
            if (!StringUtils.isNotEmpty((CharSequence)selectedFilePathOrURL)) return;
            ITreeEntity parentTreeEntity = ImportOpenApiHandler.findParentTreeEntity(selectedObjects);
            FolderEntity importFolderEntity = parentTreeEntity == null ? FolderController.getInstance().getObjectRepositoryRoot(ProjectController.getInstance().getCurrentProject()) : (FolderEntity)parentTreeEntity.getObject();
            FolderEntity importedFolder = null;
            String specString = OpenAPIUtil.getSpecificationContent(selectedFilePathOrURL);
            Map<String, Object> specification = this.readSpecification(specString);
            List<Object> importedEntities = new ArrayList();
            String collectionType = null;
            if (specification.get(OPENAPI_KEY) != null) {
                collectionType = ApiCollectionEntity.CollectionType.OPENAPI_3_0.getDisplayName();
                openAPIVersion = specification.get(OPENAPI_KEY).toString();
                if (!this.featureController.canUse(ProductFeature.IMPORT_OPENAPI)) {
                    this.productFeatureDialog.showNotAvailableFeature(ProductFeature.IMPORT_OPENAPI, ComposerComponentsImplMessageConstants.DIA_KSE_FEATURE_TITLE, IMPORTING_OPENAPI_V3_MESSAGE);
                    return;
                }
                OpenApiProjectImportResult projectImportResult = OpenApiImporter.getInstance().importServices(selectedFilePathOrURL, importFolderEntity);
                importedEntities = this.saveImportedArtifacts(projectImportResult);
                importedFolder = projectImportResult.getFileEntity();
            } else {
                if (specification.get("swagger") == null) throw new Exception("Invalid OpenAPI/Swagger format");
                collectionType = ApiCollectionEntity.CollectionType.SWAGGER_2_0.getDisplayName();
                openAPIVersion = specification.get("swagger").toString();
                importedEntities = SwaggerParserUtil.newWSTestObjectsFromSwagger(importFolderEntity, selectedFilePathOrURL);
                this.saveNewTestObject(importedEntities);
                if (importedEntities.size() > 0) {
                    importedFolder = ((WebServiceRequestEntity)importedEntities.get(0)).getParentFolder();
                }
            }
            this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)importedFolder));
            this.getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)importedFolder));
            this.trackImportOpenApi(selectedFilePathOrURL, true, "", openAPIVersion, isAITestCaseGenerate);
            Trackings.trackCreateOrImportApiCollection((String)"imported", (String)importedFolder.getName(), (String)collectionType);
            if (isAITestCaseGenerate && !this.featureController.canUse(ProductFeature.API_TESTCASE_GENERATION)) {
                this.productFeatureDialog.showNotAvailableFeature(ProductFeature.API_TESTCASE_GENERATION);
                return;
            }
            File openAPIFile = this.copyFileToFolder(FilenameUtils.removeExtension((String)FilenameUtils.getName((String)selectedFilePathOrURL)), FilenameUtils.getExtension((String)selectedFilePathOrURL), specString);
            if (specification.get(OPENAPI_KEY) != null && importedFolder instanceof ApiCollectionEntity && (apiCollection = (ApiCollectionEntity)importedFolder).getId() != null) {
                apiCollection.setOpenApiSpecFileName(openAPIFile.getName());
                FolderController.getInstance().saveFolder((FolderEntity)apiCollection);
            }
            if (!isAITestCaseGenerate) return;
            TestArtifactGenerationDialog generationDialog = (TestArtifactGenerationDialog)ContextInjectionFactory.make(TestArtifactGenerationDialog.class, (IEclipseContext)this.eclipseContext);
            generationDialog.setEndpoints(importedEntities);
            generationDialog.setOpenAPIFile(openAPIFile);
            generationDialog.open();
            return;
        }
        catch (Exception e) {
            if (e.getMessage().contains(ComposerWebserviceMessageConstants.TITLE_INVALID_OPENAPI_FORMAT)) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.ERROR_MSG_FAIL_TO_PARSING_OPENAPI);
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR, (String)ComposerWebserviceMessageConstants.ERROR_MSG_FAIL_TO_IMPORT_OPENAPI);
            }
            LoggerSingleton.logError((Throwable)e);
            this.trackImportOpenApi(selectedFilePathOrURL, true, e.getMessage(), openAPIVersion, isAITestCaseGenerate);
        }
    }

    private Map<String, Object> readSpecification(String spec) throws IOException {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x1400000);
        YAMLFactory yamlFactory = YAMLFactory.builder().loaderOptions(loaderOptions).build();
        YAMLMapper mapper = new YAMLMapper(yamlFactory);
        TypeReference<Map<String, Object>> collectionTypeRef = new TypeReference<Map<String, Object>>(){};
        return (Map)mapper.readValue(spec, (TypeReference)collectionTypeRef);
    }

    private List<WebServiceRequestEntity> saveImportedArtifacts(OpenApiProjectImportResult projectImportResult) throws Exception {
        ArrayList<WebServiceRequestEntity> webServiceRequestEntities = new ArrayList<WebServiceRequestEntity>();
        List importNodes = this.flatten(projectImportResult).collect(Collectors.toList());
        for (OpenApiImportNode importNode : importNodes) {
            FileEntity fileEntity = importNode.getFileEntity();
            if (fileEntity != null && fileEntity instanceof FolderEntity) {
                FolderController.getInstance().saveFolder((FolderEntity)fileEntity);
            }
            if (fileEntity == null || !(fileEntity instanceof WebServiceRequestEntity)) continue;
            WebServiceRequestEntity webServiceEntity = (WebServiceRequestEntity)fileEntity;
            ObjectRepositoryController.getInstance().saveNewTestObject((WebElementEntity)webServiceEntity);
            webServiceRequestEntities.add(webServiceEntity);
        }
        return webServiceRequestEntities;
    }

    private void saveNewTestObject(List<WebServiceRequestEntity> requestEntities) throws Exception {
        for (WebServiceRequestEntity entity : requestEntities) {
            ObjectRepositoryController.getInstance().saveNewTestObject((WebElementEntity)entity);
        }
    }

    private Stream<? extends OpenApiImportNode> flatten(OpenApiImportNode importNode) {
        return Stream.concat(Stream.of(importNode), Stream.of(importNode.getChildImportNodes()).flatMap(n -> this.flatten((OpenApiImportNode)n)));
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof WebElementEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    private void trackImportOpenApi(String swaggerSpecLocation, boolean isSuccessed, String errorMessage, String openApiVersion, boolean isUsedAI) {
        try {
            Paths.get(swaggerSpecLocation, new String[0]);
            Trackings.trackImportOpenApi((String)"file", (boolean)isSuccessed, (String)errorMessage, (String)openApiVersion, (boolean)isUsedAI);
        }
        catch (Throwable throwable) {
            Trackings.trackImportOpenApi((String)"url", (boolean)isSuccessed, (String)errorMessage, (String)openApiVersion, (boolean)isUsedAI);
        }
    }

    private FolderEntity getOpenAPIFolder() throws Exception {
        FolderEntity folderEntity = FolderController.getInstance().getFolder(ProjectController.getInstance().getCurrentProject().getFolderLocation() + File.separator + ComposerWebserviceMessageConstants.OPENAPI_SPECIFICATION_FOLDER_NAME);
        if (folderEntity != null) {
            return folderEntity;
        }
        FolderEntity folder = new FolderEntity();
        folder.setName(ComposerWebserviceMessageConstants.OPENAPI_SPECIFICATION_FOLDER_NAME);
        folder.setParentFolder(ProjectController.getInstance().getCurrentProject().getParentFolder());
        folder.setProject(ProjectController.getInstance().getCurrentProject());
        folder.setDescription("openapi specification folder");
        FolderController.getInstance().saveFolder(folder);
        return folder;
    }

    private File copyFileToFolder(String fileName, String extension, String fileContent) throws Exception {
        FolderEntity parentFolder = this.getOpenAPIFolder();
        fileName = EntityNameController.getInstance().getAvailableName(fileName, parentFolder, false);
        String path = parentFolder.getLocation() + File.separator + fileName + "." + extension;
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(fileContent);
        bw.close();
        this.getEventBroker().post("EXPLORER/SET_SELECTED_ITEM", (Object)TreeEntityUtil.getFolderTreeEntity((FolderEntity)parentFolder));
        return file;
    }
}

