/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.importing.model;

import com.kms.katalon.composer.webservice.importing.model.RestParameterImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestRequestImportResult;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportNode;
import com.kms.katalon.composer.webservice.importing.model.RestResourceImportResult;
import com.kms.katalon.composer.webservice.importing.model.WebServiceImportNode;
import com.kms.katalon.entity.folder.FolderEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class RestMethodImportResult
extends RestResourceImportNode {
    private RestResourceImportResult resourceImportResult;
    private String httpMethod;
    private FolderEntity folder;
    private List<RestRequestImportResult> requestImportResults = new ArrayList<RestRequestImportResult>();

    public RestMethodImportResult(String name, RestResourceImportResult resourceResult, String httpMethod) {
        this.resourceImportResult = resourceResult;
        this.httpMethod = httpMethod;
        this.folder = resourceResult.newChildFolder(name);
    }

    public RestResourceImportResult getResourceImportResult() {
        return this.resourceImportResult;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public FolderEntity getFileEntity() {
        return this.folder;
    }

    public List<RestRequestImportResult> getRequestImportResults() {
        return Collections.unmodifiableList(this.requestImportResults);
    }

    public <T extends RestRequestImportResult> T newRequest(String name, Function<String, T> requestSupplier) {
        name = this.getAvailableChildNodeName(name, this.getFileEntity(), false);
        RestRequestImportResult requestResult = (RestRequestImportResult)requestSupplier.apply(name);
        this.resourceImportResult.getParameters().stream().forEach(p -> {
            RestParameterImportResult pr = requestResult.addNewParameter(p.getName());
            pr.setValue(p.getValue());
            pr.setStyle(p.getStyle());
        });
        this.getParameters().stream().forEach(p -> {
            String nm = p.getName();
            RestParameterImportResult pr = requestResult.hasParameter(nm) ? requestResult.getParameter(nm) : requestResult.addNewParameter(nm);
            pr.setValue(p.getValue());
            pr.setStyle(p.getStyle());
        });
        this.requestImportResults.add(requestResult);
        this.addChildNodeName(name);
        return (T)requestResult;
    }

    @Override
    public WebServiceImportNode getParentImportNode() {
        return this.resourceImportResult;
    }

    @Override
    public List<WebServiceImportNode> getChildImportNodes() {
        return Collections.unmodifiableList(this.requestImportResults);
    }
}

