/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.openapi;

import com.kms.katalon.composer.webservice.openapi.OpenApiImportNode;
import com.kms.katalon.composer.webservice.openapi.OpenApiRestParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class OpenApiRestResourceImportNode
extends OpenApiImportNode {
    private List<OpenApiRestParameter> parameters = new ArrayList<OpenApiRestParameter>();

    public OpenApiRestParameter addParameter(String name, String value, String description, OpenApiRestParameter.Style style) {
        OpenApiRestParameter parameter = new OpenApiRestParameter();
        parameter.setName(name);
        parameter.setValue(value);
        parameter.setStyle(style);
        parameter.setDescription(description);
        this.parameters.add(parameter);
        return parameter;
    }

    protected List<OpenApiRestParameter> getQueryParameters() {
        return this.getParametersWithStyle(OpenApiRestParameter.Style.QUERY);
    }

    protected List<OpenApiRestParameter> getHeaderParameters() {
        return this.getParametersWithStyle(OpenApiRestParameter.Style.HEADER);
    }

    protected List<OpenApiRestParameter> getTemplateParameters() {
        return this.getParametersWithStyle(OpenApiRestParameter.Style.TEMPLATE);
    }

    protected List<OpenApiRestParameter> getParametersWithStyle(OpenApiRestParameter.Style style) {
        return this.parameters.stream().filter(p -> p.getStyle() == style).collect(Collectors.toList());
    }

    protected List<OpenApiRestParameter> getParameters() {
        return this.parameters;
    }
}

