/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.parts;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.composer.webservice.editor.HttpBodyEditorComposite;
import com.kms.katalon.composer.webservice.editor.ValidationComposite;
import com.kms.katalon.composer.webservice.parts.WebServicePart;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditorsComposite;
import com.kms.katalon.composer.webservice.response.header.ResponseHeaderEditorsComposite;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.composer.webservice.view.ExpandableComposite;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.WebServiceController;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.authorization.BasicRequestAuthorization;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.webservice.common.HarLogger;
import com.kms.katalon.core.webservice.common.WebServiceMethod;
import com.kms.katalon.core.webservice.helper.RestRequestMethodHelper;
import com.kms.katalon.core.webservice.setting.WebServiceSettingStore;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.entity.webservice.RequestHistoryEntity;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.URLBuilder;
import com.kms.katalon.util.collections.NameValuePair;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RestServicePart
extends WebServicePart {
    private static final String INHERIT_AUTH_FROM_PARENT = ComposerWebserviceMessageConstants.INHERIT_AUTH_FROM_PARENT;
    private static final String BEARER_PREFIX = ComposerWebserviceMessageConstants.BEARER_AUTH_PREFIX_VALUE + " ";
    private WebServiceRequestEntity originalCleanEntity;
    protected HttpBodyEditorComposite requestBodyEditor;
    protected ValidationComposite validationComposite;
    private URLBuilder urlBuilder;
    protected ResponseBodyEditorsComposite responseBodyEditor;
    protected ResponseHeaderEditorsComposite responseHeaderEditor;
    private ProgressMonitorDialogWithThread progress;
    private Label lblBodyNotSupported;
    private ModifyListener requestURLModifyListener;
    private CCombo cbbRequestMethod;
    private Text txtRequestURL;
    private String authTypeTextBeforeSend;

    @Override
    protected void createServiceInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cbbRequestMethod = new CCombo(composite, 2048);
        this.cbbRequestMethod.setBackground(ColorUtil.getWhiteBackgroundColor());
        GridData gdRequestMethod = new GridData(4, 0x1000000, false, false);
        gdRequestMethod.widthHint = 100;
        gdRequestMethod.heightHint = 22;
        this.cbbRequestMethod.setLayoutData((Object)gdRequestMethod);
        this.cbbRequestMethod.setEditable(true);
        this.cbbRequestMethod.setItems(this.getRestRequestMethods());
        this.cbbRequestMethod.setText(this.originalWsObject.getRestRequestMethod());
        this.txtRequestURL = new Text(composite, 2048);
        GridData gdRequestURL = new GridData(4, 0x1000000, true, true);
        gdRequestURL.heightHint = 20;
        this.txtRequestURL.setLayoutData((Object)gdRequestURL);
        this.txtRequestURL.setMessage(StringConstants.PA_LBL_URL);
        String url = this.originalWsObject.getRestUrl();
        if (!StringUtils.trim((String)url).isEmpty()) {
            this.txtRequestURL.setText(url);
        }
        this.createApiControls(composite);
        Composite requestOptions = this.createRequestOptionsComposite(composite);
        requestOptions.setLayoutData((Object)new GridData(-1, -1, true, false, gridLayout.numColumns, 1));
        Composite queryParamsComp = new Composite(composite, 0);
        queryParamsComp.setLayout((Layout)new GridLayout());
        queryParamsComp.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        this.createQueryParamsComposite(queryParamsComp);
        this.registerControlListeners();
        this.registerEventListeners();
    }

    @Override
    protected void addTabAuthorization(CTabFolder parent) {
        super.addTabAuthorization(parent);
        this.ccbAuthType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedValue = RestServicePart.this.ccbAuthType.getText();
                if (INHERIT_AUTH_FROM_PARENT.equals(selectedValue)) {
                    RestServicePart.this.hideAllAuthorizationFields();
                    RestServicePart.this.setDirty(true);
                } else {
                    RestServicePart.this.showRelevantAuthorizationFields();
                    RestServicePart.this.resetCleanEntity();
                }
            }
        });
    }

    protected void createQueryParamsComposite(Composite parent) {
        ExpandableComposite paramsExpandableComposite = new ExpandableComposite(parent, StringConstants.PA_LBL_PARAMS, 1, true);
        Composite paramsComposite = paramsExpandableComposite.createControl();
        GridLayout glParams = (GridLayout)paramsComposite.getLayout();
        glParams.marginLeft = 0;
        glParams.marginRight = 0;
        final ToolBar toolbar = this.createAddRemoveToolBar(paramsComposite, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.tblParams.addRow();
            }
        }, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.deleteSelectedParams();
            }
        });
        this.tblParams = this.createKeyValueTable(paramsComposite, false);
        this.tblParams.setInput(this.params);
        this.tblParams.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                toolbar.getItem(1).setEnabled(RestServicePart.this.tblParams.getTable().getSelectionCount() > 0);
            }
        });
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("WEBSERVICE/UPDATE_METHODS", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this);
    }

    private String[] getRestRequestMethods() {
        List methods;
        WebServiceSettingStore store = this.getWebServiceSettingStore();
        try {
            methods = store.getWebServiceMethods();
        }
        catch (IOException e) {
            LoggerSingleton.logError((String)String.format("Warning: Unexpected error in '%s'.getRestRequestMethods(): ...", this.getClass().getName()));
            LoggerSingleton.logError((Throwable)e);
            methods = store.getDefaultWebServiceMethods();
        }
        return (String[])methods.stream().map(WebServiceMethod::getName).toArray(String[]::new);
    }

    private WebServiceSettingStore getWebServiceSettingStore() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        return WebServiceSettingStore.create((String)project.getFolderLocation());
    }

    private void registerControlListeners() {
        this.requestURLModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                RestServicePart.this.updateParamsTable(text.getText());
                RestServicePart.this.setDirty(true);
            }
        };
        this.txtRequestURL.addModifyListener(this.requestURLModifyListener);
        this.cbbRequestMethod.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
                RestServicePart.this.setDirty(true);
            }
        });
        this.cbbRequestMethod.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RestServicePart.this.setTabBodyContentBasedOnRequestMethod();
                RestServicePart.this.setDirty(true);
            }
        });
        this.cbbRequestMethod.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (StringUtils.isBlank((CharSequence)RestServicePart.this.cbbRequestMethod.getText())) {
                    RestServicePart.this.cbbRequestMethod.select(0);
                }
                RestServicePart.this.setDirty(true);
            }
        });
    }

    @Override
    protected void sendRequest(final boolean runVerificationScript) {
        this.hasResponseBodyAfterSendingRequest = false;
        if (this.dirtyable.isDirty()) {
            boolean isOK = MessageDialog.openConfirm(null, (String)StringConstants.WARN, (String)ComposerWebserviceMessageConstants.PART_MSG_DO_YOU_WANT_TO_SAVE_THE_CHANGES);
            if (!isOK) {
                return;
            }
            this.save();
        }
        this.authTypeTextBeforeSend = this.ccbAuthType != null && !this.ccbAuthType.isDisposed() ? this.ccbAuthType.getText() : null;
        this.resolveInheritedAuthorization();
        this.clearPreviousResponse();
        if (this.wsApiControl.getSendingState()) {
            this.progress.getProgressMonitor().setCanceled(true);
            this.wsApiControl.setSendButtonState(false);
            return;
        }
        try {
            WebServiceUtil.setHttpsProtocol();
            boolean isValidateJsonAgainstJson = this.isValidateJsonAganistSchema(this.validationComposite.getValidationSteps());
            boolean isValidateXMLAgainstSchema = this.isValidateXMLAganistSchema(this.validationComposite.getValidationSteps());
            boolean isValidateGraphQLAgainstSchema = this.isValidateGraphQLAgainstSchema(this.validationComposite.getValidationSteps());
            boolean isValidatedOpenApiAgainstSpecification = this.isValidatedOpenApiAgainstSpecification(this.validationComposite.getValidationSteps());
            String requestType = this.getRequestType(this.getWSRequestObject());
            Trackings.trackTestWebServiceObject((boolean)runVerificationScript, (boolean)(this.getOriginalWsObject() instanceof DraftWebServiceRequestEntity), (String)this.getTrackingValueForAuthorizationType(), (boolean)isValidateJsonAgainstJson, (boolean)isValidateXMLAgainstSchema, (boolean)isValidateGraphQLAgainstSchema, (boolean)isValidatedOpenApiAgainstSpecification, (String)requestType);
            this.wsApiControl.setSendButtonState(true);
            this.progress = new ProgressMonitorDialogWithThread(Display.getCurrent().getActiveShell());
            this.progress.setOpenOnRun(false);
            this.displayResponseContentBasedOnSendingState(true);
            this.progress.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    RequestObject requestObject;
                    ResponseObject responseObject;
                    block7: {
                        monitor.beginTask(ComposerWebserviceMessageConstants.PART_MSG_SENDING_TEST_REQUEST, -1);
                        String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                        WebServiceRequestEntity requestEntity = RestServicePart.this.getWSRequestObject();
                        RestServicePart.this.configRequest(requestEntity);
                        Map<String, Object> evaluatedVariables = RestServicePart.this.evaluateRequestVariables();
                        HarLogger harLogger = new HarLogger();
                        harLogger.initHarFile();
                        responseObject = WebServiceController.getInstance().sendRequest(requestEntity, projectDir, ProxyPreferences.getSystemProxyInformation(), Collections.unmodifiableMap(evaluatedVariables), false);
                        RestServicePart.this.deleteTempHarFile();
                        requestObject = WebServiceController.getRequestObject((WebServiceRequestEntity)requestEntity, (String)projectDir, Collections.unmodifiableMap(evaluatedVariables));
                        String logFolder = Files.createTempDirectory("har", new FileAttribute[0]).toFile().getAbsolutePath();
                        RestServicePart.this.harFile = harLogger.logHarFile(requestObject, responseObject, logFolder);
                        if (!monitor.isCanceled()) break block7;
                        RestServicePart.this.restoreOriginalCleanEntity();
                        UISynchronizeService.syncExec(() -> {
                            if (RestServicePart.this.ccbAuthType != null && !RestServicePart.this.ccbAuthType.isDisposed() && RestServicePart.this.authTypeTextBeforeSend != null) {
                                RestServicePart.this.ccbAuthType.setText(RestServicePart.this.authTypeTextBeforeSend);
                                if (INHERIT_AUTH_FROM_PARENT.equals(RestServicePart.this.authTypeTextBeforeSend)) {
                                    RestServicePart.this.hideAllAuthorizationFields();
                                } else {
                                    RestServicePart.this.showRelevantAuthorizationFields();
                                }
                            }
                        });
                        UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        return;
                    }
                    try {
                        try {
                            RestServicePart.this.hasResponseBodyAfterSendingRequest = responseObject != null && responseObject.getResponseBodySize() > 0L;
                            String bodyContent = responseObject.getResponseText();
                            Display.getDefault().asyncExec(() -> {
                                RestServicePart.this.setResponseStatus(responseObject);
                                RestServicePart.this.responseHeaderEditor.setInput(responseObject);
                                if (bodyContent == null) {
                                    return;
                                }
                                RestServicePart.this.responseBodyEditor.setInput(responseObject);
                            });
                            if (runVerificationScript) {
                                RestServicePart.this.executeVerificationScript(responseObject);
                            }
                            if (runVerificationScript) {
                                RestServicePart.this.executeValidationSteps(requestObject, responseObject);
                                UISynchronizeService.syncExec(() -> {
                                    RestServicePart.this.validationComposite.updateResults(requestObject.getValidationSteps());
                                    RestServicePart.this.getWSRequestObject().setValidationSteps(RestServicePart.this.validationComposite.getPureValidationSteps());
                                    RestServicePart.this.updateValidationResult(requestObject.getValidationSteps());
                                });
                            }
                            RequestHistoryEntity requestHistoryEntity = new RequestHistoryEntity(new Date(), (WebServiceRequestEntity)RestServicePart.this.getWSRequestObject().clone());
                            RestServicePart.this.eventBroker.post("WS_VERIFICATION/FINISHED", (Object)new Object[]{requestHistoryEntity});
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        RestServicePart.this.restoreOriginalCleanEntity();
                        UISynchronizeService.syncExec(() -> {
                            if (RestServicePart.this.ccbAuthType != null && !RestServicePart.this.ccbAuthType.isDisposed() && RestServicePart.this.authTypeTextBeforeSend != null) {
                                RestServicePart.this.ccbAuthType.setText(RestServicePart.this.authTypeTextBeforeSend);
                                if (INHERIT_AUTH_FROM_PARENT.equals(RestServicePart.this.authTypeTextBeforeSend)) {
                                    RestServicePart.this.hideAllAuthorizationFields();
                                } else {
                                    RestServicePart.this.showRelevantAuthorizationFields();
                                }
                            }
                        });
                        UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                        monitor.done();
                        throw throwable;
                    }
                    RestServicePart.this.restoreOriginalCleanEntity();
                    UISynchronizeService.syncExec(() -> {
                        if (RestServicePart.this.ccbAuthType != null && !RestServicePart.this.ccbAuthType.isDisposed() && RestServicePart.this.authTypeTextBeforeSend != null) {
                            RestServicePart.this.ccbAuthType.setText(RestServicePart.this.authTypeTextBeforeSend);
                            if (INHERIT_AUTH_FROM_PARENT.equals(RestServicePart.this.authTypeTextBeforeSend)) {
                                RestServicePart.this.hideAllAuthorizationFields();
                            } else {
                                RestServicePart.this.showRelevantAuthorizationFields();
                            }
                        }
                    });
                    UISynchronizeService.syncExec(() -> RestServicePart.this.wsApiControl.setSendButtonState(false));
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target == null) {
                return;
            }
            LoggerSingleton.logError((String)String.format("Warning: Unexpected error in '%s'.sendRequest(): ...", this.getClass().getName()));
            LoggerSingleton.logError((Throwable)target);
            MultiStatusErrorDialog.showErrorDialog((String)ComposerWebserviceMessageConstants.PART_MSG_CANNOT_SEND_THE_TEST_REQUEST, (String)target.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)target));
        }
        catch (InterruptedException interruptedException) {}
        this.displayResponseContentBasedOnSendingState(false);
    }

    @Override
    protected ResponseObject getResponseObjectFromEditor() {
        return this.responseBodyEditor.getResponseObject();
    }

    private void setTabBodyContentBasedOnRequestMethod() {
        GridData gdLblBodyNotSupported = (GridData)this.lblBodyNotSupported.getLayoutData();
        GridData gdRequestBodyEditor = (GridData)this.requestBodyEditor.getLayoutData();
        if (this.isBodySupported()) {
            gdLblBodyNotSupported.exclude = true;
            this.lblBodyNotSupported.setVisible(false);
            gdRequestBodyEditor.exclude = false;
            this.requestBodyEditor.setVisible(true);
        } else {
            gdLblBodyNotSupported.exclude = false;
            this.lblBodyNotSupported.setVisible(true);
            this.lblBodyNotSupported.setText(String.format(ComposerWebserviceMessageConstants.LBL_BODY_NOT_SUPPORTED, this.cbbRequestMethod.getText()));
            gdRequestBodyEditor.exclude = true;
            this.requestBodyEditor.setVisible(false);
        }
        this.lblBodyNotSupported.getParent().requestLayout();
    }

    protected boolean isBodySupported() {
        String requestMethod = this.cbbRequestMethod.getText();
        return RestRequestMethodHelper.isBodySupported((String)requestMethod);
    }

    private void updateParamsTable(String newUrl) {
        this.params = this.extractRestParameters(newUrl);
        this.tblParams.setInput(this.params);
        this.tblParams.refresh();
    }

    private List<WebElementPropertyEntity> extractRestParameters(String url) {
        ArrayList<WebElementPropertyEntity> paramEntities = new ArrayList();
        this.urlBuilder = new URLBuilder(url);
        List params = this.urlBuilder.getQueryParams();
        paramEntities = params.stream().map(param -> new WebElementPropertyEntity(param.getName(), param.getValue())).collect(Collectors.toList());
        return paramEntities;
    }

    @Override
    protected Composite createRequestOptionsComposite(Composite parent) {
        Composite requestOptionsComposite = super.createRequestOptionsComposite(parent);
        this.createCustomizeApiMethodsLink(requestOptionsComposite);
        this.createSetRequestTimeoutLink(requestOptionsComposite);
        return requestOptionsComposite;
    }

    private void createCustomizeApiMethodsLink(Composite parent) {
        Link lnkCustomizeApiMethods = new Link(parent, 0);
        lnkCustomizeApiMethods.setText(StringConstants.LINK_CUSTOMIZE_API_METHODS);
        lnkCustomizeApiMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RestServicePart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.kms.katalon.composer.webui.setting.testdesign.webservice.custommethod");
            }
        });
    }

    private void createSetRequestTimeoutLink(Composite parent) {
        Link lnkSetTimeout = new Link(parent, 0);
        lnkSetTimeout.setText(StringConstants.LINK_SET_REQUEST_TIMEOUT_AND_LIMIT);
        lnkSetTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RestServicePart.this.featureController.canUse(ProductFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT)) {
                    RestServicePart.this.eventBroker.post("PROJECT/SETTINGS_PAGE", (Object)"com.kms.katalon.composer.execution.settings.webservice");
                } else {
                    RestServicePart.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT);
                }
            }
        });
    }

    @Override
    protected void deleteSelectedParams() {
        int[] selectionIndices = this.tblParams.getTable().getSelectionIndices();
        if (selectionIndices == null || selectionIndices.length == 0) {
            return;
        }
        HashSet<Integer> selectionIndexSet = new HashSet<Integer>();
        int[] nArray = selectionIndices;
        int n = selectionIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            selectionIndexSet.add(index);
            ++n2;
        }
        Object paramProperties = this.tblParams.getInput();
        ArrayList<WebElementPropertyEntity> unselectedParamProperties = new ArrayList<WebElementPropertyEntity>();
        IntStream.range(0, paramProperties.size()).filter(i -> !selectionIndexSet.contains(i)).forEach(arg_0 -> RestServicePart.lambda$4(unselectedParamProperties, (List)paramProperties, arg_0));
        this.tblParams.setInput(unselectedParamProperties);
        this.tblParams.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.tblParams.getTable().redraw();
        }
        this.updateRequestUrlWithNewParams(unselectedParamProperties);
        this.setDirty(true);
    }

    private void updateRequestUrlWithNewParams(List<WebElementPropertyEntity> paramProperties) {
        if (this.urlBuilder == null) {
            this.urlBuilder = new URLBuilder();
        }
        List<NameValuePair> params = this.toNameValuePair(paramProperties);
        this.urlBuilder.setParameters(params);
        String newUrl = this.urlBuilder.buildString();
        this.txtRequestURL.removeModifyListener(this.requestURLModifyListener);
        this.txtRequestURL.setText(newUrl);
        this.txtRequestURL.addModifyListener(this.requestURLModifyListener);
    }

    private List<NameValuePair> toNameValuePair(List<WebElementPropertyEntity> propertyEntities) {
        return propertyEntities.stream().map(pr -> new NameValuePair(pr.getName(), pr.getValue())).collect(Collectors.toList());
    }

    @Override
    protected void handleRequestParamNameChanged(Object element, Object value) {
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String) {
            WebElementPropertyEntity paramProperty = (WebElementPropertyEntity)element;
            paramProperty.setName((String)value);
            this.tblParams.refresh();
            this.tblParams.markDirty();
            Object paramProperties = this.tblParams.getInput();
            this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)paramProperties);
        }
    }

    @Override
    protected void handleRequestParamValueChanged(Object element, Object value) {
        if (element != null && element instanceof WebElementPropertyEntity && value != null && value instanceof String) {
            WebElementPropertyEntity paramProperty = (WebElementPropertyEntity)element;
            paramProperty.setValue((String)value);
            this.tblParams.refresh();
            this.tblParams.markDirty();
            Object paramProperties = this.tblParams.getInput();
            this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)paramProperties);
        }
    }

    @Override
    protected void addTabBody(CTabFolder parent) {
        super.addTabBody(parent);
        Composite tabComposite = (Composite)this.tabBody.getControl();
        Composite tabBodyComposite = new Composite(tabComposite, 0);
        tabBodyComposite.setLayout((Layout)new GridLayout());
        this.requestBodyEditor = new HttpBodyEditorComposite(tabBodyComposite, 0, this);
        this.requestBodyEditor.setLayoutData(new GridData(4, 4, true, true));
        this.lblBodyNotSupported = new Label(tabBodyComposite, 0);
        this.lblBodyNotSupported.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    @Override
    protected void addTabValidation(CTabFolder parent) {
        super.addTabValidation(parent);
        Composite tabComposite = (Composite)this.tabValidation.getControl();
        this.validationComposite = new ValidationComposite(tabComposite, 0);
        this.validationComposite.addListener(24, event -> this.setDirty(true));
    }

    @Override
    protected void createResponseComposite(Composite parent) {
        super.createResponseComposite(parent);
        this.responseBodyEditor = new ResponseBodyEditorsComposite(this.responseBodyComposite, 0, this);
        this.responseBodyEditor.setLayoutData(new GridData(4, 4, true, true));
        this.responseHeaderEditor = new ResponseHeaderEditorsComposite(this.responseHeaderComposite, 0);
        this.responseHeaderEditor.setLayoutData(new GridData(4, 4, true, true));
    }

    @Override
    protected SourceViewer createSourceViewer(Composite parent, GridData layoutData) {
        SourceViewer sv = super.createSourceViewer(parent, layoutData);
        sv.configure(new SourceViewerConfiguration());
        return sv;
    }

    @Override
    protected void preSaving() {
        this.handleInheritancePersistence();
        this.tblParams.removeEmptyProperty();
        this.updateRequestUrlWithNewParams((List<WebElementPropertyEntity>)this.tblParams.getInput());
        this.originalWsObject.setRestUrl(this.getRequestURL());
        String requestMethod = this.getRequestMethod();
        this.originalWsObject.setRestRequestMethod(requestMethod);
        this.tblHeaders.removeEmptyProperty();
        this.originalWsObject.setHttpHeaderProperties((List)this.tblHeaders.getInput());
        if (this.requestBodyEditor.getHttpBodyType() != null) {
            String bodyType = this.requestBodyEditor.getHttpBodyType();
            String bodyContent = this.requestBodyEditor.getHttpBodyContent();
            this.originalWsObject.setHttpBodyContent(bodyContent);
            this.originalWsObject.setHttpBodyType(bodyType);
        }
        this.originalWsObject.setAutoUpdateContent(this.requestBodyEditor.isAutoUpdateContent());
        this.originalWsObject.setValidationSteps(this.validationComposite.getPureValidationSteps());
        this.updatePartImage();
    }

    private void handleInheritancePersistence() {
        if (this.originalWsObject == null) {
            LoggerSingleton.logError((String)"originalWsObject is null in handleInheritancePersistence()");
            return;
        }
        Runnable clearAuthorizationHeaders = () -> {
            if (this.tblHeaders != null && this.tblHeaders.getInput() != null) {
                Object headers = this.tblHeaders.getInput();
                headers.removeIf(h -> "Authorization".equalsIgnoreCase(h.getName()) || h.getName() != null && h.getName().startsWith("Authorization:"));
                this.tblHeaders.refresh();
            }
        };
        if (INHERIT_AUTH_FROM_PARENT.equals(this.ccbAuthType.getText())) {
            this.originalWsObject.setAuthorizationRequest(null);
            clearAuthorizationHeaders.run();
        } else if (ComposerWebserviceMessageConstants.NO_AUTH.equals(this.ccbAuthType.getText()) && !this.isCalculatedDefault()) {
            try {
                BasicRequestAuthorization noAuth = new BasicRequestAuthorization();
                noAuth.setAuthorizationType(ComposerWebserviceMessageConstants.NO_AUTH);
                this.originalWsObject.setAuthorizationRequest(noAuth);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)"Failed to create 'No Authorization' authorization object");
            }
        }
    }

    @Override
    protected void populateDataToUI() {
        super.populateDataToUI();
        WebServiceRequestEntity clone = (WebServiceRequestEntity)this.originalWsObject.clone();
        String restUrl = clone.getRestUrl();
        this.setRequestURL(restUrl);
        this.updateParamsTable(restUrl);
        this.tempPropList = new ArrayList(clone.getHttpHeaderProperties());
        this.httpHeaders.clear();
        this.httpHeaders.addAll(this.tempPropList);
        this.tblHeaders.refresh();
        if (this.hasExplicitAuthorization()) {
            this.applyModelAuthorizationToUI();
        }
        this.updateHeaders(clone);
        this.requestBodyEditor.setInput(clone);
        this.validationComposite.setValidationSteps(clone.getValidationSteps());
        this.populateVariableManualView();
        this.populateVariableScriptView();
        this.reloadVerificationScript();
        this.handleInheritanceUI();
        this.dirtyable.setDirty(false);
    }

    private void setAuthorizationTypeFromModel() {
        String dropdownText;
        String authType;
        if (this.originalWsObject.getAuthorizationRequest() != null && (authType = this.originalWsObject.getAuthorizationRequest().getAuthorizationType()) != null && (dropdownText = this.mapModelAuthTypeToDropdownText(authType)) != null) {
            this.ccbAuthType.setText(dropdownText);
            return;
        }
        String headerBasedAuthType = this.detectAuthTypeFromHeaders(this.httpHeaders);
        if (headerBasedAuthType != null) {
            this.ccbAuthType.setText(headerBasedAuthType);
            return;
        }
    }

    private String detectAuthTypeFromHeaders(List<WebElementPropertyEntity> headers) {
        if (headers == null) {
            return null;
        }
        for (WebElementPropertyEntity header : headers) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            if (headerName.equalsIgnoreCase("Authorization")) {
                if (headerValue == null) continue;
                if (headerValue.startsWith("Basic ")) {
                    return ComposerWebserviceMessageConstants.BASIC_AUTH;
                }
                if (!headerValue.startsWith(BEARER_PREFIX)) continue;
                return "Bearer";
            }
            if (!headerName.equalsIgnoreCase("Authorization:type")) continue;
            return headerValue;
        }
        return null;
    }

    private String mapModelAuthTypeToDropdownText(String modelAuthType) {
        switch (modelAuthType) {
            case "Basic": {
                return ComposerWebserviceMessageConstants.BASIC_AUTH;
            }
            case "Bearer": {
                return "Bearer";
            }
            case "NTLM": {
                return "NTLM";
            }
            case "OAuth 1.0": {
                return "OAuth 1.0";
            }
            case "OAuth2": {
                return "OAuth 2.0";
            }
            case "AWS Signature": {
                return "AWS Signature";
            }
            case "Digest": {
                return ComposerWebserviceMessageConstants.DIGEST_AUTH;
            }
        }
        return null;
    }

    private void handleInheritanceUI() {
        if (this.getImmediateCollectionParentId() != null) {
            String[] items = this.ccbAuthType.getItems();
            boolean hasInheritance = false;
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (INHERIT_AUTH_FROM_PARENT.equals(item)) {
                    hasInheritance = true;
                    break;
                }
                ++n2;
            }
            if (!hasInheritance) {
                this.ccbAuthType.add(INHERIT_AUTH_FROM_PARENT, 0);
            }
        } else {
            String[] items = this.ccbAuthType.getItems();
            int i = 0;
            while (i < items.length) {
                if (INHERIT_AUTH_FROM_PARENT.equals(items[i])) {
                    this.ccbAuthType.remove(i);
                    break;
                }
                ++i;
            }
        }
        if (this.hasExplicitAuthorization()) {
            this.handleExplicitAuthorization();
        } else {
            this.showCalculatedDefault();
        }
    }

    private boolean hasExplicitAuthorization() {
        if (this.originalWsObject.getAuthorizationRequest() != null) {
            return true;
        }
        if (this.originalWsObject.getHttpHeaderProperties() != null) {
            for (WebElementPropertyEntity header : this.originalWsObject.getHttpHeaderProperties()) {
                String headerName = header.getName();
                if (!headerName.equalsIgnoreCase("Authorization") && !headerName.startsWith("Authorization:")) continue;
                return true;
            }
        }
        return false;
    }

    private void handleExplicitAuthorization() {
        if (this.originalWsObject.getAuthorizationRequest() != null) {
            String authType = this.originalWsObject.getAuthorizationRequest().getAuthorizationType();
            if (ComposerWebserviceMessageConstants.NO_AUTH.equals(authType)) {
                this.ccbAuthType.setText(ComposerWebserviceMessageConstants.NO_AUTH);
            } else {
                String dropdownText = this.mapModelAuthTypeToDropdownText(authType);
                if (dropdownText != null) {
                    this.ccbAuthType.setText(dropdownText);
                }
            }
        } else {
            String dropdownText;
            String authTypeFromHeaders = this.detectAuthTypeFromHeaders(this.originalWsObject.getHttpHeaderProperties());
            if (authTypeFromHeaders != null && (dropdownText = this.mapModelAuthTypeToDropdownText(authTypeFromHeaders)) != null) {
                this.ccbAuthType.setText(dropdownText);
            }
        }
    }

    private void showCalculatedDefault() {
        if (this.getImmediateCollectionParentId() != null) {
            this.ccbAuthType.setText(INHERIT_AUTH_FROM_PARENT);
            this.hideAllAuthorizationFields();
        } else {
            this.ccbAuthType.setText(ComposerWebserviceMessageConstants.NO_AUTH);
        }
    }

    private boolean isCalculatedDefault() {
        String currentAuthType = this.ccbAuthType.getText();
        if (this.getImmediateCollectionParentId() != null) {
            return INHERIT_AUTH_FROM_PARENT.equals(currentAuthType);
        }
        return ComposerWebserviceMessageConstants.NO_AUTH.equals(currentAuthType);
    }

    private String getRequestURL() {
        return this.txtRequestURL.getText();
    }

    private void setRequestURL(String url) {
        this.txtRequestURL.setText(url);
    }

    private String getRequestMethod() {
        return this.cbbRequestMethod.getText();
    }

    @Override
    public void updateHeaders(WebServiceRequestEntity cloneWS) {
        this.tempPropList = new ArrayList(cloneWS.getHttpHeaderProperties());
        HashMap<String, WebElementPropertyEntity> headersMap = new HashMap<String, WebElementPropertyEntity>();
        for (WebElementPropertyEntity header : this.httpHeaders) {
            headersMap.put(header.getName(), header);
        }
        for (WebElementPropertyEntity prop : this.tempPropList) {
            WebElementPropertyEntity existingHeader = (WebElementPropertyEntity)headersMap.get(prop.getName());
            if (existingHeader != null) {
                existingHeader.setIsSelected(prop.getIsSelected());
                existingHeader.setMatchCondition(prop.getMatchCondition());
                existingHeader.setType(prop.getType());
                existingHeader.setValue(prop.getValue());
                continue;
            }
            this.httpHeaders.add(prop);
        }
        this.tblHeaders.refresh();
    }

    @PreDestroy
    public void preClose() {
        if (this.progress != null) {
            this.progress.getProgressMonitor().setCanceled(true);
        }
    }

    @Override
    protected void updatePartImage() {
        this.updateIconURL(WebServiceUtil.getRequestMethodIcon(this.originalWsObject.getServiceType(), this.originalWsObject.getRestRequestMethod()));
    }

    public boolean isDirty() {
        return this.mPart.isDirty();
    }

    @Override
    public void handleEvent(Event event) {
        Object[] eventArray;
        Object eventData;
        super.handleEvent(event);
        if (this.cbbRequestMethod == null || this.cbbRequestMethod.isDisposed()) {
            return;
        }
        if ("WEBSERVICE/UPDATE_METHODS".equals(event.getTopic())) {
            this.cbbRequestMethod.setItems(this.getRestRequestMethods());
        }
        if ("EXPLORER/RENAMED_SELECTED_ITEM".equals(event.getTopic()) && (eventData = EventUtil.getData((Event)event)) instanceof Object[] && (eventArray = (Object[])eventData).length == 2) {
            String oldPath = (String)eventArray[0];
            String newPath = (String)eventArray[1];
            if (this.originalWsObject != null && this.originalWsObject.getParentFolder() != null) {
                boolean isAffected;
                String currentEntityPath = this.originalWsObject.getRelativePathForUI().replace('\\', '/') + "/";
                this.originalWsObject.getName();
                String currentParentPath = currentEntityPath.substring(0, currentEntityPath.lastIndexOf(47));
                String oldParentPath = oldPath.substring(0, oldPath.lastIndexOf(47));
                String newParentPath = newPath.substring(0, newPath.lastIndexOf(47));
                boolean isEntityRenamed = oldParentPath.equals(newParentPath) && oldParentPath.equals(currentParentPath);
                boolean isParentAffected = false;
                Object reconstructedOldPath = currentEntityPath;
                if (oldPath.endsWith("/") && newPath.endsWith("/")) {
                    reconstructedOldPath = currentEntityPath.replace(newPath, oldPath);
                } else if (!oldPath.endsWith("/") && !newPath.endsWith("/")) {
                    reconstructedOldPath = currentEntityPath.replace(newPath + "/", oldPath + "/");
                }
                if (oldPath.endsWith("/")) {
                    isParentAffected = ((String)reconstructedOldPath).startsWith(oldPath);
                } else {
                    String reconstructedWithoutSlash = ((String)reconstructedOldPath).substring(0, ((String)reconstructedOldPath).length() - 1);
                    isParentAffected = reconstructedWithoutSlash.startsWith(oldPath);
                }
                boolean bl = isAffected = isEntityRenamed || isParentAffected;
                if (isAffected) {
                    try {
                        String targetPath;
                        if (isEntityRenamed) {
                            targetPath = newPath;
                        } else {
                            String cur = currentEntityPath;
                            Object oldP = oldPath.endsWith("/") ? oldPath : oldPath + "/";
                            Object newP = newPath.endsWith("/") ? newPath : newPath + "/";
                            String rebuilt = cur.replace((CharSequence)oldP, (CharSequence)newP);
                            targetPath = rebuilt.endsWith("/") ? rebuilt.substring(0, rebuilt.length() - 1) : rebuilt;
                        }
                        String newEntityId = this.constructNewEntityId(targetPath);
                        this.reloadWebServiceRequest(newEntityId);
                        if (this.originalWsObject != null) {
                            this.mPart.setLabel(this.originalWsObject.getName());
                        } else {
                            String fallbackName = PathUtil.extractFolderName((String)newPath);
                            this.mPart.setLabel(fallbackName);
                            this.mPart.setTooltip(PathUtil.extractFolderTooltip((String)newPath));
                        }
                        return;
                    }
                    catch (Exception exception) {
                        String fallbackName = PathUtil.extractFolderName((String)newPath);
                        this.mPart.setLabel(fallbackName);
                        this.mPart.setTooltip(PathUtil.extractFolderTooltip((String)newPath));
                    }
                }
            }
        }
    }

    private String getImmediateCollectionParentId() {
        FolderEntity immediateParent = this.originalWsObject.getParentFolder();
        if (immediateParent instanceof ApiCollectionEntity) {
            return immediateParent.getId();
        }
        return null;
    }

    private BasicRequestAuthorization findInheritedAuthorization() {
        FolderEntity currentFolder = this.originalWsObject.getParentFolder();
        while (currentFolder != null) {
            if (!(currentFolder instanceof ApiCollectionEntity)) break;
            ApiCollectionEntity apiCollection = (ApiCollectionEntity)currentFolder;
            BasicRequestAuthorization auth = apiCollection.getAuthorization();
            if (auth != null) {
                return auth;
            }
            currentFolder = currentFolder.getParentFolder();
        }
        return null;
    }

    private WebElementPropertyEntity createBasicAuthHeaderElementFromInherited(BasicRequestAuthorization auth) {
        Map authInfo = auth.getAuthorizationInfo();
        if (authInfo == null) {
            return new WebElementPropertyEntity("Authorization", "");
        }
        String username = (String)authInfo.get("username");
        String password = (String)authInfo.get("password");
        if (username != null && password != null) {
            String encoded = Base64.basicEncode((String)username, (String)password);
            return new WebElementPropertyEntity("Authorization", "Basic " + encoded);
        }
        return new WebElementPropertyEntity("Authorization", "");
    }

    private WebElementPropertyEntity createBearerHeaderElementFromInherited(BasicRequestAuthorization auth) {
        Map authInfo = auth.getAuthorizationInfo();
        if (authInfo == null) {
            return new WebElementPropertyEntity("Authorization", "");
        }
        String token = (String)authInfo.get("bearerToken");
        if (token != null) {
            return new WebElementPropertyEntity("Authorization", BEARER_PREFIX + token);
        }
        return new WebElementPropertyEntity("Authorization", "");
    }

    private void createOAuth1HeadersFromInherited(BasicRequestAuthorization auth, List<WebElementPropertyEntity> targetList) {
        String realm;
        String tokenSecret;
        String token;
        String signatureMethod;
        String consumerSecret;
        Map authInfo = auth.getAuthorizationInfo();
        if (authInfo == null) {
            return;
        }
        ArrayList<WebElementPropertyEntity> oauth1Headers = new ArrayList<WebElementPropertyEntity>();
        oauth1Headers.add(new WebElementPropertyEntity("Authorization:type", "OAuth 1.0"));
        String consumerKey = (String)authInfo.get("oauth_consumer_key");
        if (consumerKey != null) {
            oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_key", consumerKey));
        }
        if ((consumerSecret = (String)authInfo.get("oauth_consumer_secret")) != null) {
            oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_secret", consumerSecret));
        }
        if ((signatureMethod = (String)authInfo.get("oauth_signature_method")) != null) {
            oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_signature_method", signatureMethod));
        }
        if ((token = (String)authInfo.get("oauth_token")) != null) {
            oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_token", token));
        }
        if ((tokenSecret = (String)authInfo.get("oauth_token_secret")) != null) {
            oauth1Headers.add(new WebElementPropertyEntity("Authorization:oauth_token_secret", tokenSecret));
        }
        if ((realm = (String)authInfo.get("oauth_realm")) != null) {
            oauth1Headers.add(new WebElementPropertyEntity("Authorization:realm", realm));
        }
        targetList.addAll(oauth1Headers);
    }

    private void createOAuth2HeadersFromInherited(BasicRequestAuthorization auth, List<WebElementPropertyEntity> targetList) {
        String state;
        String scope;
        String tokenType;
        String clientSecret;
        String clientId;
        String accessToken;
        Map authInfo = auth.getAuthorizationInfo();
        if (authInfo == null) {
            return;
        }
        ArrayList<WebElementPropertyEntity> oauth2Headers = new ArrayList<WebElementPropertyEntity>();
        String grantType = (String)authInfo.get("grant_type");
        if (grantType != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization:type", "OAuth 2.0"));
        }
        if ((accessToken = (String)authInfo.get("access_token")) != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization", BEARER_PREFIX + accessToken));
        }
        if ((clientId = (String)authInfo.get("client_id")) != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_key", clientId));
        }
        if ((clientSecret = (String)authInfo.get("client_secret")) != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization:oauth_consumer_secret", clientSecret));
        }
        if ((tokenType = (String)authInfo.get("token_type")) != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization:token_type", tokenType));
        }
        if ((scope = (String)authInfo.get("scope")) != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization:scope", scope));
        }
        if ((state = (String)authInfo.get("state")) != null) {
            oauth2Headers.add(new WebElementPropertyEntity("Authorization:state", state));
        }
        targetList.addAll(oauth2Headers);
    }

    private void clearAllAuthorizationData() {
        this.httpHeaders.removeIf(header -> header.getName().equalsIgnoreCase("Authorization") || header.getName().startsWith("Authorization:"));
        this.originalWsObject.setAuthorizationRequest(null);
        if (this.tblHeaders != null) {
            this.tblHeaders.refresh();
        }
    }

    private void addInheritedHeadersToEntity(WebServiceRequestEntity entity, BasicRequestAuthorization auth) {
        String authType = auth.getAuthorizationType();
        if (authType == null) {
            return;
        }
        entity.getHttpHeaderProperties().removeIf(header -> header.getName().equalsIgnoreCase("Authorization") || header.getName().startsWith("Authorization:"));
        entity.setAuthorizationRequest(null);
        if (ComposerWebserviceMessageConstants.BASIC_AUTH.equals(authType)) {
            WebElementPropertyEntity header2 = this.createBasicAuthHeaderElementFromInherited(auth);
            entity.getHttpHeaderProperties().add(header2);
        } else if ("Bearer".equals(authType)) {
            entity.setAuthorizationRequest(auth);
            WebElementPropertyEntity header3 = this.createBearerHeaderElementFromInherited(auth);
            entity.getHttpHeaderProperties().add(header3);
        } else if ("OAuth 1.0".equals(authType)) {
            entity.setAuthorizationRequest(auth);
            this.createOAuth1HeadersFromInherited(auth, entity.getHttpHeaderProperties());
        } else if ("OAuth 2.0".equals(authType)) {
            entity.setAuthorizationRequest(auth);
            this.createOAuth2HeadersFromInherited(auth, entity.getHttpHeaderProperties());
        } else if ("NTLM".equals(authType) || ComposerWebserviceMessageConstants.DIGEST_AUTH.equals(authType) || "AWS Signature".equals(authType)) {
            entity.setAuthorizationRequest(auth);
        }
    }

    private void updateUIWithInheritedHeaders(WebServiceRequestEntity entity) {
        if (this.httpHeaders == entity.getHttpHeaderProperties()) {
            if (this.tblHeaders != null) {
                this.tblHeaders.refresh();
            }
        } else {
            this.httpHeaders.clear();
            this.httpHeaders.addAll(entity.getHttpHeaderProperties());
            if (this.tblHeaders != null) {
                this.tblHeaders.refresh();
            }
        }
    }

    private void resetCleanEntity() {
        this.originalCleanEntity = null;
    }

    private String constructNewEntityId(String newPath) {
        String projectLocation = this.originalWsObject.getProject().getFolderLocation();
        String newPathWithoutSlash = newPath.endsWith("/") ? newPath.substring(0, newPath.length() - 1) : newPath;
        return projectLocation + File.separator + newPathWithoutSlash.replace('/', File.separatorChar) + ".rs";
    }

    private void restoreOriginalCleanEntity() {
        if (this.originalCleanEntity != null) {
            this.originalWsObject = this.originalCleanEntity;
            this.originalCleanEntity = null;
        }
    }

    private void resolveInheritedAuthorization() {
        if (this.originalWsObject.getAuthorizationRequest() != null) {
            return;
        }
        boolean shouldInherit = INHERIT_AUTH_FROM_PARENT.equals(this.ccbAuthType.getText());
        if (shouldInherit) {
            try {
                BasicRequestAuthorization inheritedAuth;
                if (this.originalCleanEntity == null) {
                    this.originalCleanEntity = (WebServiceRequestEntity)this.originalWsObject.clone();
                }
                if ((inheritedAuth = this.findInheritedAuthorization()) != null) {
                    WebServiceRequestEntity freshEntity = (WebServiceRequestEntity)this.originalCleanEntity.clone();
                    this.addInheritedHeadersToEntity(freshEntity, inheritedAuth);
                    this.updateUIWithInheritedHeaders(freshEntity);
                    this.originalWsObject = freshEntity;
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)"Failed to resolve inherited authorization");
            }
        }
    }

    private void hideAllAuthorizationFields() {
        this.setCompositeVisible(this.userComposite, false);
        this.setCompositeVisible(this.bearerComposite, false);
        this.setCompositeVisible(this.oauth1Composite, false);
        this.setCompositeVisible(this.oauth2Composite, false);
        this.setCompositeVisible(this.ntmlComposite, false);
        this.setCompositeVisible(this.awsSignatureComposite, false);
        this.setCompositeVisible(this.digestAuthorizationConfigUiContainer, false);
        if (this.btnUpdateHeader != null) {
            this.btnUpdateHeader.setVisible(false);
        }
    }

    private void showRelevantAuthorizationFields() {
        String authType = this.ccbAuthType.getText();
        this.setCompositeVisible(this.userComposite, ComposerWebserviceMessageConstants.BASIC_AUTH.equals(authType));
        this.setCompositeVisible(this.bearerComposite, "Bearer".equals(authType));
        this.setCompositeVisible(this.oauth1Composite, "OAuth 1.0".equals(authType));
        this.setCompositeVisible(this.oauth2Composite, "OAuth 2.0".equals(authType));
        this.setCompositeVisible(this.ntmlComposite, "NTLM".equals(authType));
        this.setCompositeVisible(this.awsSignatureComposite, "AWS Signature".equals(authType));
        this.setCompositeVisible(this.digestAuthorizationConfigUiContainer, ComposerWebserviceMessageConstants.DIGEST_AUTH.equals(authType));
        if (this.btnUpdateHeader != null) {
            this.btnUpdateHeader.setVisible(true);
        }
    }

    private static /* synthetic */ void lambda$4(List list, List list2, int i) {
        boolean bl = list.add((WebElementPropertyEntity)list2.get(i));
    }
}

