/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.postman;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"domain", "expires", "maxAge", "hostOnly", "httpOnly", "name", "path", "secure", "session", "value", "extensions"})
public class Cookie
implements Serializable {
    @JsonProperty(value="domain")
    @JsonPropertyDescription(value="The domain for which this cookie is valid.")
    private String domain;
    @JsonProperty(value="expires")
    @JsonPropertyDescription(value="When the cookie expires.")
    private String expires;
    @JsonProperty(value="maxAge")
    private String maxAge;
    @JsonProperty(value="hostOnly")
    @JsonPropertyDescription(value="True if the cookie is a host-only cookie. (i.e. a request's URL domain must exactly match the domain of the cookie).")
    private boolean hostOnly;
    @JsonProperty(value="httpOnly")
    @JsonPropertyDescription(value="Indicates if this cookie is HTTP Only. (if True, the cookie is inaccessible to client-side scripts)")
    private boolean httpOnly;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="This is the name of the Cookie.")
    private String name;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="The path associated with the Cookie.")
    private String path;
    @JsonProperty(value="secure")
    @JsonPropertyDescription(value="Indicates if the 'secure' flag is set on the Cookie, meaning that it is transmitted over secure connections only. (typically HTTPS)")
    private boolean secure;
    @JsonProperty(value="session")
    @JsonPropertyDescription(value="True if the cookie is a session cookie.")
    private boolean session;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="The value of the Cookie.")
    private String value;
    @JsonProperty(value="extensions")
    @JsonPropertyDescription(value="Custom attributes for a cookie go here, such as the [Priority Field](https://code.google.com/p/chromium/issues/detail?id=232693)")
    private List<Object> extensions = new ArrayList<Object>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private static final long serialVersionUID = -8532676222063568530L;

    public Cookie() {
    }

    public Cookie(String domain, String expires, String maxAge, boolean hostOnly, boolean httpOnly, String name, String path, boolean secure, boolean session, String value, List<Object> extensions) {
        this.domain = domain;
        this.expires = expires;
        this.maxAge = maxAge;
        this.hostOnly = hostOnly;
        this.httpOnly = httpOnly;
        this.name = name;
        this.path = path;
        this.secure = secure;
        this.session = session;
        this.value = value;
        this.extensions = extensions;
    }

    @JsonProperty(value="domain")
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty(value="expires")
    public String getExpires() {
        return this.expires;
    }

    @JsonProperty(value="expires")
    public void setExpires(String expires) {
        this.expires = expires;
    }

    @JsonProperty(value="maxAge")
    public String getMaxAge() {
        return this.maxAge;
    }

    @JsonProperty(value="maxAge")
    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    @JsonProperty(value="hostOnly")
    public boolean isHostOnly() {
        return this.hostOnly;
    }

    @JsonProperty(value="hostOnly")
    public void setHostOnly(boolean hostOnly) {
        this.hostOnly = hostOnly;
    }

    @JsonProperty(value="httpOnly")
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @JsonProperty(value="httpOnly")
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    @JsonProperty(value="secure")
    public boolean isSecure() {
        return this.secure;
    }

    @JsonProperty(value="secure")
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @JsonProperty(value="session")
    public boolean isSession() {
        return this.session;
    }

    @JsonProperty(value="session")
    public void setSession(boolean session) {
        this.session = session;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    @JsonProperty(value="extensions")
    public List<Object> getExtensions() {
        return this.extensions;
    }

    @JsonProperty(value="extensions")
    public void setExtensions(List<Object> extensions) {
        this.extensions = extensions;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("domain", (Object)this.domain).append("expires", (Object)this.expires).append("maxAge", (Object)this.maxAge).append("hostOnly", this.hostOnly).append("httpOnly", this.httpOnly).append("name", (Object)this.name).append("path", (Object)this.path).append("secure", this.secure).append("session", this.session).append("value", (Object)this.value).append("extensions", this.extensions).append("additionalProperties", this.additionalProperties).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.secure).append(this.extensions).append((Object)this.maxAge).append((Object)this.expires).append(this.session).append(this.additionalProperties).append((Object)this.name).append((Object)this.value).append((Object)this.path).append((Object)this.domain).append(this.httpOnly).append(this.hostOnly).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Cookie)) {
            return false;
        }
        Cookie rhs = (Cookie)other;
        return new EqualsBuilder().append(this.secure, rhs.secure).append(this.extensions, rhs.extensions).append((Object)this.maxAge, (Object)rhs.maxAge).append((Object)this.expires, (Object)rhs.expires).append(this.session, rhs.session).append(this.additionalProperties, rhs.additionalProperties).append((Object)this.name, (Object)rhs.name).append((Object)this.value, (Object)rhs.value).append((Object)this.path, (Object)rhs.path).append((Object)this.domain, (Object)rhs.domain).append(this.httpOnly, rhs.httpOnly).append(this.hostOnly, rhs.hostOnly).isEquals();
    }
}

