/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.body;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kms.katalon.composer.components.impl.constants.TextContentType;
import com.kms.katalon.composer.components.impl.editors.MirrorEditor;
import com.kms.katalon.composer.components.impl.handler.DocumentReadyHandler;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.parts.VerificationScriptEventHandler;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.composer.webservice.util.JsonPathUtils;
import com.kms.katalon.composer.webservice.util.XPathUtils;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.entity.webservice.TextBodyContent;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PrettyEditor
extends Composite
implements ResponseBodyEditor,
MirrorEditor.EditorChangeListener {
    private TextBodyContent textBodyContent;
    private MirrorEditor mirrorEditor;
    Composite tbBodyType;
    private Map<String, Button> TEXT_MODE_SELECTION_BUTTONS = new HashMap<String, Button>();
    private static final int JSON_TOKEN_SIZE = 4;
    private static final int XML_TOKEN_SIZE = 5;
    private static final int JSON_PROP_VALUE_TOKEN_IDX = 3;
    private static final int XML_PROP_VALUE_TOKEN_IDX = 4;
    private static final int DEFAULT_MAX_FORMATTED_RESPONSE_SIZE_IN_KB = 30000;
    private static final int DEFAULT_MAX_FORMATTED_RESPONSE_LINES = 10000;
    private Button chckWrapLine;
    private static final String[] TEXT_MODE_NAMES = TextContentType.getTextValues();
    private Map<TextContentType, Map<Integer, String>> lineIndexing = new HashMap<TextContentType, Map<Integer, String>>();
    private TextContentType preferedContentType;
    private Collection<VerificationScriptEventHandler> eventHanders = new LinkedList<VerificationScriptEventHandler>();

    public PrettyEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.mirrorEditor = new MirrorEditor((Composite)this, 0);
        this.mirrorEditor.setEditable(false);
        this.mirrorEditor.registerDocumentHandler(new DocumentReadyHandler(){

            public void onDocumentReady() {
                PrettyEditor.this.handleControlModifyListener();
            }
        });
        this.mirrorEditor.addEventListener((MirrorEditor.EditorChangeListener)this);
        Label lblInstruction = new Label((Composite)this, 64);
        lblInstruction.setLayoutData((Object)new GridData(4, 4, true, false));
        lblInstruction.setText(ComposerWebserviceMessageConstants.HOW_TO_ADD_JSON_AND_XML_PATH_TO_VERIFICATION_SCRIPT);
        Composite bottomComposite = new Composite((Composite)this, 0);
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.marginHeight = 0;
        bottomLayout.marginWidth = 0;
        bottomComposite.setLayout((Layout)bottomLayout);
        bottomComposite.setLayoutData((Object)new GridData(768));
        this.tbBodyType = new Composite(bottomComposite, 0);
        this.tbBodyType.setLayout((Layout)new GridLayout(TEXT_MODE_NAMES.length, false));
        Arrays.asList(TextContentType.values()).forEach(textContentType -> {
            if (textContentType != TextContentType.TEXT) {
                Button btnTextMode = new Button(this.tbBodyType, 16);
                btnTextMode.setText(textContentType.getText());
                this.TEXT_MODE_SELECTION_BUTTONS.put(textContentType.getText(), btnTextMode);
                btnTextMode.addSelectionListener((SelectionListener)new SelectionAdapter((TextContentType)textContentType){
                    private final /* synthetic */ TextContentType val$textContentType;
                    {
                        this.val$textContentType = textContentType;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        Button source = (Button)e.getSource();
                        if (source.getSelection()) {
                            String mode = this.val$textContentType.getText();
                            PrettyEditor.this.mirrorEditor.changeMode(mode);
                            if (PrettyEditor.this.textBodyContent != null) {
                                PrettyEditor.this.textBodyContent.setContentType(this.val$textContentType.getContentType());
                                PrettyEditor.this.mirrorEditor.setHintText("");
                            }
                            PrettyEditor.this.notifyListeners(24, new Event());
                        }
                    }
                });
            }
        });
        this.chckWrapLine = new Button(bottomComposite, 32);
        this.chckWrapLine.setText(ComposerWebserviceMessageConstants.PA_LBL_WRAP_LINE);
        this.chckWrapLine.setSelection(true);
    }

    private void handleControlModifyListener() {
        this.chckWrapLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrettyEditor.this.mirrorEditor.wrapLine(PrettyEditor.this.chckWrapLine.getSelection());
            }
        });
    }

    @Override
    public String getContentType() {
        if (this.textBodyContent == null) {
            return "";
        }
        return this.textBodyContent.getContentType();
    }

    private boolean shouldBeautify(String textBodyContentString, int maxFormattedResponseSizeInKB, int maxFormattedResponseLines) {
        long responseSize = textBodyContentString.length();
        if (responseSize > (long)maxFormattedResponseSizeInKB * 1024L) {
            return false;
        }
        long lineCount = textBodyContentString.lines().count();
        return lineCount <= (long)maxFormattedResponseLines;
    }

    @Override
    public void setContentBody(ResponseObject responseObject) throws IOException {
        if (responseObject == null) {
            this.textBodyContent = null;
            this.mirrorEditor.setText("");
            return;
        }
        this.textBodyContent = new TextBodyContent();
        this.textBodyContent.setText(responseObject.getResponseText());
        this.textBodyContent.setContentType(StringUtils.substringBefore((String)responseObject.getContentType(), (String)";"));
        String text = this.textBodyContent.getText();
        this.updateRadioStatus();
        int maxRormattedResponseSizeInKB = Integer.getInteger("maxFormattedResponseSizeInKB", 30000);
        int maxFormattedResponseLines = Integer.getInteger("maxFormattedResponseLines", 10000);
        if (this.shouldBeautify(text, maxRormattedResponseSizeInKB, maxFormattedResponseLines)) {
            this.mirrorEditor.setText(text);
            this.mirrorEditor.beautify();
        } else if (this.preferedContentType == TextContentType.JSON) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
                Object jsonObject = objectMapper.readValue(text, Object.class);
                String prettyJson = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
                this.mirrorEditor.setText(prettyJson);
            }
            catch (Exception error) {
                LogUtil.logError((Throwable)error, (String)("Cannot format the JSON response from the text: " + text + ". It will be renderred as raw text instead"));
                this.mirrorEditor.setText(text);
            }
        } else {
            this.mirrorEditor.setText(text);
        }
        switch (this.preferedContentType) {
            case JSON: {
                this.lineIndexing.put(this.preferedContentType, JsonPathUtils.evaluateJsonProperty(text));
                break;
            }
            case XML: {
                this.lineIndexing.put(this.preferedContentType, XPathUtils.evaluateXmlProperty(text));
                break;
            }
        }
    }

    @Override
    public void switchModeContentBody(ResponseObject responseObject) throws IOException {
        if (responseObject != null) {
            if (this.textBodyContent == null) {
                this.setContentBody(responseObject);
            } else {
                this.textBodyContent.setContentType(StringUtils.substringBefore((String)responseObject.getContentType(), (String)";"));
                this.updateRadioStatus();
            }
        }
    }

    private void updateRadioStatus() {
        this.preferedContentType = TextContentType.evaluateContentType((String)this.textBodyContent.getContentType());
        Button selectionButton = this.TEXT_MODE_SELECTION_BUTTONS.get(this.preferedContentType.getText());
        this.TEXT_MODE_SELECTION_BUTTONS.entrySet().forEach(e -> ((Button)e.getValue()).setSelection(false));
        if (selectionButton != null) {
            selectionButton.setSelection(true);
            selectionButton.notifyListeners(13, new Event());
            this.mirrorEditor.changeMode(this.preferedContentType.getText());
        }
    }

    public void handleEditorEvent(String event, Object[] objects) {
        switch (event) {
            case "handleMouseOverChanged": {
                if (objects == null || objects.length != 1 || !(objects[0] instanceof String)) {
                    return;
                }
                if (!this.preferedContentType.getContentType().equals(this.textBodyContent.getContentType())) {
                    return;
                }
                JsonObject positionJsonObject = (JsonObject)new Gson().fromJson((String)objects[0], JsonObject.class);
                int line = positionJsonObject.get("line").getAsInt();
                Map<Integer, String> jsonPathCollection = this.lineIndexing.get(this.preferedContentType);
                if (jsonPathCollection.containsKey(line)) {
                    this.mirrorEditor.setHintText(jsonPathCollection.get(line));
                    break;
                }
                this.mirrorEditor.setHintText("");
                break;
            }
            case "handleGenerateVerificationEvent": {
                if (objects == null || objects.length != 2) {
                    return;
                }
                if (!this.preferedContentType.getContentType().equals(this.textBodyContent.getContentType())) {
                    return;
                }
                int line = ((Number)objects[0]).intValue();
                Map<Integer, String> propertyCollection = this.lineIndexing.get(this.preferedContentType);
                if (!propertyCollection.containsKey(line)) {
                    return;
                }
                String propertyName = propertyCollection.get(line);
                Object propertyValue = "";
                JsonArray lineTokensJson = (JsonArray)new Gson().fromJson((String)objects[1], JsonArray.class);
                switch (this.preferedContentType) {
                    case JSON: {
                        JsonObject jsObject;
                        if (lineTokensJson.size() < 4 || (jsObject = lineTokensJson.get(3).getAsJsonObject()).get("type").isJsonNull()) break;
                        propertyValue = jsObject.get("string").getAsString();
                        break;
                    }
                    case XML: {
                        if (lineTokensJson.size() != 5) break;
                        propertyValue = "'" + lineTokensJson.get(4).getAsJsonObject().get("string").getAsString().replace("'", "\\'") + "'";
                        break;
                    }
                }
                String script = String.format("WS.verifyElementPropertyValue(response, '%s', %s)", propertyName.replace("'", "\\'"), StringUtils.defaultIfEmpty((CharSequence)propertyValue, (CharSequence)"''"));
                Iterator<VerificationScriptEventHandler> iterator = this.eventHanders.iterator();
                while (iterator.hasNext()) {
                    iterator.next().insertScript(script);
                }
                break;
            }
        }
    }

    public void addHandler(VerificationScriptEventHandler handler) {
        this.eventHanders.add(handler);
    }
}

