/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.response.body;

import com.equo.chromium.swt.Browser;
import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.webservice.response.body.ResponseBodyEditor;
import com.kms.katalon.composer.webservice.util.WebServiceUtil;
import com.kms.katalon.core.testobject.ResponseObject;
import java.io.IOException;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class PreviewEditor
extends Composite
implements ResponseBodyEditor {
    private static final String DARK_THEME_BACKGROUND_COLOR = "#2F2F2F";
    private static final String DARK_THEME_TEXT_COLOR = "#FFFFFF";
    private static final String DARK_THEME_BORDER_COLOR = "#ddd";
    private Browser browser;
    private ResponseObject responseObjects;

    public PreviewEditor(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        this.browser = new Browser((Composite)this, 0);
        this.browser.setJavascriptEnabled(true);
        this.browser.setLayoutData((Object)new GridData(1808));
        final boolean isDarkTheme = ComponentBundleActivator.isDarkTheme((Display)this.getDisplay());
        this.browser.addProgressListener(new ProgressListener(){

            public void completed(ProgressEvent event) {
                if (isDarkTheme) {
                    String darkModeScript = String.format("document.body.style.backgroundColor = '%s'; ", PreviewEditor.DARK_THEME_BACKGROUND_COLOR) + String.format("document.body.style.color = '%s'; ", PreviewEditor.DARK_THEME_TEXT_COLOR) + String.format("document.body.style.border = '1px solid %s';", PreviewEditor.DARK_THEME_BORDER_COLOR);
                    PreviewEditor.this.browser.evaluate(darkModeScript);
                }
                PreviewEditor.this.browser.evaluate("document.addEventListener('contextmenu', function(e) { e.preventDefault();});");
            }

            public void changed(ProgressEvent event) {
            }
        });
    }

    @Override
    public void setContentBody(ResponseObject responseOb) throws IOException {
        this.responseObjects = responseOb;
        if (responseOb == null || responseOb.getResponseBodySize() <= 0L) {
            this.browser.setText(this.wrapHtml("No response to display"), false);
            return;
        }
        if (WebServiceUtil.isDisplaySupportedContent(responseOb)) {
            this.browser.setText(responseOb.getResponseText(), false);
            return;
        }
        this.browser.setText(this.wrapHtml("Unsupported content type to display"), false);
    }

    @Override
    public void switchModeContentBody(ResponseObject responseOb) throws IOException {
        if (this.responseObjects != responseOb) {
            this.setContentBody(responseOb);
        }
    }

    @Override
    public String getContentType() {
        if (this.responseObjects == null) {
            return "";
        }
        return this.responseObjects.getContentType();
    }

    private String wrapHtml(String message) {
        return "<html><body style='padding-top: 60px; text-align: center; font-family: Inter, Roboto, Helvetica, Arial, sans-serif; font-size: 14px;'><p>" + message + "</p></body></html>";
    }
}

