/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.util;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class WebServiceUtil {
    private static final String DEFAULT_RESPONSE_SAVE_FILE_NAME = "response";
    private static final Pattern CONTENT_DISPOSITION_ENCODED_FILE_NAME_PATTERN = Pattern.compile("filename\\*=([^']+)'[^']*'([^\";]+)", 2);
    private static final Pattern CONTENT_DISPOSITION_NORMAL_FILE_NAME_PATTERN = Pattern.compile("filename=\\\"?([^\";]+)\\\"?", 2);
    private static final Map<String, String> DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP = new LinkedHashMap<String, String>();
    private static final Set<String> DISPLAY_SUPPORTED_CONTENT_TYPE_SET = Set.of("text/plain", "text/html", "text/javascript", "text/xml", "application/json", "application/xml", "application/soap+xml", "application/javascript");

    static {
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("text/plain", "txt");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("text/html", "html");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("text/css", "css");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("text/javascript", "js");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("text/csv", "csv");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("text/xml", "xml");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/json", "json");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/xml", "xml");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/soap+xml", "xml");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/javascript", "js");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/pdf", "pdf");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/zip", "zip");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/gzip", "gz");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/vnd.ms-excel", "xls");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/msword", "doc");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/jpeg", "jpg");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/png", "png");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/gif", "gif");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/svg+xml", "svg");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/webp", "webp");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/bmp", "bmp");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/x-ms-bmp", "bmp");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("image/tiff", "tiff");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("audio/mpeg", "mp3");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("audio/ogg", "ogg");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("audio/wav", "wav");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("audio/x-wav", "wav");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("video/mp4", "mp4");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("video/webm", "webm");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("video/ogg", "ogv");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("video/3gpp", "3gp");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("video/x-msvideo", "avi");
        DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.put("video/quicktime", "mov");
    }

    public static String getRequestMethodIcon(String serviceType, String requestMethod) {
        block49: {
            block47: {
                if (!serviceType.equals(WebServiceRequestEntity.SERVICE_TYPES[1])) break block47;
                switch (requestMethod) {
                    case "GET": {
                        return ImageConstants.WS_GET_METHOD_16;
                    }
                    case "POST": {
                        return ImageConstants.WS_POST_METHOD_16;
                    }
                    case "PUT": {
                        return ImageConstants.WS_PUT_METHOD_16;
                    }
                    case "DELETE": {
                        return ImageConstants.WS_DELETE_METHOD_16;
                    }
                    case "PATCH": {
                        return ImageConstants.WS_PATCH_METHOD_16;
                    }
                    case "CONNECT": {
                        return ImageConstants.WS_CONNECT_METHOD_16;
                    }
                    case "HEAD": {
                        return ImageConstants.WS_HEAD_METHOD_16;
                    }
                    case "OPTIONS": {
                        return ImageConstants.WS_OPTIONS_METHOD_16;
                    }
                    case "TRACE": {
                        return ImageConstants.WS_TRACE_METHOD_16;
                    }
                }
                return ImageConstants.WS_CUSTOM_METHOD_16;
            }
            if (!serviceType.equals(WebServiceRequestEntity.SERVICE_TYPES[0])) break block49;
            switch (requestMethod) {
                case "GET": {
                    return ImageConstants.WS_SOAP_GET_METHOD_16;
                }
                case "POST": {
                    return ImageConstants.WS_SOAP_POST_METHOD_16;
                }
                case "SOAP": {
                    return ImageConstants.WS_SOAP_METHOD_16;
                }
                case "SOAP12": {
                    return ImageConstants.WS_SOAP12_METHOD_16;
                }
            }
            return ImageConstants.WS_GET_METHOD_16;
        }
        return ImageConstants.WS_TEST_OBJECT_16;
    }

    public static Image getRequestMethodImage(String serviceType, String requestMethod) {
        block49: {
            block47: {
                if (!serviceType.equals(WebServiceRequestEntity.SERVICE_TYPES[1])) break block47;
                switch (requestMethod) {
                    case "GET": {
                        return ImageConstants.IMG_WS_GET_METHOD_16;
                    }
                    case "POST": {
                        return ImageConstants.IMG_WS_POST_METHOD_16;
                    }
                    case "PUT": {
                        return ImageConstants.IMG_WS_PUT_METHOD_16;
                    }
                    case "DELETE": {
                        return ImageConstants.IMG_WS_DELETE_METHOD_16;
                    }
                    case "PATCH": {
                        return ImageConstants.IMG_WS_PATCH_METHOD_16;
                    }
                    case "CONNECT": {
                        return ImageConstants.IMG_WS_CONNECT_METHOD_16;
                    }
                    case "HEAD": {
                        return ImageConstants.IMG_WS_HEAD_METHOD_16;
                    }
                    case "OPTIONS": {
                        return ImageConstants.IMG_WS_OPTIONS_METHOD_16;
                    }
                    case "TRACE": {
                        return ImageConstants.IMG_WS_TRACE_METHOD_16;
                    }
                }
                return ImageConstants.IMG_WS_CUSTOM_METHOD_16;
            }
            if (!serviceType.equals(WebServiceRequestEntity.SERVICE_TYPES[0])) break block49;
            switch (requestMethod) {
                case "GET": {
                    return ImageConstants.IMG_WS_SOAP_GET_METHOD_16;
                }
                case "POST": {
                    return ImageConstants.IMG_WS_SOAP_POST_METHOD_16;
                }
                case "SOAP": {
                    return ImageConstants.IMG_WS_SOAP_METHOD_16;
                }
                case "SOAP12": {
                    return ImageConstants.IMG_WS_SOAP12_METHOD_16;
                }
            }
            return ImageConstants.IMG_WS_GET_METHOD_16;
        }
        return ImageConstants.IMG_WS_TEST_OBJECT_16;
    }

    public static void setHttpsProtocol() {
        LinkedHashMap propertyMap = new LinkedHashMap();
        AbstractRunConfiguration.setHttpsProtocol(propertyMap);
        RunConfiguration.setExecutionSetting(propertyMap);
    }

    public static boolean isDisplaySupportedContent(ResponseObject responseObject) {
        if (responseObject == null || responseObject.getResponseBodySize() <= 0L) {
            return false;
        }
        String contentType = responseObject.getContentType();
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return false;
        }
        for (String displaySupportedContentType : DISPLAY_SUPPORTED_CONTENT_TYPE_SET) {
            if (!contentType.startsWith(displaySupportedContentType)) continue;
            return true;
        }
        return false;
    }

    public static void openDialogAndSaveResponseBody(ResponseObject responseObject) {
        if (responseObject == null || responseObject.getResponseBodySize() <= 0L) {
            return;
        }
        String[] filenameAndExtension = WebServiceUtil.generateSaveFilenameAndExtension(responseObject);
        String filename = filenameAndExtension[0];
        String fileExtension = filenameAndExtension[1];
        String filePath = WebServiceUtil.openSaveDialog("Save Response", WebServiceUtil.getUserDownloadDirectoryPath(), filename, fileExtension);
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            try {
                responseObject.writeResponseBodyToFile(filePath);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)String.format("Failed to save response body to file \"%s\"", filePath));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save Failed", (String)("Failed to save response body to file.\n\nError: " + e.getMessage()));
            }
        }
    }

    public static String openSaveDialog(String title, String defaultPath, String defaultBaseFilename, String fileExtension) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setText(title);
        dialog.setFilterPath(defaultPath);
        String fileType = fileExtension.toUpperCase();
        String filterExtension = StringUtils.isNotBlank((CharSequence)fileExtension) ? String.format("*.%s", fileExtension) : "*";
        dialog.setFilterExtensions(new String[]{filterExtension});
        dialog.setFilterNames(new String[]{String.format("%s Files (%s)", fileType, filterExtension)});
        String baseName = defaultBaseFilename;
        Object filename = fileExtension.isEmpty() ? baseName : baseName + "." + fileExtension;
        File file = new File(defaultPath, (String)filename);
        int counter = 1;
        while (file.exists()) {
            filename = fileExtension.isEmpty() ? baseName + " (" + counter + ")" : baseName + " (" + counter + ")." + fileExtension;
            file = new File(defaultPath, (String)filename);
            ++counter;
        }
        dialog.setFileName((String)filename);
        dialog.setOverwrite(true);
        String filePath = dialog.open();
        return filePath;
    }

    private static String getUserDownloadDirectoryPath() {
        Object defaultPath = null;
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                defaultPath = System.getProperty("user.home") + "\\Downloads";
            } else if (SystemUtils.IS_OS_MAC || SystemUtils.IS_OS_UNIX) {
                defaultPath = System.getProperty("user.home") + "/Downloads";
            }
            File downloadDir = new File((String)defaultPath);
            if (!downloadDir.exists() || !downloadDir.isDirectory()) {
                defaultPath = ProjectController.getInstance().getCurrentProject().getFolderLocation();
            }
        }
        catch (Exception e) {
            defaultPath = ProjectController.getInstance().getCurrentProject().getFolderLocation();
            LoggerSingleton.logError((Throwable)e, (String)"Cannot get default download location, using project location instead");
        }
        return defaultPath;
    }

    private static String[] generateSaveFilenameAndExtension(ResponseObject responseObject) {
        String[] defaultFilenameAndExtension = new String[]{DEFAULT_RESPONSE_SAVE_FILE_NAME, ""};
        if (responseObject == null || responseObject.getResponseBodySize() <= 0L) {
            return defaultFilenameAndExtension;
        }
        String[] filenameAndExtension = null;
        filenameAndExtension = WebServiceUtil.generateFilenameAndExtFromContentDisposition(responseObject.getContentDisposition());
        if (filenameAndExtension != null && filenameAndExtension.length > 0) {
            return filenameAndExtension;
        }
        filenameAndExtension = WebServiceUtil.generateFilenameAndExtFromContentType(responseObject.getContentType());
        if (filenameAndExtension != null && filenameAndExtension.length > 0) {
            return filenameAndExtension;
        }
        return defaultFilenameAndExtension;
    }

    private static String[] generateFilenameAndExtFromContentDisposition(String contentDisposition) {
        Matcher simpleMatcher;
        if (StringUtils.isBlank((CharSequence)contentDisposition)) {
            return null;
        }
        String filenameWithExtension = null;
        Matcher encodedMatcher = CONTENT_DISPOSITION_ENCODED_FILE_NAME_PATTERN.matcher(contentDisposition);
        if (encodedMatcher.find()) {
            String charsetName = encodedMatcher.group(1);
            String encodedFilename = encodedMatcher.group(2);
            try {
                Charset charset = Charset.forName(charsetName);
                filenameWithExtension = URLDecoder.decode(encodedFilename, charset);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e, (String)String.format("Ignored. Failed to retrieve the file name from the extended Content-Disposition header \"%s\". Falling back to retrieve from the standard one", contentDisposition));
            }
        }
        if (StringUtils.isBlank(filenameWithExtension) && (simpleMatcher = CONTENT_DISPOSITION_NORMAL_FILE_NAME_PATTERN.matcher(contentDisposition)).find()) {
            filenameWithExtension = simpleMatcher.group(1);
        }
        if (StringUtils.isNotBlank(filenameWithExtension)) {
            int lastDotIndex = filenameWithExtension.lastIndexOf(".");
            if (lastDotIndex != -1) {
                String namePart = filenameWithExtension.substring(0, lastDotIndex);
                String extensionPart = filenameWithExtension.substring(lastDotIndex + 1);
                return new String[]{namePart, extensionPart};
            }
            return new String[]{filenameWithExtension, ""};
        }
        return null;
    }

    private static String[] generateFilenameAndExtFromContentType(String contentType) {
        if (StringUtils.isBlank((CharSequence)contentType)) {
            return null;
        }
        String sanitizedContentType = contentType.split(";")[0].trim().toLowerCase();
        String fileExtension = DOWNLOAD_SUPPORTED_CONTENT_TYPE_TO_EXTENSION_MAP.get(sanitizedContentType);
        if (StringUtils.isNotBlank((CharSequence)fileExtension)) {
            return new String[]{DEFAULT_RESPONSE_SAVE_FILE_NAME, fileExtension};
        }
        return null;
    }
}

