/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.parts.ApiCollectionPart;
import com.kms.katalon.entity.folder.ApiCollectionEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ApiCollectionPartUI {
    private static final String BUNDLE_URI_WEBSERVICE = "bundleclass://com.kms.katalon.composer.webservice/";
    private static final String COLLECTION_PART_URI = "bundleclass://com.kms.katalon.composer.webservice/com.kms.katalon.composer.webservice.parts.ApiCollectionPart";
    private static final String COLLECTION_PART_ID_PREFIX = "com.kms.katalon.composer.webservice.part.collection.";
    private static final String INHERIT_AUTH_FROM_PARENT = ComposerWebserviceMessageConstants.INHERIT_AUTH_FROM_PARENT;
    private static final String MSG_COLLECTION_AUTH_DESC_TOP = ComposerWebserviceMessageConstants.MSG_COLLECTION_AUTH_DESC_TOP;
    private static final String MSG_COLLECTION_AUTH_DESC_CHILD = ComposerWebserviceMessageConstants.MSG_COLLECTION_AUTH_DESC_CHILD;
    private static final String GENERAL_INFO_GROUP_TITLE = ComposerWebserviceMessageConstants.GENERAL_INFO_GROUP_TITLE;
    private static final String AUTHORIZATION_HEADER = ComposerWebserviceMessageConstants.AUTHORIZATION_HEADER;
    private static final String METHOD_TABLE_COL_TYPE = ComposerWebserviceMessageConstants.METHOD_TABLE_COL_TYPE;
    private static final String CONFIG_DETAILS_GROUP_TITLE = ComposerWebserviceMessageConstants.CONFIG_DETAILS_GROUP_TITLE;
    private ApiCollectionEntity apiCollectionEntity;
    private MCompositePart compositePart;
    private CTabFolder tabFolder;
    private CTabItem tabAuthorization;
    private Group configGroup;
    private Composite authorizationTabComposite;
    private CCombo ccbAuthType;
    private Composite userComposite;
    private Composite bearerComposite;
    private Composite ntmlComposite;
    private Composite awsSignatureComposite;
    private Composite oauth1Composite;
    private Composite oauth2Composite;
    private Composite digestAuthorizationConfigUiContainer;

    public ApiCollectionPartUI(ApiCollectionEntity apiCollectionEntity, MPartStack stack, EModelService modelService, IEclipseContext context) throws IOException, CoreException {
        EPartService partService = (EPartService)context.get(EPartService.class);
        this.apiCollectionEntity = apiCollectionEntity;
        String partId = COLLECTION_PART_ID_PREFIX + apiCollectionEntity.getId();
        MPart existingPart = (MPart)modelService.find(partId, (MUIElement)context.get(MApplication.class));
        if (existingPart != null) {
            existingPart.setLabel(apiCollectionEntity.getName());
            existingPart.setTooltip(apiCollectionEntity.getIdForDisplay());
            partService.activate(existingPart);
            return;
        }
        this.compositePart = (MCompositePart)modelService.createModelElement(MCompositePart.class);
        this.compositePart.setElementId(partId);
        this.compositePart.setContributionURI(COLLECTION_PART_URI);
        this.compositePart.setLabel(apiCollectionEntity.getName());
        this.compositePart.setTooltip(apiCollectionEntity.getIdForDisplay());
        this.compositePart.setIconURI(ImageConstants.URL_16_API_COLLECTION);
        this.compositePart.setCloseable(true);
        this.compositePart.getTags().add("removeOnHide");
        stack.getChildren().add(this.compositePart);
        partService.activate((MPart)this.compositePart);
    }

    public ApiCollectionPartUI(ApiCollectionEntity apiCollectionEntity) {
        this.apiCollectionEntity = apiCollectionEntity;
    }

    public static void create(ApiCollectionEntity apiCollection, MPartStack stack, EModelService modelService, IEclipseContext context) {
        try {
            new ApiCollectionPartUI(apiCollection, stack, modelService, context);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public void initComponents(ApiCollectionPart apiCollectionPart) {
    }

    public void createAuthorizationTab(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabAuthorization = new CTabItem(this.tabFolder, 0);
        this.tabAuthorization.setText(ComposerWebserviceMessageConstants.TAB_AUTHORIZATION);
        this.authorizationTabComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayout tabLayout = new GridLayout();
        tabLayout.marginWidth = 20;
        tabLayout.marginHeight = 20;
        tabLayout.verticalSpacing = 15;
        this.authorizationTabComposite.setLayout((Layout)tabLayout);
        this.tabAuthorization.setControl((Control)this.authorizationTabComposite);
        this.createGeneralInfoGroup();
        this.createAuthTypeGroup();
        this.createConfigGroup();
        this.tabFolder.setSelection(0);
    }

    private void createGeneralInfoGroup() {
        Group generalInfoGroup = new Group(this.authorizationTabComposite, 16);
        generalInfoGroup.setText(GENERAL_INFO_GROUP_TITLE);
        this.setFontStyle((Control)generalInfoGroup, 1);
        GridLayout generalInfoLayout = new GridLayout();
        generalInfoLayout.marginWidth = 15;
        generalInfoLayout.marginHeight = 15;
        generalInfoLayout.verticalSpacing = 8;
        generalInfoGroup.setLayout((Layout)generalInfoLayout);
        generalInfoGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Label descriptionLabel = new Label((Composite)generalInfoGroup, 64);
        String authDescription = this.isTopMostFolder() ? MSG_COLLECTION_AUTH_DESC_TOP : MSG_COLLECTION_AUTH_DESC_CHILD;
        descriptionLabel.setText(authDescription);
        this.setFontStyle((Control)descriptionLabel, 2);
        GridData descGd = new GridData(4, 128, true, false);
        descGd.widthHint = 600;
        descGd.horizontalIndent = 5;
        descriptionLabel.setLayoutData((Object)descGd);
    }

    private void createAuthTypeGroup() {
        Group authTypeGroup = new Group(this.authorizationTabComposite, 16);
        authTypeGroup.setText(AUTHORIZATION_HEADER);
        this.setFontStyle((Control)authTypeGroup, 1);
        GridLayout authTypeLayout = new GridLayout(2, false);
        authTypeLayout.marginWidth = 18;
        authTypeLayout.marginHeight = 18;
        authTypeLayout.horizontalSpacing = 15;
        authTypeLayout.verticalSpacing = 8;
        authTypeGroup.setLayout((Layout)authTypeLayout);
        authTypeGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Label lblAuthType = new Label((Composite)authTypeGroup, 0);
        lblAuthType.setText(METHOD_TABLE_COL_TYPE);
        this.setFontStyle((Control)lblAuthType, 1);
        lblAuthType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.ccbAuthType = new CCombo((Composite)authTypeGroup, 0x800808);
        GridData gdCcbAuthType = new GridData(4, 0x1000000, true, false);
        gdCcbAuthType.widthHint = 350;
        gdCcbAuthType.heightHint = 28;
        this.ccbAuthType.setLayoutData((Object)gdCcbAuthType);
        if (!this.isTopMostFolder()) {
            this.ccbAuthType.add(INHERIT_AUTH_FROM_PARENT);
        }
        this.ccbAuthType.add(ComposerWebserviceMessageConstants.NO_AUTH);
        this.ccbAuthType.add("Bearer");
        this.ccbAuthType.add(ComposerWebserviceMessageConstants.BASIC_AUTH);
        this.ccbAuthType.add("AWS Signature");
        this.ccbAuthType.add(ComposerWebserviceMessageConstants.DIGEST_AUTH);
        this.ccbAuthType.add("OAuth 1.0");
        this.ccbAuthType.add("OAuth 2.0");
        this.ccbAuthType.add("NTLM");
    }

    private void createConfigGroup() {
        this.configGroup = new Group(this.authorizationTabComposite, 16);
        this.configGroup.setText(CONFIG_DETAILS_GROUP_TITLE);
        this.setFontStyle((Control)this.configGroup, 1);
        GridLayout configLayout = new GridLayout(2, false);
        configLayout.marginWidth = 18;
        configLayout.marginHeight = 18;
        configLayout.horizontalSpacing = 18;
        configLayout.verticalSpacing = 12;
        this.configGroup.setLayout((Layout)configLayout);
        GridData configGroupData = new GridData(4, 4, true, true);
        configGroupData.verticalIndent = 5;
        this.configGroup.setLayoutData((Object)configGroupData);
        this.configGroup.setVisible(false);
        configGroupData.exclude = true;
        this.createAuthConfigurationComposites();
    }

    private void createAuthConfigurationComposites() {
        this.awsSignatureComposite = new Composite((Composite)this.configGroup, 0);
        GridData awsGridData = new GridData(4, 4, true, true, 2, 1);
        awsGridData.horizontalIndent = 8;
        awsGridData.verticalIndent = 8;
        this.awsSignatureComposite.setLayoutData((Object)awsGridData);
        this.userComposite = new Composite((Composite)this.configGroup, 0);
        GridData userGridData = new GridData(4, 4, true, true, 2, 1);
        userGridData.horizontalIndent = 8;
        userGridData.verticalIndent = 8;
        this.userComposite.setLayoutData((Object)userGridData);
        this.bearerComposite = new Composite((Composite)this.configGroup, 0);
        GridData bearerGridData = new GridData(4, 4, true, true, 2, 1);
        bearerGridData.horizontalIndent = 8;
        bearerGridData.verticalIndent = 8;
        this.bearerComposite.setLayoutData((Object)bearerGridData);
        this.ntmlComposite = new Composite((Composite)this.configGroup, 0);
        GridData ntmlGridData = new GridData(4, 4, true, true, 2, 1);
        ntmlGridData.horizontalIndent = 8;
        ntmlGridData.verticalIndent = 8;
        this.ntmlComposite.setLayoutData((Object)ntmlGridData);
        this.oauth1Composite = new Composite((Composite)this.configGroup, 0);
        GridData oauth1GridData = new GridData(4, 4, true, true, 2, 1);
        oauth1GridData.horizontalIndent = 8;
        oauth1GridData.verticalIndent = 8;
        this.oauth1Composite.setLayoutData((Object)oauth1GridData);
        this.oauth2Composite = new Composite((Composite)this.configGroup, 0);
        GridData oauth2GridData = new GridData(4, 4, true, true, 2, 1);
        oauth2GridData.horizontalIndent = 8;
        oauth2GridData.verticalIndent = 8;
        this.oauth2Composite.setLayoutData((Object)oauth2GridData);
        this.digestAuthorizationConfigUiContainer = new Composite((Composite)this.configGroup, 0);
        GridData digestGridData = new GridData(4, 4, true, true, 2, 1);
        digestGridData.horizontalIndent = 8;
        digestGridData.verticalIndent = 8;
        this.digestAuthorizationConfigUiContainer.setLayoutData((Object)digestGridData);
    }

    public void addAuthTypeSelectionListener(SelectionAdapter listener) {
        if (this.ccbAuthType != null) {
            this.ccbAuthType.addSelectionListener((SelectionListener)listener);
        }
    }

    public void addDirtyListeners(ModifyListener dirtyListener, SelectionAdapter dirtySelectionListener) {
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public Group getConfigGroup() {
        return this.configGroup;
    }

    public Composite getAuthorizationTabComposite() {
        return this.authorizationTabComposite;
    }

    public CCombo getCcbAuthType() {
        return this.ccbAuthType;
    }

    public Composite getUserComposite() {
        return this.userComposite;
    }

    public Composite getBearerComposite() {
        return this.bearerComposite;
    }

    public Composite getNtmlComposite() {
        return this.ntmlComposite;
    }

    public Composite getAwsSignatureComposite() {
        return this.awsSignatureComposite;
    }

    public Composite getOauth1Composite() {
        return this.oauth1Composite;
    }

    public Composite getOauth2Composite() {
        return this.oauth2Composite;
    }

    public Composite getDigestAuthorizationConfigUiContainer() {
        return this.digestAuthorizationConfigUiContainer;
    }

    public ApiCollectionEntity getApiCollectionEntity() {
        return this.apiCollectionEntity;
    }

    public MCompositePart getCompositePart() {
        return this.compositePart;
    }

    private boolean isTopMostFolder() {
        FolderEntity parent = this.apiCollectionEntity.getParentFolder();
        return parent == null || parent.getParentFolder() == null || !(parent instanceof ApiCollectionEntity);
    }

    private void setFontStyle(Control control, int style) {
        Font font = control.getFont();
        FontData[] fontData = font.getFontData();
        int i = 0;
        while (i < fontData.length) {
            fontData[i].setStyle(style);
            ++i;
        }
        Font newFont = new Font((Device)control.getDisplay(), fontData);
        control.setFont(newFont);
        control.addDisposeListener(e -> newFont.dispose());
    }
}

