/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webservice.view;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.webservice.constants.ComposerWebserviceMessageConstants;
import com.kms.katalon.composer.webservice.constants.ImageConstants;
import com.kms.katalon.composer.webservice.constants.StringConstants;
import com.kms.katalon.entity.repository.DraftWebServiceRequestEntity;
import com.kms.katalon.entity.repository.WebServiceRequestEntity;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class WebServiceAPIControl
extends Composite {
    private Map<String, Item> dropDownItems = new HashMap<String, Item>();
    private GridData layoutData;
    private boolean sendingState;
    private WebServiceRequestEntity originalWsObject;
    private Menu originalSendMenu;

    public WebServiceAPIControl(Composite parent, WebServiceRequestEntity requestEntity) {
        super(parent, 0);
        this.originalWsObject = requestEntity;
        boolean isDraft = this.isDraft();
        this.setLayout((Layout)new GridLayout());
        this.createControl(isDraft);
    }

    private boolean isDraft() {
        return this.originalWsObject instanceof DraftWebServiceRequestEntity;
    }

    private void createControl(boolean isDraft) {
        ToolBar toolbar = new ToolBar((Composite)this, 131072);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.createDropdownBtnSendTestRequest(toolbar);
        if (!isDraft) {
            this.createDropdownBtnAddToNewTestCase(toolbar);
        } else {
            this.createBtnSaveDraft(toolbar);
        }
        toolbar.setLayoutData((Object)new GridData(0x1000000, 131072, false, true));
    }

    private void createDropdownBtnSendTestRequest(ToolBar toolbar) {
        ItemInfo btnSendTestRequestInfo = new ItemInfoBuilder().setControlId("dropdown send test request").build();
        ItemInfo[] sendTestRequestMenuItemInfos = new ItemInfo[]{new ItemInfoBuilder().setControlId("dropdown item test request and verify").setText(StringConstants.MENU_ITEM_TEST_REQUEST_AND_VERIFY).build(), new ItemInfoBuilder().setControlId("dropdown item test request and download").setText(StringConstants.MENU_ITEM_TEST_REQUEST_AND_DOWNLOAD).build()};
        this.createAndRegisterDropdownControls(toolbar, btnSendTestRequestInfo, sendTestRequestMenuItemInfos);
        this.setSendButtonState(false);
    }

    private void createDropdownBtnAddToNewTestCase(ToolBar toolbar) {
        ItemInfo btnAddToNewTestCaseInfo = new ItemInfoBuilder().setControlId("dropdown add to new test case").setImage(ImageConstants.WS_ADD_TO_TEST_CASE_24).setTooltip(ComposerWebserviceMessageConstants.BTN_ADD_TO_NEW_TEST_CASE).build();
        ItemInfo[] addToNewTestCaseMenuItemInfos = new ItemInfo[]{new ItemInfoBuilder().setControlId("dropdown item add to new test case").setText(StringConstants.MENU_ITEM_ADD_REQUEST_TO_NEW_TEST_CASE).build(), new ItemInfoBuilder().setControlId("dropdown item add to existing test case").setText(StringConstants.MENU_ITEM_ADD_REQUEST_TO_EXISTING_TEST_CASE).build()};
        this.createAndRegisterDropdownControls(toolbar, btnAddToNewTestCaseInfo, addToNewTestCaseMenuItemInfos);
    }

    private void createBtnSaveDraft(ToolBar toolbar) {
        this.createAndRegisterDropdownControls(toolbar, new ItemInfoBuilder().setControlId("dropdown save draft").setImage(ImageConstants.IMG_24_SAVE).setTooltip(ComposerWebserviceMessageConstants.BTN_SAVE_DRAFT_REQUEST).build(), null);
    }

    private void registerDropdownItem(String itemId, Item item) {
        this.dropDownItems.put(itemId, item);
    }

    private void createAndRegisterDropdownControls(ToolBar toolbar, ItemInfo toolItemInfo, ItemInfo[] menuItemInfos) {
        boolean shouldCreateDropdown = menuItemInfos != null && menuItemInfos.length > 0;
        ToolItem toolItem = new ToolItem(toolbar, shouldCreateDropdown ? 4 : 8);
        if (toolItemInfo.image != null) {
            toolItem.setImage(toolItemInfo.image);
        }
        if (StringUtils.isNotEmpty((CharSequence)toolItemInfo.tooltip)) {
            toolItem.setToolTipText(toolItemInfo.tooltip);
        }
        if (shouldCreateDropdown) {
            Menu menu = new Menu((Control)toolItem.getParent().getShell());
            int i = 0;
            while (i < menuItemInfos.length) {
                ItemInfo menuItemInfo = menuItemInfos[i];
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setID(i);
                if (StringUtils.isNotEmpty((CharSequence)menuItemInfo.text)) {
                    menuItem.setText(menuItemInfo.text);
                }
                if (StringUtils.isNotEmpty((CharSequence)menuItemInfo.tooltip)) {
                    menuItem.setToolTipText(menuItemInfo.tooltip);
                }
                if (menuItemInfo.image != null) {
                    menuItem.setImage(menuItemInfo.image);
                }
                this.registerDropdownItem(menuItemInfo.controlId, (Item)menuItem);
                ++i;
            }
            toolItem.setData((Object)menu);
        }
        this.registerDropdownItem(toolItemInfo.controlId, (Item)toolItem);
    }

    public void addItemSelectionListener(String controlId, SelectionListener selectionListener) {
        if (selectionListener == null) {
            return;
        }
        Item item = this.dropDownItems.get(controlId);
        if (item == null) {
            return;
        }
        if (item instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)item;
            toolItem.addSelectionListener(selectionListener);
        }
        if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            menuItem.addSelectionListener(selectionListener);
        }
    }

    public void setLayoutDataColumnsSpan(int numberOfColumn) {
        this.layoutData.horizontalSpan = numberOfColumn;
        this.layout();
    }

    private ToolItem getSendControl() {
        return (ToolItem)this.dropDownItems.get("dropdown send test request");
    }

    private ToolItem getAddRequestToTestCaseControl() {
        return (ToolItem)this.dropDownItems.get("dropdown add to new test case");
    }

    protected void checkSubclass() {
    }

    public void setSendButtonState(boolean sendingState) {
        this.sendingState = sendingState;
        ToolItem sendControl = this.getSendControl();
        if (this.sendingState) {
            this.originalSendMenu = (Menu)sendControl.getData();
            sendControl.setData(null);
            sendControl.setToolTipText(StringConstants.STOP);
            sendControl.setImage(ImageConstants.IMG_24_STOP);
        } else {
            if (this.originalSendMenu != null) {
                sendControl.setData((Object)this.originalSendMenu);
            }
            sendControl.setToolTipText(ComposerWebserviceMessageConstants.BTN_SEND_TEST_REQUEST);
            sendControl.setImage(ImageConstants.IMG_24_PLAY);
        }
        sendControl.getParent().update();
    }

    public boolean getSendingState() {
        return this.sendingState;
    }

    public Menu getSendMenu() {
        if (this.sendingState) {
            return null;
        }
        return (Menu)this.getSendControl().getData();
    }

    public Menu getAddRequestToTestCaseMenu() {
        return (Menu)this.getAddRequestToTestCaseControl().getData();
    }

    public static final class ControlIds {
        public static final String DROPDOWN_SEND_TEST_REQUEST = "dropdown send test request";
        public static final String DROPDOWN_ITEM_SEND_AND_VERIFY = "dropdown item test request and verify";
        public static final String DROPDOWN_ITEM_SEND_AND_DOWNLOAD = "dropdown item test request and download";
        public static final String DROPDOWN_ADD_TO_NEW_TEST_CASE = "dropdown add to new test case";
        public static final String DROPDOWN_ITEM_ADD_TO_NEW_TEST_CASE = "dropdown item add to new test case";
        public static final String DROPDOWN_ITEM_ADD_TO_EXISTING_TEST_CASE = "dropdown item add to existing test case";
        public static final String DROPDOWN_SAVE_DRAFT = "dropdown save draft";
    }

    private class ItemInfo {
        public String controlId;
        public String text;
        public String tooltip;
        public Image image;

        private ItemInfo() {
        }
    }

    private class ItemInfoBuilder {
        private ItemInfo itemInfo;

        public ItemInfoBuilder() {
            this.itemInfo = new ItemInfo();
        }

        public ItemInfoBuilder setControlId(String controlId) {
            this.itemInfo.controlId = controlId;
            return this;
        }

        public ItemInfoBuilder setText(String text) {
            this.itemInfo.text = text;
            return this;
        }

        public ItemInfoBuilder setTooltip(String tooltip) {
            this.itemInfo.tooltip = tooltip;
            return this;
        }

        public ItemInfoBuilder setImage(Image image) {
            this.itemInfo.image = image;
            return this;
        }

        public ItemInfo build() {
            return this.itemInfo;
        }
    }
}

