/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.action;

import com.kms.katalon.composer.components.application.ApplicationSingleton;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.ModelServiceSingleton;
import com.kms.katalon.composer.search.constants.StringConstants;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import java.text.MessageFormat;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class OpenEditorAction {
    public static void openTestCase(TestCaseEntity testCase) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("TESTCASE/OPEN", (Object)testCase);
    }

    public static void openTestObject(WebElementEntity testObject) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("TESTOBJECT/OPEN", (Object)testObject);
    }

    public static void openTestSuite(TestSuiteEntity testSuite) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("TESTSUITE/OPEN", (Object)testSuite);
    }

    public static void openTestData(DataFileEntity testData) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("TESTDATA/OPEN", (Object)testData);
    }

    public static void openReport(ReportEntity report) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("REPORT/OPEN", (Object)report);
    }

    public static void openExecutionProfile(ExecutionProfileEntity profile) {
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("EXPLORER/OPEN_SELECTED_ITEM", (Object)profile);
    }

    public static void openEditor(TestCaseEntity testCase, int offset, int length) {
        block5: {
            IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
            MApplication application = ApplicationSingleton.getInstance().getApplication();
            EModelService modelService = ModelServiceSingleton.getInstance().getModelService();
            try {
                if (testCase == null) {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)StringConstants.ACT_WARN_MSG_TEST_CASE_NOT_FOUND);
                    return;
                }
                eventBroker.send("TESTCASE/OPEN", (Object)testCase);
                MPartStack stack = (MPartStack)modelService.find("com.kms.katalon.composer.content", (MUIElement)application);
                if (stack == null) break block5;
                String testCaseCompositePartId = EntityPartUtil.getTestCaseCompositePartId((String)testCase.getId());
                MCompositePart mcompositePart = (MCompositePart)modelService.find(testCaseCompositePartId, (MUIElement)stack);
                TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)mcompositePart.getObject();
                testCaseCompositePart.setSelectedPart(testCaseCompositePart.getChildCompatibilityPart());
                CompatibilityEditor groovyEditor = (CompatibilityEditor)testCaseCompositePart.getChildCompatibilityPart().getObject();
                AbstractTextEditor editor = (AbstractTextEditor)groovyEditor.getEditor();
                try {
                    editor.selectAndReveal(offset, length);
                }
                catch (Exception exception) {
                    MessageDialog.openWarning(null, (String)StringConstants.WARN_TITLE, (String)MessageFormat.format(StringConstants.ACT_WARN_MSG_LINE_NOT_FOUND, Integer.toString(offset)));
                    return;
                }
            }
            catch (Exception e) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.WARN_TITLE, (String)StringConstants.ACT_WARN_MSG_UNABLE_TO_OPEN_TEST_CASE);
                LoggerSingleton.getInstance().getLogger().error((Throwable)e);
            }
        }
    }
}

