/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.event;

import com.katalon.recorder.web.domain.event.IWebDriverConnectionEventBus;
import com.katalon.recorder.web.domain.event.WebDriverConnectionEvent;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebDriverConnectionEventBus
implements IWebDriverConnectionEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverConnectionEventBus.class);
    private final PublishSubject<WebDriverConnectionEvent> eventPublisher = PublishSubject.create();

    @Inject
    public WebDriverConnectionEventBus() {
    }

    public void publishEvent(WebDriverConnectionEvent event) {
        logger.info("Publishing WebDriverConnectionEvent | type = {} | sessionId = {}", (Object)event.getClass().getSimpleName(), (Object)event.getWebDriverId());
        this.eventPublisher.onNext((Object)event);
    }

    public <T extends WebDriverConnectionEvent> Observable<T> getObservableToSubscribe(Class<T> clazz) {
        return this.eventPublisher.filter(clazz::isInstance).cast(clazz);
    }
}

