/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure.converter;

import com.katalon.recorder.core.constant.AttributeConditionOperator;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.domain.model.CapturedObjectAttribute;
import com.katalon.recorder.core.domain.model.CapturedObjectXPath;
import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.ICapturedObjectXPath;
import com.katalon.recorder.web.domain.model.CapturedWebElement;
import com.katalon.recorder.web.domain.model.CapturedWebIFrame;
import com.katalon.recorder.web.domain.model.CapturedWebPage;
import com.katalon.recorder.web.domain.model.CapturedWebShadowRoot;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementXpathEntity;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapturedObjectConverter {
    private static final Logger logger = LoggerFactory.getLogger(CapturedObjectConverter.class);

    private CapturedObjectConverter() {
    }

    public static List<IWebCapturedObject> convert(List<WebElementEntity> webElementEntities) {
        HashMap<String, CapturedWebPage> webPageMap = new HashMap<String, CapturedWebPage>();
        HashMap<String, IWebCapturedObject> webTestObjectMap = new HashMap<String, IWebCapturedObject>();
        for (WebElementEntity entity : webElementEntities) {
            IWebCapturedObject webTestObject;
            FolderEntity folder = entity.getParentFolder();
            CapturedWebPage parentPage = (CapturedWebPage)webPageMap.get(folder.getIdForDisplay());
            if (parentPage == null) {
                parentPage = new CapturedWebPage(folder.getIdForDisplay());
                parentPage.setEntityPath(entity.getLocation());
                parentPage.setName(folder.getName());
                webPageMap.put(folder.getIdForDisplay(), parentPage);
            }
            if ((webTestObject = (IWebCapturedObject)webTestObjectMap.get(entity.getIdForDisplay())) != null) continue;
            CapturedObjectConverter.createWebElementFromTestObject(entity, false, parentPage, webTestObjectMap);
        }
        return new ArrayList<IWebCapturedObject>(webPageMap.values());
    }

    private static IWebCapturedObject createWebElementFromTestObject(WebElementEntity webElementEntity, boolean isParentElement, CapturedWebPage parentPage, Map<String, IWebCapturedObject> webElementMap) {
        BundleContext bundleContext;
        IEclipseContext context;
        IFeatureController featureController;
        if (webElementEntity == null) {
            return null;
        }
        String entityId = webElementEntity.getIdForDisplay();
        IWebCapturedObject existed = webElementMap.get(entityId);
        if (existed != null) {
            return existed;
        }
        IWebCapturedObject parentElement = null;
        Optional<WebElementPropertyEntity> refElement = webElementEntity.getWebElementProperties().stream().filter(p -> "ref_element".equals(p.getName())).findFirst();
        Boolean isParentShadowRoot = Optional.ofNullable(webElementEntity.getProperty("ref_element_is_shadow_root")).map(WebElementPropertyEntity::getValue).map(Boolean::valueOf).orElse(false);
        if (refElement.isPresent()) {
            try {
                parentElement = CapturedObjectConverter.createWebElementFromTestObject(ObjectRepositoryController.getInstance().getWebElementByDisplayPk(refElement.get().getValue()), true, parentPage, webElementMap);
            }
            catch (Exception e) {
                logger.error("Failed to get parent testObject | testObject name = {} | parent ref = {}", new Object[]{webElementEntity.getName(), refElement.get().getValue(), e});
            }
        }
        CapturedWebElement capturedObject = isParentElement ? (isParentShadowRoot.booleanValue() ? new CapturedWebShadowRoot(entityId) : new CapturedWebIFrame(entityId)) : new CapturedWebElement(entityId);
        capturedObject.setElementUid(webElementEntity.getElementGuidId());
        capturedObject.setEntityPath(webElementEntity.getLocation());
        capturedObject.setName(webElementEntity.getName());
        capturedObject.setParent((ICapturedObject)(parentElement != null ? parentElement : parentPage));
        Optional.ofNullable(webElementEntity.getWebElementProperties()).orElse(Collections.emptyList()).stream().map(CapturedObjectConverter::convert).forEach(arg_0 -> ((IWebCapturedObject)capturedObject).addAttribute(arg_0));
        capturedObject.setLocatorType(CapturedObjectConverter.convert(webElementEntity.getGenericSelectorMethod()));
        Optional.ofNullable(webElementEntity.getSelectorCollection()).orElse(Collections.emptyMap()).forEach((arg_0, arg_1) -> CapturedObjectConverter.lambda$5((IWebCapturedObject)capturedObject, arg_0, arg_1));
        List webElementXpaths = webElementEntity.getWebElementXpaths();
        if (webElementXpaths != null && !webElementXpaths.isEmpty()) {
            webElementXpaths.stream().map(CapturedObjectConverter::convert).forEach(arg_0 -> ((IWebCapturedObject)capturedObject).addXPath(arg_0));
        }
        if ((featureController = (IFeatureController)(context = EclipseContextFactory.getServiceContext((BundleContext)(bundleContext = FrameworkUtil.getBundle(WebElementUtils.class).getBundleContext()))).get(IFeatureController.class)).canUse(ProductFeature.SMART_LOCATOR)) {
            capturedObject.addLocator(LocatorType.SMART_LOCATOR, (String)webElementEntity.getSmartLocatorCollection().get(WebElementSelectorMethod.SMART_LOCATOR));
        }
        webElementMap.put(entityId, (IWebCapturedObject)capturedObject);
        return capturedObject;
    }

    private static LocatorType convert(WebElementSelectorMethod selectorMethod) {
        return switch (selectorMethod) {
            case WebElementSelectorMethod.XPATH -> LocatorType.XPATH;
            case WebElementSelectorMethod.CSS -> LocatorType.CSS;
            case WebElementSelectorMethod.IMAGE -> LocatorType.IMAGE;
            case WebElementSelectorMethod.SMART_LOCATOR -> LocatorType.SMART_LOCATOR;
            default -> LocatorType.ATTRIBUTES;
        };
    }

    private static CapturedObjectAttribute convert(WebElementPropertyEntity webElementPropertyEntity) {
        return new CapturedObjectAttribute(webElementPropertyEntity.getName(), AttributeConditionOperator.fromValue((String)webElementPropertyEntity.getMatchCondition()), webElementPropertyEntity.getValue(), Boolean.valueOf(webElementPropertyEntity.getIsSelected()));
    }

    private static ICapturedObjectXPath convert(WebElementXpathEntity webElementXpathEntity) {
        return new CapturedObjectXPath(webElementXpathEntity.getName(), webElementXpathEntity.getMatchCondition(), webElementXpathEntity.getValue(), webElementXpathEntity.getIsSelected());
    }

    private static /* synthetic */ void lambda$5(IWebCapturedObject iWebCapturedObject, WebElementSelectorMethod selectorMethod, String value) {
        iWebCapturedObject.addLocator(CapturedObjectConverter.convert(selectorMethod), value);
    }
}

