/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation;

import com.equo.chromium.swt.Browser;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.web.presentation.IWebCapturedObjectView;
import com.katalon.recorder.web.presentation.event.CapturedObjectMakeDefaultLocatorClickedEvent;
import com.katalon.recorder.web.presentation.event.CapturedObjectTakeScreenshotClickedEvent;
import com.katalon.recorder.web.presentation.event.CapturedObjectVerifyAndHighlightClickedEvent;
import com.katalon.recorder.web.presentation.event.IWebViewInteractionEventBus;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEvent;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class WebCapturedObjectView
implements IWebCapturedObjectView {
    private final AtomicReference<Browser> browser;
    private final IWebViewInteractionEventBus webViewInteractionEventBus;

    @Inject
    public WebCapturedObjectView(IWebViewInteractionEventBus webViewInteractionEventBus) {
        this.webViewInteractionEventBus = webViewInteractionEventBus;
        this.browser = new AtomicReference();
    }

    public void init(Browser browser) {
        this.browser.set(browser);
        this.registerBrowserFunctions();
    }

    public void setHighlighting(boolean highlighting) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"capturedObjectViewFunc.callSetHighlighting", (Object[])new Object[]{highlighting});
    }

    public void setTakingScreenshot(boolean takingScreenshot) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"capturedObjectViewFunc.callSetTakingScreenshot", (Object[])new Object[]{takingScreenshot});
    }

    public void updateSuccessActionStatusMessage(String message, int durationInSeconds) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"capturedObjectViewFunc.callUpdateSuccessActionStatusMessage", (Object[])new Object[]{message, durationInSeconds});
    }

    public void updateErrorActionStatusMessage(String message, int durationInSeconds) {
        BrowserFunctionUtil.execute((Browser)this.browser.get(), (String)"capturedObjectViewFunc.callUpdateErrorActionStatusMessage", (Object[])new Object[]{message, durationInSeconds});
    }

    private void registerBrowserFunctions() {
        BrowserFunctionUtil.registerBrowserFunction((String)"capturedObjectView.onVerifyAndHighlightClicked", String.class, LocatorType.class, (testObjectId, locatorType) -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new CapturedObjectVerifyAndHighlightClickedEvent(testObjectId, locatorType)));
        BrowserFunctionUtil.registerBrowserFunction((String)"capturedObjectView.onTakeScreenshotClicked", String.class, LocatorType.class, (testObjectId, locatorType) -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new CapturedObjectTakeScreenshotClickedEvent(testObjectId, locatorType)));
        BrowserFunctionUtil.registerBrowserFunction((String)"capturedObjectView.onMakeDefaultLocatorClicked", String.class, LocatorType.class, (testObjectId, locatorType) -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new CapturedObjectMakeDefaultLocatorClickedEvent(testObjectId, locatorType)));
    }
}

