/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.kobiton.preferences;

import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.service.ApplicationManager;
import com.kms.katalon.integration.kobiton.entity.KobitonApiKey;
import com.kms.katalon.integration.kobiton.providers.KobitonApiProvider;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class KobitonPreferencesProvider {
    private static final String KOBITON_PLUGIN_ID = "com.katalon.katalon-studio-kobiton";
    private static final String DEFAULT_KOBITON_PROTOCOL = "http";

    public static ScopedPreferenceStore getPreferencetStore() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.integration.kobiton");
    }

    public static boolean isKobitonIntegrationAvailable() {
        return KobitonPreferencesProvider.isKobitonIntegrationEnabled() && KobitonPreferencesProvider.isKobitonPluginInstalled();
    }

    public static boolean isKobitonIntegrationEnabled() {
        return KobitonPreferencesProvider.getPreferencetStore().getBoolean("kobiton.integration.enable");
    }

    public static boolean isKobitonPluginInstalled() {
        Plugin plugin = ApplicationManager.getInstance().getPluginManager().getPlugin(KOBITON_PLUGIN_ID);
        return plugin != null;
    }

    public static String getKobitonUserName() {
        String username = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.username");
        return StringUtils.defaultString((String)username).trim();
    }

    public static void saveKobitonUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.username", userName);
    }

    public static String getKobitonPassword() {
        return KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.password");
    }

    public static void saveKobitonPassword(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.password", password);
    }

    public static String getKobitonToken() {
        String username = KobitonPreferencesProvider.getKobitonUserName();
        String apiKey = KobitonPreferencesProvider.getKobitonApiKey();
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)apiKey)) {
            return KobitonApiProvider.buildToken(username, apiKey);
        }
        String legacyToken = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.token");
        if (StringUtils.isNotBlank((CharSequence)legacyToken)) {
            return StringUtils.defaultString((String)legacyToken).trim();
        }
        return "";
    }

    public static void saveKobitonToken(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.token", token);
    }

    public static String getKobitonApiKey() {
        String apiKey;
        String legacyApiKey = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.apiKey");
        String newApiKey = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.apiKey");
        String string = apiKey = StringUtils.isNotBlank((CharSequence)newApiKey) ? newApiKey : legacyApiKey;
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            String legacyToken = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.token");
            if (StringUtils.isBlank((CharSequence)legacyToken)) {
                return "";
            }
            try {
                List<KobitonApiKey> apiKeys = KobitonApiProvider.getApiKeyList(KobitonPreferencesProvider.getKobitonServerUrl(), KobitonPreferencesProvider.getKobitonToken());
                if (!apiKeys.isEmpty()) {
                    apiKey = apiKeys.get(0).getKey();
                    KobitonPreferencesProvider.saveKobitonApiKey(apiKey);
                }
            }
            catch (Exception exception) {
                return "";
            }
        }
        return StringUtils.defaultString((String)apiKey).trim();
    }

    public static void saveKobitonApiKey(String apiKey) {
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            return;
        }
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.apiKey", apiKey);
    }

    public static String getKobitonServerUrl() {
        String legacyServerUrl = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.server.endpoint");
        String newServerUrl = KobitonPreferencesProvider.getPreferencetStore().getString("kobiton.authentication.serverUrl");
        String serverUrl = StringUtils.isNotBlank((CharSequence)newServerUrl) ? newServerUrl : legacyServerUrl;
        return StringUtils.defaultString((String)serverUrl).trim();
    }

    public static void saveKobitonServerUrl(String serverUrl) {
        KobitonPreferencesProvider.getPreferencetStore().setValue("kobiton.authentication.serverUrl", serverUrl);
    }

    public static String getKobitonProtocol() {
        try {
            String kobitonServerUrl = KobitonPreferencesProvider.getKobitonServerUrl();
            return new URL(kobitonServerUrl).getProtocol();
        }
        catch (Exception exception) {
            return DEFAULT_KOBITON_PROTOCOL;
        }
    }

    public static String getKobitonHost() {
        try {
            String kobitonServerUrl = KobitonPreferencesProvider.getKobitonServerUrl();
            return new URL(kobitonServerUrl).getHost();
        }
        catch (Exception exception) {
            return "api.kobiton.com";
        }
    }
}

