/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm.util;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.Random;
import javax.crypto.Cipher;
import net.lightbody.bmp.mitm.exception.ExportException;
import net.lightbody.bmp.mitm.exception.ImportException;

public class EncryptionUtil {
    public static String getSignatureAlgorithm(String messageDigest, Key signingKey) {
        return String.valueOf(messageDigest) + "with" + EncryptionUtil.getDigitalSignatureType(signingKey);
    }

    public static String getDigitalSignatureType(Key signingKey) {
        if (signingKey instanceof ECKey) {
            return "ECDSA";
        }
        if (signingKey instanceof RSAKey) {
            return "RSA";
        }
        if (signingKey instanceof DSAKey) {
            return "DSA";
        }
        throw new IllegalArgumentException("Cannot determine digital signature encryption type for unknown key type: " + signingKey.getClass().getCanonicalName());
    }

    public static BigInteger getRandomBigInteger(int bits) {
        return new BigInteger(bits, new Random());
    }

    public static boolean isRsaKey(Key key) {
        return "RSA".equals(key.getAlgorithm());
    }

    public static boolean isEcKey(Key key) {
        return "EC".equals(key.getAlgorithm());
    }

    public static void writePemStringToFile(File file, String pemDataToWrite) {
        try {
            Files.write(file.toPath(), pemDataToWrite.getBytes(StandardCharsets.US_ASCII), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ExportException("Unable to write PEM string to file: " + file.getName(), e);
        }
    }

    public static String readPemStringFromFile(File file) {
        try {
            byte[] fileContents = Files.readAllBytes(file.toPath());
            return new String(fileContents, StandardCharsets.US_ASCII);
        }
        catch (IOException iOException) {
            throw new ImportException("Unable to read PEM-encoded data from file: " + file.getName());
        }
    }

    public static boolean isUnlimitedStrengthAllowed() {
        try {
            return Cipher.getMaxAllowedKeyLength("AES") >= 256;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }
}

