/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.dialog;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.provider.TestCaseRootSelectionTreeContentProvider;
import com.kms.katalon.composer.integration.qtest.dialog.provider.TestCaseRootSelectionTreeLabelProvider;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestModule;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class TestCaseRootSelectionDialog
extends Dialog {
    private static final int FONT_SIZE_SMALL = 8;
    private Composite container;
    private QTestModule moduleRoot;
    private TreeViewer treeViewer;
    private QTestModule selectedModule;
    private Label lblHeader;
    private boolean updateNeeded;
    private boolean exit;
    private String projectDir;
    private QTestProject qTestProject;
    private Label lblStatus;
    private Composite warningComposite;

    public void setProjectDir(String projectDir) {
        this.projectDir = projectDir;
    }

    public void setQTestProject(QTestProject qTestProject) {
        this.qTestProject = qTestProject;
    }

    public TestCaseRootSelectionDialog(Shell parentShell, QTestModule module, boolean updateNeeded) {
        super(parentShell);
        this.moduleRoot = module;
        this.updateNeeded = updateNeeded;
        this.exit = false;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(this.container, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.lblHeader = new Label(composite, 64);
        this.lblHeader.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblHeader.setText(StringConstants.DIA_INFO_TEST_CASE_ROOT);
        this.lblStatus = new Label(composite, 0);
        this.lblStatus.setText(StringConstants.CM_MSG_PLEASE_WAIT);
        Composite compositeTable = new Composite(this.container, 0);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(compositeTable, 67584);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnName = treeViewerColumn.getColumn();
        trclmnName.setText(StringConstants.NAME);
        TreeColumnLayout tableLayout = new TreeColumnLayout();
        tableLayout.setColumnData((Widget)trclmnName, (ColumnLayoutData)new ColumnWeightData(98, 0));
        compositeTable.setLayout((Layout)tableLayout);
        this.treeViewer.setContentProvider((IContentProvider)new TestCaseRootSelectionTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TestCaseRootSelectionTreeLabelProvider());
        this.warningComposite = new Composite(this.container, 0);
        this.warningComposite.setLayout((Layout)new GridLayout(2, false));
        this.warningComposite.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 1, 1));
        this.warningComposite.setVisible(false);
        CLabel lblWarningIcon = new CLabel(this.warningComposite, 0);
        lblWarningIcon.setImage(ImageConstants.IMG_20_WARNING_MSG);
        lblWarningIcon.setRightMargin(8);
        Label lblWarningMsg = new Label(this.warningComposite, 64);
        lblWarningMsg.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        lblWarningMsg.setText(StringConstants.DIA_MSG_USER_CHOOSES_TEST_CASE_ROOT);
        ControlUtils.setFontSize((Control)lblWarningMsg, (int)8);
        return this.container;
    }

    public void create() {
        super.create();
        this.setInput();
        this.addModifyListeners();
    }

    private void addModifyListeners() {
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestCaseRootSelectionDialog.this.validate();
            }
        });
        this.getShell().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (TestCaseRootSelectionDialog.this.exit) {
                    TestCaseRootSelectionDialog.this.close();
                }
            }
        });
    }

    private void validate() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            this.getButton(0).setEnabled(false);
        } else {
            this.selectedModule = (QTestModule)selection.getFirstElement();
            this.getButton(0).setEnabled(true);
            if (this.selectedModule != this.moduleRoot) {
                this.warningComposite.setVisible(false);
            } else {
                this.warningComposite.setVisible(true);
            }
        }
    }

    private void setInput() {
        if (this.updateNeeded) {
            this.getButton(0).setEnabled(false);
            this.getButton(1).setEnabled(false);
            Display display = this.treeViewer.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        TestCaseRootSelectionDialog.this.moduleRoot = QTestIntegrationFolderManager.updateModuleViaAPI((IQTestCredential)QTestSettingCredential.getCredential((String)TestCaseRootSelectionDialog.this.projectDir), (long)TestCaseRootSelectionDialog.this.qTestProject.getId(), (QTestModule)TestCaseRootSelectionDialog.this.moduleRoot);
                        TestCaseRootSelectionDialog.this.treeViewer.setInput(Arrays.asList(TestCaseRootSelectionDialog.this.moduleRoot));
                        TestCaseRootSelectionDialog.this.treeViewer.expandAll();
                        TestCaseRootSelectionDialog.this.lblStatus.dispose();
                        TestCaseRootSelectionDialog.this.container.layout(true);
                        TestCaseRootSelectionDialog.this.validate();
                        TestCaseRootSelectionDialog.this.getButton(0).setEnabled(true);
                        TestCaseRootSelectionDialog.this.getButton(1).setEnabled(true);
                    }
                    catch (Exception e) {
                        TestCaseRootSelectionDialog.this.getShell().setVisible(false);
                        MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.DIA_MSG_UNABLE_TO_LOAD_TEST_SUITE_PARENT, (String)e.getClass().getSimpleName());
                        TestCaseRootSelectionDialog.this.exit = true;
                    }
                }
            });
        } else {
            this.treeViewer.setInput(Arrays.asList(this.moduleRoot));
            this.treeViewer.expandAll();
            this.validate();
        }
    }

    public QTestModule getSelectedModule() {
        return this.selectedModule;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_TITLE_TEST_CASE_ROOT);
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected boolean isResizable() {
        return true;
    }
}

