/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.AbstractQTestHandler;
import com.kms.katalon.composer.report.lookup.LogRecordLookup;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationReportManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestReport;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.model.ReportTestCaseLogPair;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;

public class QTestDisintegrateReportHandler
extends AbstractQTestHandler {
    private List<ReportTestCaseLogPair> fPairs;
    @Inject
    private ESelectionService selectionService;
    private boolean canExecute;
    private Thread thread;

    @CanExecute
    public boolean canExecute(final MDirectMenuItem item) {
        if (this.canExecute) {
            return this.canExecute;
        }
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String label;
                block11: {
                    FolderEntity folderEntity;
                    block12: {
                        Object selectedEntity;
                        block10: {
                            label = item.getLabel();
                            selectedEntity = QTestDisintegrateReportHandler.this.getFirstSelectedObject(QTestDisintegrateReportHandler.this.selectionService);
                            if (selectedEntity != null) break block10;
                            item.setLabel(label);
                            item.setEnabled(QTestDisintegrateReportHandler.this.fPairs.size() > 0);
                            QTestDisintegrateReportHandler.this.canExecute = item.isEnabled();
                            return;
                        }
                        QTestDisintegrateReportHandler.this.fPairs = new ArrayList<ReportTestCaseLogPair>();
                        if (selectedEntity instanceof ReportEntity) {
                            ReportTestCaseLogPair pair = QTestDisintegrateReportHandler.this.getTestCaseLogPair((ReportEntity)selectedEntity);
                            if (pair != null) {
                                QTestDisintegrateReportHandler.this.fPairs.add(pair);
                            }
                            break block11;
                        }
                        if (!(selectedEntity instanceof FolderEntity)) break block11;
                        folderEntity = (FolderEntity)selectedEntity;
                        if (QTestIntegrationUtil.isFolderReportInTestSuiRepo((FolderEntity)folderEntity, (ProjectEntity)QTestDisintegrateReportHandler.this.getProjectEntity())) break block12;
                        item.setLabel(label);
                        item.setEnabled(QTestDisintegrateReportHandler.this.fPairs.size() > 0);
                        QTestDisintegrateReportHandler.this.canExecute = item.isEnabled();
                        return;
                    }
                    try {
                        try {
                            List children = FolderController.getInstance().getAllDescentdantEntities(folderEntity);
                            int i = 0;
                            while (i < children.size()) {
                                ReportTestCaseLogPair pair;
                                Object childObject = children.get(i);
                                item.setLabel(MessageFormat.format(StringConstants.HDL_LABEL_VALIDATING_REPORT, label, i * 100 / children.size()));
                                if (childObject instanceof ReportEntity && (pair = QTestDisintegrateReportHandler.this.getTestCaseLogPair((ReportEntity)childObject)) != null) {
                                    QTestDisintegrateReportHandler.this.fPairs.add(pair);
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            LoggerSingleton.logError((Throwable)e);
                            item.setLabel(label);
                            item.setEnabled(QTestDisintegrateReportHandler.this.fPairs.size() > 0);
                            QTestDisintegrateReportHandler.this.canExecute = item.isEnabled();
                        }
                    }
                    catch (Throwable throwable) {
                        item.setLabel(label);
                        item.setEnabled(QTestDisintegrateReportHandler.this.fPairs.size() > 0);
                        QTestDisintegrateReportHandler.this.canExecute = item.isEnabled();
                        throw throwable;
                    }
                }
                item.setLabel(label);
                item.setEnabled(QTestDisintegrateReportHandler.this.fPairs.size() > 0);
                QTestDisintegrateReportHandler.this.canExecute = item.isEnabled();
            }
        });
        this.thread.start();
        MElementContainer menuImpl = item.getParent();
        Menu menu = (Menu)menuImpl.getWidget();
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                QTestDisintegrateReportHandler.this.clearData();
            }
        });
        menu.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QTestDisintegrateReportHandler.this.clearData();
            }
        });
        return this.canExecute;
    }

    @Execute
    public void execute() {
        QTestDisintegrateReportHandler.performDisintegrateTestCaseLogs(this.fPairs);
    }

    private ReportTestCaseLogPair getTestCaseLogPair(ReportEntity reportEntity) throws Exception {
        TestSuiteLogRecord testSuiteLogRecord = LogRecordLookup.getInstance().getTestSuiteLogRecord(reportEntity);
        if (testSuiteLogRecord == null) {
            return null;
        }
        ArrayList<TestCaseLogRecord> testCasesCanBeDisintegrated = new ArrayList<TestCaseLogRecord>();
        ILogRecord[] iLogRecordArray = testSuiteLogRecord.getChildRecords();
        int n = iLogRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILogRecord selectedTestCaseLogObject = iLogRecordArray[n2];
            TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)selectedTestCaseLogObject;
            switch (QTestIntegrationUtil.evaluateTestCaseLog((TestCaseLogRecord)testCaseLogRecord, (QTestSuite)QTestIntegrationUtil.getSelectedQTestSuite((TestSuiteLogRecord)testSuiteLogRecord), (ReportEntity)reportEntity)) {
                case INTEGRATED: {
                    testCasesCanBeDisintegrated.add(testCaseLogRecord);
                    break;
                }
            }
            ++n2;
        }
        if (testCasesCanBeDisintegrated.size() > 0) {
            return new ReportTestCaseLogPair(reportEntity, testCasesCanBeDisintegrated);
        }
        return null;
    }

    public static void performDisintegrateTestCaseLogs(List<ReportTestCaseLogPair> testCaseLogPairs) {
        QTestDisintegrateReportHandler.performDisintegrateTestCaseLogs(testCaseLogPairs, true);
    }

    public static void performDisintegrateTestCaseLogs(List<ReportTestCaseLogPair> testCaseLogPairs, boolean needConfirmed) {
        if (needConfirmed && !MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.DIA_CONFIRM_DISINTEGRATE_TEST_LOGS)) {
            return;
        }
        for (ReportTestCaseLogPair pair : testCaseLogPairs) {
            ReportEntity reportEntity = pair.getReportEntity();
            List testCasesCanBeDisintegrated = pair.getTestCaseLogs();
            try {
                IntegratedEntity reportIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)reportEntity);
                QTestReport qTestReport = QTestIntegrationReportManager.getQTestReportByIntegratedEntity((IntegratedEntity)reportIntegratedEntity);
                for (TestCaseLogRecord testCaseLogRecord : testCasesCanBeDisintegrated) {
                    int index = QTestIntegrationUtil.getTestCaseLogIndexByIndexInReport((TestCaseLogRecord)testCaseLogRecord, (ReportEntity)reportEntity);
                    qTestReport.getTestLogMap().remove(index);
                }
                reportEntity = QTestIntegrationUtil.saveReportEntity((QTestReport)qTestReport, (ReportEntity)reportEntity);
                EventBrokerSingleton.getInstance().getEventBroker().post("REPORT/UPDATED", (Object)new Object[]{reportEntity.getId(), reportEntity});
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    @PreDestroy
    public void clearData() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            this.thread = null;
            this.canExecute = false;
        }
    }
}

