/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.AbstractQTestHandler;
import com.kms.katalon.composer.integration.qtest.job.DisintegrateTestSuiteJob;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;

public class QTestDisintegrateTestSuiteHandler
extends AbstractQTestHandler {
    @Inject
    private ESelectionService selectionService;
    private List<TestSuiteEntity> fTestSuites;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CanExecute
    public boolean canExecute() {
        FolderEntity folderEntity;
        block10: {
            Object selectedEntity;
            block9: {
                block8: {
                    ProjectEntity projectEntity;
                    block7: {
                        projectEntity = ProjectController.getInstance().getCurrentProject();
                        selectedEntity = this.getFirstSelectedObject(this.selectionService);
                        if (selectedEntity != null) break block7;
                        return false;
                    }
                    if (QTestIntegrationUtil.canBeDownloadedOrDisintegrated((IntegratedFileEntity)((IntegratedFileEntity)selectedEntity), (ProjectEntity)projectEntity)) break block8;
                    return false;
                }
                this.fTestSuites = new ArrayList<TestSuiteEntity>();
                if (!(selectedEntity instanceof TestSuiteEntity)) break block9;
                if (this.getUploadedQTestSuites((TestSuiteEntity)selectedEntity).size() <= 0) return false;
                this.fTestSuites.add((TestSuiteEntity)selectedEntity);
                return this.fTestSuites.size() > 0;
            }
            if (!(selectedEntity instanceof FolderEntity)) return this.fTestSuites.size() > 0;
            folderEntity = (FolderEntity)selectedEntity;
            if (folderEntity.getFolderType() == FolderEntity.FolderType.TESTSUITE) break block10;
            return false;
        }
        try {
            for (Object childObject : FolderController.getInstance().getAllDescentdantEntities(folderEntity)) {
                if (!(childObject instanceof TestSuiteEntity) || this.getUploadedQTestSuites((TestSuiteEntity)childObject).size() <= 0) continue;
                this.fTestSuites.add((TestSuiteEntity)childObject);
            }
            return this.fTestSuites.size() > 0;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    @Execute
    public void execute() {
        if (this.fTestSuites == null) {
            return;
        }
        if (!MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.VIEW_CONFIRM_DISINTEGRATE_TEST_SUITE)) {
            return;
        }
        try {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            Object selectedEntity = this.getFirstSelectedObject(this.selectionService);
            if (selectedEntity instanceof FolderEntity) {
                FolderEntity folderEntity = (FolderEntity)selectedEntity;
                String folderId = folderEntity.getIdForDisplay();
                TestSuiteRepo repo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)folderEntity, (ProjectEntity)projectEntity);
                IntegratedEntity folderIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)folderEntity);
                IntegratedEntity integratedProjectEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
                List testSuiteRepositories = QTestIntegrationUtil.getTestSuiteRepositories((ProjectEntity)projectEntity, (List)QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)integratedProjectEntity));
                testSuiteRepositories.remove(repo);
                if (repo != null && repo.getFolderId().equals(folderId)) {
                    this.removeTestSuiteRepoFromProject(folderId, repo.getQTestProject());
                    this.saveFolder(folderEntity, folderIntegratedEntity);
                }
            }
            DisintegrateTestSuiteJob job = new DisintegrateTestSuiteJob(this.fTestSuites);
            job.schedule();
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private List<QTestSuite> getUploadedQTestSuites(TestSuiteEntity testSuite) throws QTestInvalidFormatException {
        List qTestSuites = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity((IntegratedEntity)QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite));
        ArrayList<QTestSuite> uploadedQTestSuites = new ArrayList<QTestSuite>();
        for (QTestSuite availableQTestSuite : qTestSuites) {
            if (availableQTestSuite.getId() <= 0L) continue;
            uploadedQTestSuites.add(availableQTestSuite);
        }
        return uploadedQTestSuites;
    }

    private void removeTestSuiteRepoFromProject(String folderId, QTestProject qTestProject) throws Exception {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        List qTestProjects = QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)projectIntegratedEntity);
        for (QTestProject systemQTestProject : qTestProjects) {
            if (!systemQTestProject.equals((Object)qTestProject)) continue;
            systemQTestProject.getTestSuiteFolderIds().remove(folderId);
        }
        IntegratedEntity projectNewIntegratedEntity = QTestIntegrationProjectManager.getIntegratedEntityByQTestProjects((List)qTestProjects);
        projectEntity = (ProjectEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)projectEntity, (IntegratedEntity)projectNewIntegratedEntity);
        ProjectController.getInstance().updateProject(projectEntity);
    }

    private void saveFolder(FolderEntity folderEntity, IntegratedEntity folderIntegratedEntity) throws Exception {
        folderEntity.getIntegratedEntities().remove(folderIntegratedEntity);
        FolderController.getInstance().saveFolder(folderEntity);
    }
}

