/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;

public class DisintegrateTestSuiteJob
extends QTestJob {
    private List<TestSuiteEntity> fTestSuites;

    public DisintegrateTestSuiteJob(List<TestSuiteEntity> testSuites) {
        super(StringConstants.JOB_TITLE_DISINTEGRATE_TEST_SUITE);
        this.fTestSuites = testSuites;
    }

    /*
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(StringConstants.JOB_TASK_DISINTEGRATE_TEST_SUITE, this.fTestSuites.size());
            for (TestSuiteEntity testSuite : this.fTestSuites) {
                String testSuiteId = null;
                try {
                    testSuiteId = testSuite.getIdForDisplay();
                    List qTestSuites = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity((IntegratedEntity)QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite));
                    for (QTestSuite availableQTestSuite : qTestSuites) {
                        if (availableQTestSuite.getId() <= 0L) continue;
                        availableQTestSuite.setId(0L);
                        availableQTestSuite.setPid("");
                        availableQTestSuite.setSelected(false);
                        availableQTestSuite.getTestRuns().clear();
                    }
                    QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)testSuite, (IntegratedEntity)QTestIntegrationTestSuiteManager.getIntegratedEntityByTestSuiteList((List)qTestSuites));
                    TestSuiteController.getInstance().updateTestSuite(testSuite);
                    this.getEventBroker().post("TESTSUITE/UPDATED", (Object)new Object[]{testSuite.getId(), testSuite});
                    this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)testSuite, (ProjectEntity)this.projectEntity));
                }
                catch (QTestInvalidFormatException e) {
                    MessageDialog.openError(null, (String)StringConstants.WARN, (String)MessageFormat.format(StringConstants.JOB_MSG_TEST_SUITE_INVALID_FORMAT, testSuiteId));
                    IStatus iStatus = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
                    monitor.done();
                    return iStatus;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    IStatus iStatus = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
                    monitor.done();
                    return iStatus;
                }
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }
}

