/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.job;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.SynchronizedConfirmationDialog;
import com.kms.katalon.composer.components.impl.dialogs.YesNoAllOptions;
import com.kms.katalon.composer.components.impl.util.StatusUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.job.DisintegrateTestSuiteJob;
import com.kms.katalon.composer.integration.qtest.job.QTestJob;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.credential.IQTestCredential;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestSuiteParent;
import com.kms.katalon.integration.qtest.model.TestSuiteQTestSuitePair;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingCredential;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;

public class UploadTestSuiteJob
extends QTestJob {
    private List<TestSuiteQTestSuitePair> fUnuploadedPairs;
    private List<TestSuiteQTestSuitePair> fUploadedPairs;
    private IQTestCredential fCredentials;

    public UploadTestSuiteJob(List<TestSuiteQTestSuitePair> pairs) {
        super(StringConstants.JOB_TITLE_UPLOAD_TEST_SUITE);
        this.setUser(true);
        this.fUnuploadedPairs = pairs;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.fCredentials = QTestSettingCredential.getCredential((String)this.getProjectDir());
            this.fUploadedPairs = new ArrayList<TestSuiteQTestSuitePair>();
            int total = this.fUnuploadedPairs.size();
            monitor.beginTask(StringConstants.JOB_TASK_UPLOAD_TEST_SUITE, total);
            for (TestSuiteQTestSuitePair pair : this.fUnuploadedPairs) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = this.canceled();
                    return iStatus;
                }
                IStatus status = this.uploadTestSuite((IProgressMonitor)new SubProgressMonitor(monitor, 1, 4), pair);
                if (status == Status.CANCEL_STATUS) {
                    IStatus iStatus = this.canceled();
                    return iStatus;
                }
                if (status.getSeverity() != 4) continue;
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            IStatus iStatus = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)e);
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IStatus canceled() {
        final int uploadedCount = this.fUploadedPairs.size();
        if (uploadedCount == 0) {
            return Status.CANCEL_STATUS;
        }
        SynchronizedConfirmationDialog dialog = new SynchronizedConfirmationDialog(){

            public void run() {
                boolean confirmed = MessageDialog.open((int)3, null, (String)StringConstants.CONFIRMATION, (String)MessageFormat.format(StringConstants.JOB_MSG_CONFIRM_CANCEL_UPLOAD, uploadedCount), (int)0);
                this.setConfirmedValue(confirmed ? YesNoAllOptions.YES : YesNoAllOptions.NO);
            }
        };
        UISynchronizeService.getInstance().getSync().syncExec((Runnable)dialog);
        if (dialog.getConfirmedValue() == YesNoAllOptions.NO) {
            ArrayList<TestSuiteEntity> testSuiteEntities = new ArrayList<TestSuiteEntity>();
            for (TestSuiteQTestSuitePair pair : this.fUnuploadedPairs) {
                testSuiteEntities.add(pair.getTestSuite());
            }
            DisintegrateTestSuiteJob job = new DisintegrateTestSuiteJob(testSuiteEntities);
            job.schedule();
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus uploadTestSuite(IProgressMonitor monitor, TestSuiteQTestSuitePair pair) {
        TestSuiteEntity testSuite = pair.getTestSuite();
        List unUploadedQTestSuites = pair.getQTestSuites();
        ArrayList<QTestSuite> uploadedQTestSuites = new ArrayList<QTestSuite>();
        try {
            String testSuiteId = testSuite.getIdForDisplay();
            monitor.beginTask(MessageFormat.format(StringConstants.JOB_TASK_UPLOADING_TEST_SUITE_ENTITY, this.getWrappedName(testSuiteId)), unUploadedQTestSuites.size() + 1);
            TestSuiteRepo repo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)testSuite, (ProjectEntity)this.projectEntity);
            List allQTestSuites = QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity((IntegratedEntity)QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)testSuite));
            for (QTestSuite qTestSuite : allQTestSuites) {
                if (this.indexOf(qTestSuite, unUploadedQTestSuites) < 0) continue;
                monitor.subTask(this.getWrappedName(MessageFormat.format(StringConstants.JOB_SUB_TASK_UPLOADING_QTEST_SUITE, qTestSuite.getParent().getTypeName(), qTestSuite.getParent().getName())) + "...");
                QTestSuite newQTestSuite = null;
                QTestSuite duplicatedQTestSuite = QTestIntegrationTestSuiteManager.getDuplicatedTestSuiteOnQTest((IQTestCredential)this.fCredentials, (String)testSuite.getName(), (QTestSuiteParent)qTestSuite.getParent(), (QTestProject)repo.getQTestProject());
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (duplicatedQTestSuite != null) {
                    SynchronizedConfirmationDialog dialog = this.getMergeConfirmedDialog(duplicatedQTestSuite, testSuite);
                    UISynchronizeService.getInstance().getSync().syncExec((Runnable)dialog);
                    if (dialog.getConfirmedValue() == YesNoAllOptions.YES) {
                        newQTestSuite = duplicatedQTestSuite;
                    }
                }
                if (newQTestSuite == null) {
                    newQTestSuite = QTestIntegrationTestSuiteManager.uploadTestSuite((IQTestCredential)this.fCredentials, (String)testSuite.getName(), (String)testSuite.getDescription(), (QTestSuiteParent)qTestSuite.getParent(), (QTestProject)repo.getQTestProject());
                }
                qTestSuite.setId(newQTestSuite.getId());
                qTestSuite.setPid(newQTestSuite.getPid());
                uploadedQTestSuites.add(qTestSuite);
                monitor.worked(1);
            }
            monitor.subTask(StringConstants.JOB_SUB_TASK_UPDATING_TEST_SUITE_ENTITY);
            QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)testSuite, (IntegratedEntity)QTestIntegrationTestSuiteManager.getIntegratedEntityByTestSuiteList((List)allQTestSuites));
            TestSuiteController.getInstance().updateTestSuite(testSuite);
            this.getEventBroker().post("TESTSUITE/UPDATED", (Object)new Object[]{testSuite.getId(), testSuite});
            this.getEventBroker().post("EXPLORER/REFRESH_TREE_ENTITY", (Object)TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)testSuite, (ProjectEntity)this.projectEntity));
            monitor.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OperationCanceledException operationCanceledException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            IStatus iStatus = StatusUtil.getErrorStatus(((Object)((Object)this)).getClass(), (Throwable)ex);
            return iStatus;
        }
        finally {
            if (uploadedQTestSuites.size() > 0) {
                this.fUploadedPairs.add(new TestSuiteQTestSuitePair(testSuite, uploadedQTestSuites));
            }
            monitor.done();
        }
    }

    private IEventBroker getEventBroker() {
        return EventBrokerSingleton.getInstance().getEventBroker();
    }

    private int indexOf(QTestSuite qTestSuite, List<QTestSuite> qTestSuiteCollection) {
        int index = 0;
        while (index < qTestSuiteCollection.size()) {
            if (qTestSuite.getParent().getId() == qTestSuiteCollection.get(index).getParent().getId()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private SynchronizedConfirmationDialog getMergeConfirmedDialog(final QTestSuite qTestSuite, final TestSuiteEntity testSuite) {
        return new SynchronizedConfirmationDialog(){

            public void run() {
                boolean confirmed = MessageDialog.openQuestion(null, (String)StringConstants.DIA_TITLE_TEST_SUITE_DUPLICATION, (String)MessageFormat.format(StringConstants.DIA_MSG_CONFIRM_MERGE_UPLOADED_TEST_SUITE, Long.toString(qTestSuite.getId()), testSuite.getName(), qTestSuite.getParent().getTypeName(), qTestSuite.getParent().getName()));
                if (confirmed) {
                    this.setConfirmedValue(YesNoAllOptions.YES);
                } else {
                    this.setConfirmedValue(YesNoAllOptions.NO);
                }
            }
        };
    }
}

