/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.menu;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.ReportTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.handler.QTestDisintegrateReportHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestDisintegrateTestCaseHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestDisintegrateTestSuiteHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestDownloadTestCaseHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestSettingsHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestUploadReportHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestUploadTestCaseHandler;
import com.kms.katalon.composer.integration.qtest.handler.QTestUploadTestSuiteHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.osgi.framework.FrameworkUtil;

public class QTestContextMenuContribution {
    private static final String CONTRIBUTOR_URI = FrameworkUtil.getBundle(QTestContextMenuContribution.class).getSymbolicName();
    @Inject
    private ESelectionService selectionService;
    @Inject
    private EModelService modelService;

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        try {
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            if (project == null) {
                return;
            }
            if (!QTestSettingStore.isIntegrationActive((String)project.getFolderLocation())) {
                return;
            }
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null || selectedObjects.length != 1) {
                return;
            }
            Object selectedObject = selectedObjects[0];
            MMenu qTestMenu = this.getQTestMenu();
            MDirectMenuItem uploadMenuItem = this.getUploadMenuItem();
            MDirectMenuItem downloadMenuItem = this.getDownloadMenuItem();
            MDirectMenuItem disintegrateMenuItem = this.getDisintegrateMenuItem();
            MDirectMenuItem settingsMenuItem = this.getManageMenuItem();
            if (selectedObject instanceof TestCaseTreeEntity) {
                uploadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestUploadTestCaseHandler.class.getName());
                qTestMenu.getChildren().add(uploadMenuItem);
                disintegrateMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDisintegrateTestCaseHandler.class.getName());
                qTestMenu.getChildren().add(disintegrateMenuItem);
                qTestMenu.getChildren().add(settingsMenuItem);
            } else if (selectedObject instanceof TestSuiteTreeEntity) {
                uploadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestUploadTestSuiteHandler.class.getName());
                qTestMenu.getChildren().add(uploadMenuItem);
                disintegrateMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDisintegrateTestSuiteHandler.class.getName());
                qTestMenu.getChildren().add(disintegrateMenuItem);
                qTestMenu.getChildren().add(settingsMenuItem);
            } else if (selectedObject instanceof ReportTreeEntity) {
                uploadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestUploadReportHandler.class.getName());
                qTestMenu.getChildren().add(uploadMenuItem);
                disintegrateMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDisintegrateReportHandler.class.getName());
                qTestMenu.getChildren().add(disintegrateMenuItem);
                qTestMenu.getChildren().add(settingsMenuItem);
            } else if (selectedObject instanceof FolderTreeEntity && ((FolderTreeEntity)selectedObject).getObject() instanceof FolderEntity) {
                FolderEntity folderEntity = ((FolderTreeEntity)selectedObject).getObject();
                switch (folderEntity.getFolderType()) {
                    case TESTCASE: {
                        uploadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestUploadTestCaseHandler.class.getName());
                        qTestMenu.getChildren().add(uploadMenuItem);
                        downloadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDownloadTestCaseHandler.class.getName());
                        qTestMenu.getChildren().add(downloadMenuItem);
                        disintegrateMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDisintegrateTestCaseHandler.class.getName());
                        qTestMenu.getChildren().add(disintegrateMenuItem);
                        break;
                    }
                    case TESTSUITE: {
                        uploadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestUploadTestSuiteHandler.class.getName());
                        qTestMenu.getChildren().add(uploadMenuItem);
                        disintegrateMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDisintegrateTestSuiteHandler.class.getName());
                        qTestMenu.getChildren().add(disintegrateMenuItem);
                        break;
                    }
                    case REPORT: {
                        uploadMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestUploadReportHandler.class.getName());
                        qTestMenu.getChildren().add(uploadMenuItem);
                        disintegrateMenuItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestDisintegrateReportHandler.class.getName());
                        qTestMenu.getChildren().add(disintegrateMenuItem);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                qTestMenu.getChildren().add(settingsMenuItem);
            }
            if (qTestMenu.getChildren().size() > 0) {
                menuItems.add((MMenuElement)qTestMenu);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private MDirectMenuItem getDisintegrateMenuItem() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.CM_DISINTEGRATE);
        dynamicItem.setContributorURI(FrameworkUtil.getBundle(QTestContextMenuContribution.class).getSymbolicName());
        return dynamicItem;
    }

    private MDirectMenuItem getUploadMenuItem() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.CM_UPLOAD);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getDownloadMenuItem() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.CM_DONWLOAD);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }

    private MDirectMenuItem getManageMenuItem() {
        MDirectMenuItem dynamicItem = (MDirectMenuItem)this.modelService.createModelElement(MDirectMenuItem.class);
        dynamicItem.setLabel(StringConstants.CM_SETTINGS);
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        dynamicItem.setContributionURI("bundleclass://com.kms.katalon.composer.integration.qtest/" + QTestSettingsHandler.class.getName());
        return dynamicItem;
    }

    private MMenu getQTestMenu() {
        MMenu dynamicItem = (MMenu)this.modelService.createModelElement(MMenu.class);
        dynamicItem.setLabel("qTest");
        dynamicItem.setContributorURI(CONTRIBUTOR_URI);
        return dynamicItem;
    }
}

