/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.preference;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.TestSuiteRepoDialog;
import com.kms.katalon.composer.integration.qtest.preference.AbstractQTestIntegrationPage;
import com.kms.katalon.composer.integration.qtest.preference.provider.TestSuiteRepoTableLabelProvider;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationFolderManager;
import com.kms.katalon.integration.qtest.QTestIntegrationProjectManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TestSuiteRepoPreferencePage
extends AbstractQTestIntegrationPage {
    private Composite container;
    private TableViewer tableViewer;
    private ToolItem btnAdd;
    private ToolItem btnEdit;
    private ToolItem btnRemove;
    private List<QTestProject> qTestProjects;
    private List<TestSuiteRepo> testSuiteRepositories;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        Composite compositeToolbar = new Composite(this.container, 0);
        compositeToolbar.setLayout((Layout)new FillLayout(256));
        compositeToolbar.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBar toolbar = new ToolBar(compositeToolbar, 0x820000);
        toolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.btnAdd = new ToolItem(toolbar, 0);
        this.btnAdd.setText(StringConstants.ADD);
        this.btnAdd.setImage(ImageConstants.IMG_16_ADD);
        this.btnEdit = new ToolItem(toolbar, 0);
        this.btnEdit.setText(StringConstants.EDIT);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setImage(ImageConstants.IMG_16_EDIT);
        this.btnRemove = new ToolItem(toolbar, 0);
        this.btnRemove.setText(StringConstants.REMOVE);
        this.btnRemove.setImage(ImageConstants.IMG_16_REMOVE);
        this.btnRemove.setEnabled(false);
        Composite compositeTable = new Composite(this.container, 0);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer = new TableViewer(compositeTable, 67584);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableViewerColumn tableViewerColumnQTestProject = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnQTestProject = tableViewerColumnQTestProject.getColumn();
        tblclmnQTestProject.setText(StringConstants.DIA_TITLE_QTEST_PROJECT);
        TableViewerColumn tableViewerColumnKatalonFolder = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnKatalonFolder = tableViewerColumnKatalonFolder.getColumn();
        tblclmnKatalonFolder.setText(StringConstants.DIA_TITLE_TEST_SUITE_FOLDER);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TestSuiteRepoTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnQTestProject, (ColumnLayoutData)new ColumnWeightData(0, 100));
        tableLayout.setColumnData((Widget)tblclmnKatalonFolder, (ColumnLayoutData)new ColumnWeightData(90, 100));
        compositeTable.setLayout((Layout)tableLayout);
        this.addControlModifySelectionListeners();
        this.initialize();
        return this.container;
    }

    @Override
    protected void initialize() {
        if (this.container == null || this.container.isDisposed()) {
            return;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        IntegratedEntity integratedProjectEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        try {
            this.qTestProjects = integratedProjectEntity != null ? QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)integratedProjectEntity) : new ArrayList<QTestProject>();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
            MessageDialog.openWarning(null, (String)StringConstants.DIA_MSG_UNABLE_GET_PROJECT_INFO, (String)ex.getMessage());
            return;
        }
        this.testSuiteRepositories = QTestIntegrationUtil.getTestSuiteRepositories((ProjectEntity)projectEntity, this.qTestProjects);
        this.tableViewer.setInput(this.testSuiteRepositories);
    }

    private void addControlModifySelectionListeners() {
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteRepoPreferencePage.this.addNewTestSuiteRepo();
            }
        });
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteRepoPreferencePage.this.editTestSuiteRepo();
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteRepoPreferencePage.this.removeTestSuiteRepo();
            }
        });
        this.tableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TestSuiteRepoPreferencePage.this.tableViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    TestSuiteRepoPreferencePage.this.btnEdit.setEnabled(false);
                    TestSuiteRepoPreferencePage.this.btnRemove.setEnabled(false);
                } else {
                    TestSuiteRepoPreferencePage.this.btnEdit.setEnabled(true);
                    TestSuiteRepoPreferencePage.this.btnRemove.setEnabled(true);
                }
            }
        });
    }

    @Focus
    public void focus() {
        this.initialize();
    }

    protected void removeTestSuiteRepo() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        TestSuiteRepo repo = (TestSuiteRepo)selection.getFirstElement();
        this.testSuiteRepositories.remove(repo);
        this.tableViewer.refresh();
    }

    private void insertNewRepoToTable(int index, TestSuiteRepo newRepo) {
        this.testSuiteRepositories.remove(index);
        if (index >= this.testSuiteRepositories.size()) {
            this.testSuiteRepositories.add(newRepo);
        } else {
            this.testSuiteRepositories.add(index, newRepo);
        }
        this.tableViewer.refresh();
    }

    protected void editTestSuiteRepo() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        TestSuiteRepo repo = (TestSuiteRepo)selection.getFirstElement();
        List<String> currentFolderIds = this.getRegisteredFolderIds();
        currentFolderIds.remove(repo.getFolderId());
        TestSuiteRepoDialog dialog = new TestSuiteRepoDialog(this.btnAdd.getDisplay().getActiveShell(), this.qTestProjects, currentFolderIds, repo);
        if (dialog.open() == 0) {
            TestSuiteRepo newRepo = dialog.getTestSuiteRepo();
            int index = this.testSuiteRepositories.indexOf(repo);
            if (!repo.equals((Object)newRepo)) {
                this.insertNewRepoToTable(index, newRepo);
            }
        }
    }

    private List<String> getRegisteredFolderIds() {
        ArrayList<String> currentFolderIds = new ArrayList<String>();
        for (TestSuiteRepo testSuiteRepo : this.testSuiteRepositories) {
            currentFolderIds.add(testSuiteRepo.getFolderId());
        }
        return currentFolderIds;
    }

    protected void addNewTestSuiteRepo() {
        List<String> currentFolderIds = this.getRegisteredFolderIds();
        TestSuiteRepoDialog dialog = new TestSuiteRepoDialog(this.btnAdd.getDisplay().getActiveShell(), this.qTestProjects, currentFolderIds, null);
        if (dialog.open() == 0) {
            TestSuiteRepo repo = dialog.getTestSuiteRepo();
            this.testSuiteRepositories.add(repo);
            this.qTestProjects.clear();
            for (QTestProject qTestProject : dialog.getQTestProjectsMap().values()) {
                if (qTestProject.equals((Object)repo.getQTestProject())) {
                    qTestProject.getTestSuiteFolderIds().add(repo.getFolderId());
                }
                this.qTestProjects.add(qTestProject);
            }
            this.tableViewer.refresh();
        }
    }

    public boolean performOk() {
        if (this.container == null) {
            return true;
        }
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        LinkedHashSet<QTestProject> currentProjects = new LinkedHashSet<QTestProject>();
        IntegratedEntity projectIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)projectEntity);
        if (projectIntegratedEntity != null) {
            currentProjects.addAll(QTestIntegrationProjectManager.getQTestProjectsByIntegratedEntity((IntegratedEntity)projectIntegratedEntity));
        }
        currentProjects.addAll(this.qTestProjects);
        for (QTestProject qTestProject : currentProjects) {
            qTestProject.getTestSuiteFolderIds().clear();
        }
        for (TestSuiteRepo repo : this.testSuiteRepositories) {
            for (QTestProject qTestProject : currentProjects) {
                if (!repo.getQTestProject().equals((Object)qTestProject)) continue;
                qTestProject.getTestSuiteFolderIds().add(repo.getFolderId());
            }
            try {
                FolderEntity folderEntity = FolderController.getInstance().getFolderByDisplayId(projectEntity, repo.getFolderId());
                if (folderEntity == null) continue;
                this.saveFolder(folderEntity, repo.getQTestProject());
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        this.qTestProjects.clear();
        this.qTestProjects.addAll(currentProjects);
        this.saveProject(projectEntity);
        return true;
    }

    private void saveProject(ProjectEntity projectEntity) {
        IntegratedEntity projectNewIntegratedEntity = QTestIntegrationProjectManager.getIntegratedEntityByQTestProjects(this.qTestProjects);
        ProjectEntity currentProject = (ProjectEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)projectEntity, (IntegratedEntity)projectNewIntegratedEntity);
        try {
            ProjectController.getInstance().updateProject(currentProject);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void saveFolder(FolderEntity folderEntity, QTestProject qTestProject) {
        IntegratedEntity folderNewIntegratedEntity = QTestIntegrationFolderManager.getFolderIntegratedEntityByQTestProject((QTestProject)qTestProject);
        folderEntity = (FolderEntity)QTestIntegrationUtil.updateFileIntegratedEntity((IntegratedFileEntity)folderEntity, (IntegratedEntity)folderNewIntegratedEntity);
        try {
            FolderController.getInstance().saveFolder(folderEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void performDefaults() {
        this.initialize();
    }
}

