/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.qtest.view.testsuite;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.PreferenceDialogBuilder;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.integration.qtest.constant.StringConstants;
import com.kms.katalon.composer.integration.qtest.dialog.CreateNewTestSuiteParentDialog;
import com.kms.katalon.composer.integration.qtest.dialog.model.TestSuiteParentCreationOption;
import com.kms.katalon.composer.integration.qtest.job.UploadTestSuiteJob;
import com.kms.katalon.composer.integration.qtest.preference.QTestPreferenceDefaultValueInitializer;
import com.kms.katalon.composer.integration.qtest.view.testsuite.provider.QTestSuiteTableLabelProvider;
import com.kms.katalon.composer.testsuite.parts.integration.AbstractTestSuiteIntegrationView;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.file.IntegratedFileEntity;
import com.kms.katalon.entity.integration.IntegratedEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.QTestIntegrationTestSuiteManager;
import com.kms.katalon.integration.qtest.QTestIntegrationUtil;
import com.kms.katalon.integration.qtest.entity.QTestProject;
import com.kms.katalon.integration.qtest.entity.QTestSuite;
import com.kms.katalon.integration.qtest.entity.QTestSuiteParent;
import com.kms.katalon.integration.qtest.exception.QTestException;
import com.kms.katalon.integration.qtest.exception.QTestInvalidFormatException;
import com.kms.katalon.integration.qtest.model.TestSuiteQTestSuitePair;
import com.kms.katalon.integration.qtest.model.TestSuiteRepo;
import com.kms.katalon.integration.qtest.setting.QTestSettingStore;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class QTestIntegrationTestSuiteView
extends AbstractTestSuiteIntegrationView {
    private StyledText txtID;
    private StyledText txtParentID;
    private StyledText txtPID;
    private List<QTestSuite> qTestSuites;
    private Button btnUpload;
    private Button btnDisintegrate;
    private Button btnNavigate;
    private Button btnUpdateParent;
    private Button btnSetDefault;
    private Composite compositeParent;
    private Composite compositeSelectedParent;
    private TableViewer testSuiteParentTableViewer;
    private TableColumn tblclmnName;
    private TableViewerColumn tableViewerColumnName;
    private TableColumn tblclmnType;
    private TableViewerColumn tableViewerColumnType;
    private TableColumn tblclmnDefault;
    private TableViewerColumn tableViewerColumnDefault;
    private Composite compositeTable;
    private Label lblTableParentLabel;
    private Button btnRemove;

    public QTestIntegrationTestSuiteView(TestSuiteEntity testSuiteEntity, MPart mpart) {
        super(testSuiteEntity, mpart);
    }

    public Composite createContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite compositeButton = new Composite(container, 0);
        GridLayout glCompositeButton = new GridLayout(6, false);
        glCompositeButton.marginHeight = 0;
        glCompositeButton.marginWidth = 0;
        compositeButton.setLayout((Layout)glCompositeButton);
        compositeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.btnUpload = new Button(compositeButton, 0x800000);
        this.btnUpload.setToolTipText(StringConstants.VIEW_TOOLTIP_UPLOAD_TEST_SUITE);
        this.btnUpload.setText(StringConstants.CM_UPLOAD);
        this.btnDisintegrate = new Button(compositeButton, 0x800000);
        this.btnDisintegrate.setToolTipText(StringConstants.VIEW_TOOLTIP_DISINTEGRATE_TEST_SUITE);
        this.btnDisintegrate.setText(StringConstants.CM_DISINTEGRATE);
        this.btnNavigate = new Button(compositeButton, 0x800000);
        this.btnNavigate.setToolTipText(StringConstants.VIEW_TOOLTIP_NAVIGATE_TEST_SUITE);
        this.btnNavigate.setText(StringConstants.CM_NAVIGATE);
        this.btnUpdateParent = new Button(compositeButton, 0x800000);
        this.btnUpdateParent.setToolTipText(StringConstants.VIEW_TOOLTIP_NEW_TEST_SUITE_PARENT);
        this.btnUpdateParent.setText(StringConstants.VIEW_TITLE_NEW_TEST_SUITE_PARENT);
        this.btnSetDefault = new Button(compositeButton, 0x800000);
        this.btnSetDefault.setToolTipText(StringConstants.VIEW_TOOLTIP_SET_DEFAULT_TEST_SUITE);
        this.btnSetDefault.setText(StringConstants.VIEW_TITLE_SET_DEFAULT_TEST_SUITE);
        this.btnRemove = new Button(compositeButton, 0x800000);
        this.btnRemove.setToolTipText(StringConstants.VIEW_TOOLTIP_REMOVE_TEST_SUITE_PARENT);
        this.btnRemove.setText(StringConstants.VIEW_TITLE_REMOVE_TEST_SUITE_PARENT);
        this.btnRemove.setEnabled(false);
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setSashWidth(10);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createTestSuiteParentTreeView((Composite)sashForm);
        this.compositeSelectedParent = new Composite((Composite)sashForm, 0);
        this.compositeSelectedParent.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeSelectedParent = new GridLayout(1, false);
        glCompositeSelectedParent.marginWidth = 0;
        glCompositeSelectedParent.marginHeight = 0;
        this.compositeSelectedParent.setLayout((Layout)glCompositeSelectedParent);
        Composite compositeSelectedParentHeader = new Composite(this.compositeSelectedParent, 0);
        compositeSelectedParentHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeSelectedParentHeader = new GridLayout(1, false);
        glCompositeSelectedParentHeader.marginWidth = 0;
        compositeSelectedParentHeader.setLayout((Layout)glCompositeSelectedParentHeader);
        Label lblSelectedParentHeader = new Label(compositeSelectedParentHeader, 0);
        lblSelectedParentHeader.setFont(JFaceResources.getFontRegistry().getBold(""));
        lblSelectedParentHeader.setText(StringConstants.VIEW_TITLE_INTEGRATION_INFORMATION);
        Composite compositeSelectedParentDetails = new Composite(this.compositeSelectedParent, 2048);
        compositeSelectedParentDetails.setBackground(ColorUtil.getWhiteBackgroundColor());
        compositeSelectedParentDetails.setBackgroundMode(2);
        compositeSelectedParentDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeSelectedParentDetails = new GridLayout(2, false);
        glCompositeSelectedParentDetails.verticalSpacing = 7;
        glCompositeSelectedParentDetails.horizontalSpacing = 15;
        compositeSelectedParentDetails.setLayout((Layout)glCompositeSelectedParentDetails);
        Label lblQTestId = new Label(compositeSelectedParentDetails, 0);
        lblQTestId.setText(StringConstants.VIEW_TITLE_TEST_SUITE_ID);
        this.txtID = new StyledText(compositeSelectedParentDetails, 8);
        this.txtID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblPID = new Label(compositeSelectedParentDetails, 0);
        lblPID.setText(StringConstants.CM_ALIAS);
        this.txtPID = new StyledText(compositeSelectedParentDetails, 8);
        this.txtPID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblParentId = new Label(compositeSelectedParentDetails, 0);
        lblParentId.setText(StringConstants.CM_PARENT_ID);
        this.txtParentID = new StyledText(compositeSelectedParentDetails, 8);
        this.txtParentID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        sashForm.setWeights(new int[]{4, 6});
        this.initialize();
        this.controlModifyListeners();
        return container;
    }

    private void createTestSuiteParentTreeView(Composite compositeInfo) {
        this.compositeParent = new Composite(compositeInfo, 0);
        this.compositeParent.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        GridLayout glCompositeParent = new GridLayout(1, false);
        glCompositeParent.marginWidth = 0;
        glCompositeParent.marginHeight = 0;
        this.compositeParent.setLayout((Layout)glCompositeParent);
        Composite compositeTableHeader = new Composite(this.compositeParent, 0);
        compositeTableHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeTableHeader = new GridLayout(1, false);
        glCompositeTableHeader.marginWidth = 0;
        compositeTableHeader.setLayout((Layout)glCompositeTableHeader);
        this.lblTableParentLabel = new Label(compositeTableHeader, 0);
        this.lblTableParentLabel.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.lblTableParentLabel.setText(StringConstants.VIEW_TITLE_LIST_TEST_SUITE_PARENT);
        this.compositeTable = new Composite(this.compositeParent, 0);
        this.compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.testSuiteParentTableViewer = new TableViewer(this.compositeTable, 67584);
        Table table = this.testSuiteParentTableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        table.setHeaderVisible(true);
        this.tableViewerColumnName = new TableViewerColumn(this.testSuiteParentTableViewer, 0);
        this.tblclmnName = this.tableViewerColumnName.getColumn();
        this.tblclmnName.setText(StringConstants.NAME);
        this.tableViewerColumnType = new TableViewerColumn(this.testSuiteParentTableViewer, 0);
        this.tblclmnType = this.tableViewerColumnType.getColumn();
        this.tblclmnType.setText(StringConstants.CM_TYPE);
        this.tableViewerColumnDefault = new TableViewerColumn(this.testSuiteParentTableViewer, 0);
        this.tblclmnDefault = this.tableViewerColumnDefault.getColumn();
        this.tblclmnDefault.setText(StringConstants.CM_DEFAULT);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)this.tblclmnName, (ColumnLayoutData)new ColumnWeightData(80, 0));
        tableLayout.setColumnData((Widget)this.tblclmnType, (ColumnLayoutData)new ColumnWeightData(0, 100));
        tableLayout.setColumnData((Widget)this.tblclmnDefault, (ColumnLayoutData)new ColumnWeightData(0, 50));
        this.compositeTable.setLayout((Layout)tableLayout);
        this.testSuiteParentTableViewer.setLabelProvider((IBaseLabelProvider)new QTestSuiteTableLabelProvider());
        this.testSuiteParentTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    private void controlModifyListeners() {
        this.btnUpload.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)QTestIntegrationTestSuiteView.this.testSuiteParentTableViewer.getSelection();
                QTestSuite selectedQTestSuite = (QTestSuite)selection.getFirstElement();
                QTestIntegrationTestSuiteView.this.uploadTestSuite(selectedQTestSuite);
            }
        });
        this.btnNavigate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestSuiteView.this.navigateToQTest();
            }
        });
        this.btnDisintegrate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestSuiteView.this.disintegrateTestSuiteWithQTest();
            }
        });
        this.btnUpdateParent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestSuiteView.this.createTestSuiteParent();
            }
        });
        this.btnSetDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)QTestIntegrationTestSuiteView.this.testSuiteParentTableViewer.getSelection();
                QTestSuite selectedQTestSuite = (QTestSuite)selection.getFirstElement();
                QTestIntegrationTestSuiteView.this.setDefaultQTestSuite(selectedQTestSuite);
            }
        });
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QTestIntegrationTestSuiteView.this.removeParentFromParentList();
            }
        });
        this.testSuiteParentTableViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!QTestIntegrationTestSuiteView.this.btnRemove.isEnabled()) {
                    QTestIntegrationTestSuiteView.this.btnRemove.setEnabled(true);
                }
                QTestIntegrationTestSuiteView.this.reloadView();
            }
        });
        this.compositeTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                QTestIntegrationTestSuiteView.this.compositeTable.layout();
            }
        });
    }

    private void removeParentFromParentList() {
        if (!this.isIntegrationActive()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.testSuiteParentTableViewer.getSelection();
        QTestSuite selectedQTestSuite = (QTestSuite)selection.getFirstElement();
        if (selectedQTestSuite.getId() > 0L && !this.disintegrateTestSuiteWithQTest()) {
            return;
        }
        this.getQTestSuites().remove(selectedQTestSuite);
        this.testSuiteParentTableViewer.refresh();
        this.setDirty(true);
    }

    private void setDefaultQTestSuite(QTestSuite selectedQTestSuite) {
        if (!this.isIntegrationActive()) {
            return;
        }
        selectedQTestSuite.setSelected(true);
        for (QTestSuite testSuite : this.getQTestSuites()) {
            if (testSuite.equals(selectedQTestSuite)) continue;
            testSuite.setSelected(false);
        }
        this.testSuiteParentTableViewer.refresh();
        this.reloadView();
        this.setDirty(true);
    }

    private void showTestSuiteNotValidNotification() {
        if (!MessageDialog.openQuestion(null, (String)StringConstants.INFORMATION, (String)StringConstants.VIEW_MSG_TEST_SUITE_NOT_IN_REPO)) {
            return;
        }
        PreferenceDialog dialog = PreferenceDialogBuilder.create().addDialogName(StringConstants.PROJECT_SETTINGS).addSelectedNode(StringConstants.PREF_TEST_SUITE_REPO_PAGE).addSize(new Point(800, 500)).build();
        dialog.open();
    }

    private void createTestSuiteParent() {
        try {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            if (!this.isIntegrationActive()) {
                return;
            }
            ArrayList<String> currentInUseParentStrings = new ArrayList<String>();
            for (QTestSuite qTestSuite : this.getQTestSuites()) {
                currentInUseParentStrings.add(Long.toString(qTestSuite.getParent().getId()));
            }
            TestSuiteRepo repo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)this.testSuiteEntity, (ProjectEntity)currentProject);
            if (repo == null) {
                this.showTestSuiteNotValidNotification();
                return;
            }
            Shell dialogShell = this.testSuiteParentTableViewer.getTable().getDisplay().getActiveShell();
            CreateNewTestSuiteParentDialog dialog = new CreateNewTestSuiteParentDialog(dialogShell, currentInUseParentStrings, repo.getQTestProject());
            if (dialog.open() == 0) {
                QTestSuiteParent qTestSuiteParent = dialog.getNewTestSuiteParent();
                if (qTestSuiteParent == null) {
                    return;
                }
                QTestSuite qTestSuite = new QTestSuite();
                qTestSuite.setParent(qTestSuiteParent);
                qTestSuite.setName(this.testSuiteEntity.getName());
                this.getQTestSuites().add(qTestSuite);
                this.testSuiteParentTableViewer.refresh();
                this.updateIntegratedEntity();
                TestSuiteParentCreationOption creationOption = QTestPreferenceDefaultValueInitializer.getCreationOption();
                switch (creationOption) {
                    case CREATE_ONLY: {
                        break;
                    }
                    case CREATE_AND_UPLOAD: {
                        this.uploadTestSuite(qTestSuite);
                        break;
                    }
                    case CREATE_UPLOAD_AND_SET_AS_DEFAULT: {
                        this.setDefaultQTestSuite(qTestSuite);
                        this.uploadTestSuite(qTestSuite);
                        break;
                    }
                }
                this.testSuiteParentTableViewer.setSelection((ISelection)new StructuredSelection((Object)qTestSuite));
                this.setDirty(true);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private boolean disintegrateTestSuiteWithQTest() {
        try {
            if (this.isIntegrationActive() && MessageDialog.openConfirm(null, (String)StringConstants.CONFIRMATION, (String)StringConstants.VIEW_CONFIRM_DISINTEGRATE_TEST_SUITE)) {
                IStructuredSelection selection = (IStructuredSelection)this.testSuiteParentTableViewer.getSelection();
                QTestSuite selectedQTestSuite = (QTestSuite)selection.getFirstElement();
                this.testSuiteEntity.getIntegratedEntities().remove(QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.testSuiteEntity));
                selectedQTestSuite.setId(0L);
                selectedQTestSuite.setPid("");
                selectedQTestSuite.setSelected(false);
                selectedQTestSuite.getTestRuns().clear();
                this.testSuiteParentTableViewer.update((Object)selectedQTestSuite, null);
                this.reloadView();
                this.setDirty(true);
                return true;
            }
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.VIEW_MSG_UNABLE_DISINTEGRATE_TEST_SUITE, (String)e.getClass().getSimpleName());
        }
        return false;
    }

    private String getProjectDir() {
        ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
        return projectEntity.getFolderLocation();
    }

    private void navigateToQTest() {
        try {
            if (!this.isIntegrationActive()) {
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)this.testSuiteParentTableViewer.getSelection();
            QTestSuite selectedQTestSuite = (QTestSuite)selection.getFirstElement();
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            TestSuiteRepo repo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)this.testSuiteEntity, (ProjectEntity)currentProject);
            if (repo == null) {
                this.showTestSuiteNotValidNotification();
                return;
            }
            URL url = QTestIntegrationTestSuiteManager.navigatedUrlForQTestSuite((String)this.getProjectDir(), (QTestSuite)selectedQTestSuite, (QTestProject)repo.getQTestProject());
            Program.launch((String)url.toString());
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.VIEW_MSG_UNABLE_NAVIGATE_TEST_SUITE, (String)e.getClass().getSimpleName());
        }
    }

    private boolean isIntegrationActive() {
        boolean active = QTestSettingStore.isIntegrationActive((String)this.getProjectDir());
        if (!active) {
            MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)StringConstants.VIEW_MSG_ENABLE_INTEGRATION);
        }
        return active;
    }

    private void uploadTestSuite(QTestSuite selectedQTestSuite) {
        try {
            if (!this.isIntegrationActive()) {
                return;
            }
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            TestSuiteRepo repo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)this.testSuiteEntity, (ProjectEntity)currentProject);
            if (repo == null) {
                this.showTestSuiteNotValidNotification();
                return;
            }
            ArrayList<QTestSuite> uploadedQTestSuites = new ArrayList<QTestSuite>();
            uploadedQTestSuites.add(selectedQTestSuite);
            TestSuiteQTestSuitePair pair = new TestSuiteQTestSuitePair(this.testSuiteEntity, uploadedQTestSuites);
            ArrayList<TestSuiteQTestSuitePair> pairs = new ArrayList<TestSuiteQTestSuitePair>();
            pairs.add(pair);
            UploadTestSuiteJob job = new UploadTestSuiteJob(pairs);
            job.doTask();
        }
        catch (QTestException ex) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)ex, (String)StringConstants.VIEW_MSG_UNABLE_UPLOAD_TEST_SUITE, (String)((Object)((Object)ex)).getClass().getSimpleName());
            LoggerSingleton.logError((Throwable)ex);
        }
        catch (Exception ex) {
            MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)StringConstants.VIEW_MSG_UNABLE_UPLOAD_TEST_SUITE);
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void initialize() {
        try {
            IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.testSuiteEntity);
            this.setQTestSuites(QTestIntegrationTestSuiteManager.getQTestSuiteListByIntegratedEntity((IntegratedEntity)testSuiteIntegratedEntity));
            this.testSuiteParentTableViewer.setInput(this.getQTestSuites());
        }
        catch (QTestInvalidFormatException qTestInvalidFormatException) {}
        this.reloadView();
    }

    public void setDirty(boolean dirty) {
        this.updateIntegratedEntity();
        super.setDirty(dirty);
    }

    private void updateIntegratedEntity() {
        IntegratedEntity testSuiteIntegratedEntity = QTestIntegrationUtil.getIntegratedEntity((IntegratedFileEntity)this.testSuiteEntity);
        if (testSuiteIntegratedEntity == null) {
            testSuiteIntegratedEntity = QTestIntegrationTestSuiteManager.getIntegratedEntityByTestSuiteList(this.getQTestSuites());
            this.testSuiteEntity.getIntegratedEntities().add(testSuiteIntegratedEntity);
        } else {
            testSuiteIntegratedEntity.getProperties().clear();
            for (QTestSuite qTestSuite : this.getQTestSuites()) {
                QTestIntegrationTestSuiteManager.addQTestSuiteToIntegratedEntity((QTestSuite)qTestSuite, (IntegratedEntity)testSuiteIntegratedEntity, (int)this.getQTestSuites().indexOf(qTestSuite));
            }
        }
    }

    private void reloadView() {
        if (!QTestSettingStore.isIntegrationActive((String)this.testSuiteEntity.getProject().getFolderLocation())) {
            this.btnUpload.setEnabled(false);
            this.btnDisintegrate.setEnabled(false);
            this.btnNavigate.setEnabled(false);
            this.btnSetDefault.setEnabled(false);
            this.btnUpdateParent.setEnabled(false);
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.testSuiteParentTableViewer.getSelection();
        QTestSuite qTestSuite = (QTestSuite)selection.getFirstElement();
        if (qTestSuite == null) {
            this.btnUpload.setEnabled(false);
            this.btnDisintegrate.setEnabled(false);
            this.btnNavigate.setEnabled(false);
            this.btnSetDefault.setEnabled(false);
        } else if (qTestSuite.getId() > 0L) {
            this.btnUpload.setEnabled(false);
            this.btnDisintegrate.setEnabled(true);
            this.btnNavigate.setEnabled(true);
            if (qTestSuite.isSelected()) {
                this.btnSetDefault.setEnabled(false);
            } else {
                this.btnSetDefault.setEnabled(true);
            }
        } else {
            try {
                ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
                TestSuiteRepo testSuiteRepo = QTestIntegrationUtil.getTestSuiteRepo((IntegratedFileEntity)this.testSuiteEntity, (ProjectEntity)currentProject);
                this.btnUpload.setEnabled(testSuiteRepo != null);
                this.btnDisintegrate.setEnabled(false);
                this.btnNavigate.setEnabled(false);
                this.btnSetDefault.setEnabled(false);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        if (qTestSuite != null && qTestSuite.getId() > 0L) {
            this.txtID.setText(String.valueOf(qTestSuite.getId()));
            this.txtParentID.setText(String.valueOf(qTestSuite.getParent().getId()));
            this.txtPID.setText(qTestSuite.getPid());
        } else {
            this.txtID.setText("");
            this.txtParentID.setText("");
            this.txtPID.setText("");
        }
    }

    private List<QTestSuite> getQTestSuites() {
        if (this.qTestSuites == null) {
            this.qTestSuites = new ArrayList<QTestSuite>();
        }
        return this.qTestSuites;
    }

    private void setQTestSuites(List<QTestSuite> qTestSuites) {
        this.qTestSuites = qTestSuites;
    }
}

