/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.parser;

import com.kms.katalon.custom.improvement.factory.CustomKeywordClassFactory;
import com.kms.katalon.custom.improvement.factory.NewPluginTestListenerFactory;
import com.kms.katalon.custom.improvement.model.CustomKeywordClass;
import com.kms.katalon.custom.improvement.model.CustomKeywordFile;
import com.kms.katalon.custom.improvement.parser.ParseKeywordException;
import com.kms.katalon.custom.improvement.parser.ProjectCustomKeywordsParser;
import com.kms.katalon.custom.improvement.plugin.parser.CustomKeywordPluginsParser;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.util.ExecutionTimeTracker;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;

public class ImprovedCustomKeywordParser {
    private static final String CUSTOM_KEYWORDS_FILE_NAME = "CustomKeywords.groovy";
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.custom.improvement.template.CustomKeywordTemplate";
    private static final String GENERATED_KEYWORD_METHOD_NAME = "generateCustomKeywordFile";
    private static ImprovedCustomKeywordParser instance;
    private List<MethodNode> methodNodes = new ArrayList<MethodNode>();

    private ImprovedCustomKeywordParser() {
    }

    public static ImprovedCustomKeywordParser getInstance() {
        if (instance == null) {
            instance = new ImprovedCustomKeywordParser();
        }
        return instance;
    }

    public void parseCustomKeywords(ProjectEntity project, List<File> pluginFiles, boolean isReload) throws ParseKeywordException {
        try {
            CustomKeywordClassFactory.getInstance().reset();
            this.parseProjectCustomKeywords(project);
            this.parsePluginCustomKeywords(project, pluginFiles);
            if (isReload) {
                this.generateCustomKeywordLibFileAndReload(project);
            } else {
                this.generateCustomKeywordLibFile(project);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | CoreException e) {
            throw new ParseKeywordException(e);
        }
    }

    public void parseCustomPlugins(ProjectEntity project, List<File> pluginFiles) throws Exception {
        try {
            this.parsePluginCustom(project, pluginFiles);
        }
        catch (Exception e) {
            throw new ParseKeywordException(e);
        }
    }

    public void parseCustomKeywordFile(File file, ProjectEntity project) throws ParseKeywordException {
        try {
            CustomKeywordFile keywordFile = CustomKeywordFile.from(project, file);
            if (!keywordFile.exists()) {
                return;
            }
            ProjectCustomKeywordsParser parser = new ProjectCustomKeywordsParser(project);
            ProjectCustomKeywordsParser.ParseResult result = parser.parseKeywordFile(keywordFile);
            List<CustomKeywordClass> keywordClasses = result.getKeywordClassesByFile(keywordFile);
            CustomKeywordClassFactory.getInstance().addProjectKeywordClasses(keywordFile, keywordClasses);
            this.generateCustomKeywordLibFileAndReload(project);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | CoreException e) {
            throw new ParseKeywordException(e);
        }
    }

    public void parseCustomKeywordFiles(List<File> files, ProjectEntity project) throws ParseKeywordException {
        try {
            ProjectCustomKeywordsParser parser = new ProjectCustomKeywordsParser(project);
            for (File file : files) {
                CustomKeywordFile keywordFile = CustomKeywordFile.from(project, file);
                if (!keywordFile.exists()) continue;
                ProjectCustomKeywordsParser.ParseResult parseResult = parser.parseKeywordFile(keywordFile);
                List<CustomKeywordClass> keywordClasses = parseResult.getKeywordClassesByFile(keywordFile);
                CustomKeywordClassFactory.getInstance().addProjectKeywordClasses(keywordFile, keywordClasses);
            }
            this.generateCustomKeywordLibFileAndReload(project);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | CoreException e) {
            throw new ParseKeywordException(e);
        }
    }

    public void removeKeywordClassesByKeywordFile(File file, ProjectEntity project) throws ParseKeywordException {
        try {
            CustomKeywordFile keywordFile = CustomKeywordFile.from(project, file);
            CustomKeywordClassFactory.getInstance().removeKeywordClassesByFile(keywordFile);
            this.generateCustomKeywordLibFileAndReload(project);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | CoreException e) {
            throw new ParseKeywordException(e);
        }
    }

    private void parseProjectCustomKeywords(ProjectEntity project) throws ParseKeywordException {
        ProjectCustomKeywordsParser parser = new ProjectCustomKeywordsParser(project);
        ProjectCustomKeywordsParser.ParseResult result = parser.parseAllKeywordFilesInProject();
        for (CustomKeywordFile keywordFile : result.getKeywordFiles()) {
            List<CustomKeywordClass> keywordClasses = result.getKeywordClassesByFile(keywordFile);
            CustomKeywordClassFactory.getInstance().addProjectKeywordClasses(keywordFile, keywordClasses);
        }
    }

    private void parsePluginCustomKeywords(ProjectEntity project, List<File> pluginFiles) throws IOException {
        CustomKeywordPluginsParser parser = new CustomKeywordPluginsParser(project);
        CustomKeywordPluginsParser.ParseResult result = parser.parsePluginFiles(pluginFiles);
        for (File file : result.getPluginFiles()) {
            List<CustomKeywordClass> keywordClasses = result.getKeywordClassesByFile(file);
            CustomKeywordClassFactory.getInstance().addPluginKeywordClasses(file, keywordClasses);
        }
        for (File file : result.getPluginFiles()) {
            List<String> testListeners = result.getTestListenersByFile(file);
            for (String testListener : testListeners) {
                NewPluginTestListenerFactory.getInstance().addListener(testListener);
            }
        }
    }

    private void parsePluginCustom(ProjectEntity project, List<File> pluginFiles) throws IOException {
        CustomKeywordPluginsParser parser = new CustomKeywordPluginsParser(project);
        CustomKeywordPluginsParser.ParseResult result = parser.parsePluginFiles(pluginFiles);
        for (File file : result.getPluginFiles()) {
            List<String> testListeners = result.getTestListenersByFile(file);
            for (String testListener : testListeners) {
                NewPluginTestListenerFactory.getInstance().addListener(testListener);
            }
        }
    }

    private void generateCustomKeywordLibFileAndReload(ProjectEntity project) throws InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, CoreException {
        this.generateCustomKeywordLibFile(project);
        this.loadAllCustomKeywordProxyMethods(GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project));
    }

    private void generateCustomKeywordLibFile(ProjectEntity project) throws InterruptedException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, CoreException {
        File file;
        IFolder libFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
        File libFolderRaw = new File(libFolder.getRawLocation().toString());
        if (!libFolderRaw.exists()) {
            libFolderRaw.mkdirs();
        }
        if (!(file = new File(libFolderRaw, CUSTOM_KEYWORDS_FILE_NAME)).exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        Class<?> clazz = Class.forName(TEMPLATE_CLASS_NAME);
        GroovyObject object = (GroovyObject)clazz.newInstance();
        object.invokeMethod(GENERATED_KEYWORD_METHOD_NAME, (Object)new Object[]{file});
    }

    private synchronized void loadAllCustomKeywordProxyMethods(IFolder libFolder) {
        ClassNode classNode;
        String taskName = String.format("Load custom keywords (%s)", System.currentTimeMillis());
        ExecutionTimeTracker.getInstance().start(taskName);
        IFile iFile = libFolder.getFile(CUSTOM_KEYWORDS_FILE_NAME);
        GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.createCompilationUnitFrom((IFile)iFile);
        ModuleNode moduleNode = unit.getModuleNode();
        ExecutionTimeTracker.getInstance().stop(taskName);
        if (moduleNode != null && (classNode = (ClassNode)moduleNode.getClasses().get(0)) != null && classNode.getModule() != null && classNode.getModule().getMethods() != null) {
            this.methodNodes = new ArrayList<MethodNode>(classNode.getModule().getMethods());
            Collections.sort(this.methodNodes, new Comparator<MethodNode>(){

                @Override
                public int compare(MethodNode methodA, MethodNode methodB) {
                    return methodA.getName().compareToIgnoreCase(methodB.getName());
                }
            });
        }
    }

    public List<MethodNode> getAllMethodNodes(IFolder libFolder) {
        if (this.methodNodes == null || this.methodNodes.isEmpty()) {
            this.loadAllCustomKeywordProxyMethods(libFolder);
        }
        return this.methodNodes;
    }
}

