/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure.dto;

import com.katalon.recorder.web.constant.EngineCommand;
import com.katalon.recorder.web.infrastructure.dto.IEngineMessage;

public class TakeScreenshotObjectMessage
implements IEngineMessage {
    private String capturedObjectId;
    private String name;
    private String path;
    private String locator;

    public TakeScreenshotObjectMessage(String capturedObjectId, String name, String path, String locator) {
        this.capturedObjectId = capturedObjectId;
        this.name = name;
        this.path = path;
        this.locator = locator;
    }

    @Override
    public EngineCommand getCommand() {
        return EngineCommand.TAKE_SCREENSHOT_OBJECT;
    }

    @Override
    public TakeScreenshotObjectMessageData getData() {
        return new TakeScreenshotObjectMessageData(this.capturedObjectId, this.name, this.path, this.locator);
    }

    public static class TakeScreenshotObjectMessageData {
        private final String capturedObjectId;
        private final String name;
        private final String path;
        private final String locator;

        public TakeScreenshotObjectMessageData(String capturedObjectId, String name, String path, String locator) {
            this.capturedObjectId = capturedObjectId;
            this.name = name;
            this.path = path;
            this.locator = locator;
        }

        public String getCapturedObjectId() {
            return this.capturedObjectId;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getLocator() {
            return this.locator;
        }
    }
}

