/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.handlers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.integration.testcloud.interfaces.ITestCloudConfigurationDialog;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.json.adapters.LocalDateTimeAdapter;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionMode;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import jakarta.inject.Inject;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class TestCloudExecutionHandler
extends AbstractExecutionHandler {
    @Inject
    private ITestCloudConfigurationDialog testCloudConfigurationDialog;
    @Inject
    private ITestCloudController testCloudController;

    protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException, ExecutionException, InterruptedException {
        int returnValue = -1;
        try {
            Entity executionTarget = AbstractExecutionHandler.getExecutionTarget();
            this.testCloudConfigurationDialog.reset();
            this.testCloudConfigurationDialog.setExecutionTarget(executionTarget);
            returnValue = this.testCloudConfigurationDialog.open();
        }
        catch (DALException e) {
            LoggerSingleton.logError((Throwable)e);
            return null;
        }
        if (returnValue == 0) {
            TestCloudEntity entity = this.testCloudConfigurationDialog.getSelectingEntity();
            TestCloudSessionType sessionType = this.testCloudConfigurationDialog.getSelectingSessionType();
            TestCloudRunConfiguration testCloudRunConfiguration = null;
            try {
                testCloudRunConfiguration = (TestCloudRunConfiguration)this.testCloudController.buildRunConfiguration(entity, sessionType, TestCloudExecutionMode.QUEUE);
                TestCloudApplication testCloudApplication = this.testCloudConfigurationDialog.getSelectingMobileApplication();
                if (Objects.nonNull(testCloudApplication)) {
                    RemoteWebDriverConnector remoteDriverConnector = testCloudRunConfiguration.getRemoteDriverConnector();
                    Map desiredCapabilities = remoteDriverConnector.getUserConfigProperties();
                    Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
                    desiredCapabilities.put("testCloudOverrideMobileApplication", gson.toJson((Object)testCloudApplication));
                }
            }
            catch (TestCloudException e) {
                LoggerSingleton.logError((Throwable)e);
            }
            return testCloudRunConfiguration;
        }
        return null;
    }
}

