/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.EInput;
import com.kms.katalon.core.webui.common.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.openqa.selenium.Keys;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class ECombobox
extends EInput {
    protected Select selectEle;

    public ECombobox(WebDriver driver, WebElement selElement) {
        super(driver, selElement);
        if (this.element != null) {
            this.selectEle = new Select(this.element);
        }
    }

    @Override
    public Result isExist() {
        try {
            this.refreshWebElement();
            if (this.selectEle == null && this.element != null) {
                this.selectEle = new Select(this.element);
            }
            if (this.selectEle != null) {
                return this.reportHappyCase(true);
            }
            return this.reportUnhappyCase(false, false, "INT071", new Object[0]);
        }
        catch (Exception exception) {
            return this.reportUnhappyCase(false, true, "INT071", new Object[0]);
        }
    }

    @Override
    public void getElementValue() throws Exception {
        WebElement curElement;
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true) && (curElement = this.selectEle.getFirstSelectedOption()) != null) {
            this.value = curElement.getText();
        }
    }

    public Result isItemExist(String[] input) {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                List<String> options = this.getListOptionText();
                int flag = 0;
                String[] stringArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (options.indexOf(item) > -1) {
                        ++flag;
                    }
                    ++n2;
                }
                if (flag == input.length) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT072", new Object[0]);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(false, true, "INT073", e.getMessage());
            }
        }
        return Result.reportUnHappyCaseWithMessage(false, checkExist.needReNewDriver(), checkExist.getMessage());
    }

    private Result isEmpty() {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                if (this.countOptions() == 0) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT074", new Object[0]);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(false, true, "INT075", e.getMessage());
            }
        }
        return Result.reportUnHappyCaseWithMessage(false, checkExist.needReNewDriver(), checkExist.getMessage());
    }

    public Result isNumberOfItemsEqual(int input) {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                int totalItems = this.countOptions();
                if (totalItems == input) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT076", input, totalItems);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(false, true, "INT077", e.getMessage());
            }
        }
        return this.reportUnhappyCase(false, checkExist.needReNewDriver(), "INT078", checkExist.getMessage());
    }

    public Result isItemSelected(String[] input) {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                List selectOptions = this.selectEle.getAllSelectedOptions();
                int flag = 0;
                ArrayList<String> allSelectedOptions = new ArrayList<String>();
                for (WebElement selectedOption : selectOptions) {
                    allSelectedOptions.add(selectedOption.getText());
                }
                String[] stringArray = input;
                int n = input.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    for (String child : allSelectedOptions) {
                        if (!child.equals(item)) continue;
                        ++flag;
                        break;
                    }
                    ++n2;
                }
                if (flag == input.length) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT079", new Object[0]);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(false, true, "INT080" + e.getMessage(), new Object[0]);
            }
        }
        return this.reportUnhappyCase(false, checkExist.needReNewDriver(), "INT081", checkExist.getMessage());
    }

    public Result selectItems(String[] input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            String[] stringArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                boolean isScuceed = false;
                try {
                    isScuceed = this.selectItemByIndex(item);
                    this.element.sendKeys(new CharSequence[]{Keys.RETURN});
                }
                catch (StaleElementReferenceException e) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    try {
                        isScuceed = this.selectItemByIndex(item);
                    }
                    catch (StaleElementReferenceException staleElementReferenceException) {
                        return this.reportUnhappyCase(null, false, "INT089", item, e.getMessage());
                    }
                }
                if (!isScuceed) {
                    return this.reportUnhappyCase(null, false, "INT090", item);
                }
                ++n2;
            }
            return this.reportHappyCase(input);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT091", checkEnable.getMessage());
    }

    public Result selectItem(String input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            boolean isSucceed = false;
            try {
                isSucceed = this.selectItemByIndex(input);
                this.element.sendKeys(new CharSequence[]{Keys.RETURN});
            }
            catch (StaleElementReferenceException e) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                try {
                    isSucceed = this.selectItemByIndex(input);
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return this.reportUnhappyCase(null, false, "INT092", input, e.getMessage());
                }
            }
            if (isSucceed) {
                return this.reportHappyCase(input);
            }
            return this.reportUnhappyCase(null, false, "INT093", input);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT094", checkEnable.getMessage());
    }

    public Result selectItemsByVisibleText(String[] input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            this.isExist();
            this.selectEle = new Select(this.element);
            this.element.sendKeys(new CharSequence[]{Keys.RETURN});
            String[] stringArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                try {
                    this.selectEle.selectByVisibleText(item);
                    this.element.sendKeys(new CharSequence[]{Keys.RETURN});
                }
                catch (StaleElementReferenceException staleElementReferenceException) {
                    return this.reportUnhappyCase(null, false, "INT090", item);
                }
                ++n2;
            }
            return this.reportHappyCase(input);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT091", checkEnable.getMessage());
    }

    private boolean selectItemByIndex(String item) {
        this.isExist();
        this.selectEle = new Select(this.element);
        this.element.sendKeys(new CharSequence[]{Keys.RETURN});
        int i = 0;
        while (i < this.selectEle.getOptions().size()) {
            if (((WebElement)this.selectEle.getOptions().get(i)).getText().matches(item)) {
                this.selectEle.selectByIndex(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public Result selectItemsByIndex(Integer[] input) {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            List allOptions = this.selectEle.getOptions();
            ArrayList<String> selectedItems = new ArrayList<String>();
            Integer[] integerArray = input;
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                int item = integerArray[n2];
                try {
                    this.selectEle.selectByIndex(item);
                    selectedItems.add(((WebElement)allOptions.get(item)).getText());
                }
                catch (Exception e) {
                    return this.reportUnhappyCase(null, true, "INT095", item, e.getMessage());
                }
                ++n2;
            }
            return this.reportHappyCase(selectedItems.toArray(new String[0]));
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT096", checkEnable.getMessage());
    }

    public Result selectFirst() {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            Result checkEmpty = this.isEmpty();
            if (checkEmpty.getMessage() != null) {
                Result returnValue = this.selectItemsByIndex(new Integer[]{1});
                if (returnValue.getMessage() == null) {
                    String firstItem = ((String[])returnValue.getReturnValue())[0];
                    return this.reportHappyCase(firstItem);
                }
                return this.reportUnhappyCase(null, false, "INT097", returnValue.getMessage());
            }
            return this.reportUnhappyCase(null, checkEmpty.needReNewDriver(), "INT098", checkEmpty.getMessage());
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT099", checkEnable.getMessage());
    }

    public Result selectLast() {
        Result checkEnable = this.isEnable();
        int last = -1;
        if (checkEnable.getReturnValue().equals(true)) {
            try {
                last = this.countOptions();
            }
            catch (Exception e) {
                return this.reportUnhappyCase(null, true, "INT100", e.getMessage());
            }
            if (last > 0) {
                Result returnValue = this.selectItemsByIndex(new Integer[]{last});
                if (returnValue.getMessage() == null) {
                    String lastItem = ((String[])returnValue.getReturnValue())[0];
                    return this.reportHappyCase(lastItem);
                }
                return this.reportUnhappyCase(null, returnValue.needReNewDriver(), "INT101", returnValue.getMessage());
            }
            return this.reportUnhappyCase(null, false, "INT102", new Object[0]);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT103", checkEnable.getMessage());
    }

    public Result selectRandom() {
        Result checkEnable = this.isEnable();
        if (checkEnable.getReturnValue().equals(true)) {
            int count;
            try {
                count = this.countOptions();
            }
            catch (Exception e) {
                return this.reportUnhappyCase(null, false, "INT104", e.getMessage());
            }
            if (count > 0) {
                int idx;
                if (count > 1) {
                    Random ran = new Random();
                    idx = ran.nextInt(count - 1) + 1;
                } else {
                    idx = 1;
                }
                Result returnValue = this.selectItemsByIndex(new Integer[]{idx});
                if (returnValue.getMessage() == null) {
                    String selectedItem = ((String[])returnValue.getReturnValue())[0];
                    return this.reportHappyCase(selectedItem);
                }
                return this.reportUnhappyCase(null, returnValue.needReNewDriver(), "INT106", returnValue.getMessage());
            }
            return this.reportUnhappyCase(null, false, "INT106", new Object[0]);
        }
        return this.reportUnhappyCase(null, checkEnable.needReNewDriver(), "INT107", checkEnable.getMessage());
    }

    public Result isListBox() {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            if (this.selectEle.isMultiple()) {
                return this.reportHappyCase(true);
            }
            return this.reportUnhappyCase(false, false, "INT108", new Object[0]);
        }
        return this.reportUnhappyCase(false, checkExist.needReNewDriver(), "INT109", checkExist.getMessage());
    }

    public List<String> getListOptionText() throws Exception {
        if (this.isExist().getReturnValue().equals(true)) {
            ArrayList<String> lstText = new ArrayList<String>();
            List elements = this.selectEle.getOptions();
            for (WebElement child : elements) {
                lstText.add(child.getText());
            }
            return lstText;
        }
        return null;
    }

    public int countOptions() throws Exception {
        if (this.isExist().getReturnValue().equals(true)) {
            List elements = this.selectEle.getOptions();
            return elements.size();
        }
        return 0;
    }

    public List<String> getSelectedOptionText() throws Exception {
        if (this.isExist().getReturnValue().equals(true)) {
            ArrayList<String> lstText = new ArrayList<String>();
            List elements = this.selectEle.getOptions();
            for (WebElement child : elements) {
                if (!child.isSelected()) continue;
                lstText.add(child.getText());
            }
            return lstText;
        }
        return Collections.emptyList();
    }

    public List<Integer> getSelectedOptionIndexes() throws Exception {
        if (this.isExist().getReturnValue().equals(true)) {
            ArrayList<Integer> lstIndexes = new ArrayList<Integer>();
            List elements = this.selectEle.getOptions();
            int i = 0;
            while (i < elements.size()) {
                if (((WebElement)elements.get(i)).isSelected()) {
                    lstIndexes.add(i);
                }
                ++i;
            }
            return lstIndexes;
        }
        return Collections.emptyList();
    }
}

