/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common.controller;

import com.kms.katalon.core.webui.common.controller.ElementWaitingPhase;
import com.kms.katalon.core.webui.model.ElementWaitingInteractableState;
import java.util.LinkedHashMap;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;

public class WaitForPageRerender
extends ElementWaitingPhase {
    public WaitForPageRerender(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        return "const notifyWaitingResult = arguments[arguments.length - 1];\nconst timeout = arguments[0];\n\nconst ElementWaitingInteractableState = {\n    DONE: 'DONE',\n    ELEMENT_DETACHED: 'ELEMENT_DETACHED',\n    TIMED_OUT: 'TIMED_OUT',\n    ERROR: 'ERROR',\n};\n\nfunction notifyWaitingError(error) {\n    notifyWaitingResult({ result: ElementWaitingInteractableState.ERROR, error: error.message });\n}\n\n// Wait for detached\nwaitWithDOMMutation(() => {\n    return true;\n}, timeout).then((isDetached) => {\n    notifyWaitingResult({ result: isDetached\n        ? ElementWaitingInteractableState.DONE\n        : ElementWaitingInteractableState.TIMED_OUT });\n}).catch(notifyWaitingError);\n";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(long timeoutInMillis) {
        if (timeoutInMillis <= 0L) {
            throw new IllegalArgumentException("Timeout must be greater than 0 milliseconds.");
        }
        if (this.executor == null) {
            throw new IllegalStateException("JavascriptExecutor is not found.");
        }
        String runningScript = this.getWaitingScript();
        try {
            LinkedHashMap resultMap;
            Object result = this.executor.executeAsyncScript(runningScript, new Object[]{timeoutInMillis});
            if (result instanceof LinkedHashMap && (resultMap = (LinkedHashMap)result).containsKey("result")) {
                switch (ElementWaitingInteractableState.valueOf(resultMap.get("result").toString())) {
                    case DONE: {
                        return true;
                    }
                    case TIMED_OUT: {
                        throw new IllegalStateException("Waiting for page rerender timed out");
                    }
                    case ERROR: {
                        throw new IllegalStateException("Error during waiting for page rerender: " + String.valueOf(resultMap.get("error")));
                    }
                }
                return false;
            }
            return false;
        }
        catch (JavascriptException e) {
            throw new IllegalStateException("Error executing waiting script: " + e.getMessage(), e);
        }
    }
}

