/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.console.entity;

import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.console.entity.BooleanConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.OverridingParametersConsoleOptionContributor;
import com.kms.katalon.execution.console.entity.ReportableLauncherOptionParser;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.console.entity.TagsLauncherOptionParserDescription;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import com.kms.katalon.execution.launcher.ConsoleLauncher;
import com.kms.katalon.execution.launcher.IConsoleLauncher;
import com.kms.katalon.execution.launcher.LauncherProviderFactory;
import com.kms.katalon.execution.launcher.ReportableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.license.ConsoleLicenseService;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TestSuiteLauncherOptionParser
extends ReportableLauncherOptionParser {
    protected static final String EXECUTION_PROFILE_OPTION = "executionProfile";
    private static final String DEFAULT_FAILED_TEST_VALUE = "0";
    private List<ConsoleOption<?>> overridingOptions = new ArrayList();
    protected StringConsoleOption testSuitePathOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testSuitePath";
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    };
    protected StringConsoleOption browserTypeOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "browserType";
        }

        @Override
        public boolean isRequired() {
            return true;
        }
    };
    protected StringConsoleOption executionProfileOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return TestSuiteLauncherOptionParser.EXECUTION_PROFILE_OPTION;
        }

        @Override
        public boolean isRequired() {
            return false;
        }

        @Override
        public String getDefaultArgumentValue() {
            return "default";
        }
    };
    private StringConsoleOption katalonKatOneServerUrlOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "serverUrl";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonKatOneServerUrlSecondOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "serverURL";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonApiKeyOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "apiKey";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonStoreApiKeySecondOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "apikey";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonOrganizationIdOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "orgId";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonStoreOrganizationIdSecondOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "orgID";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonApiKeyOnPremiseOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "apiKeyOnPremise";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonApiKeyOnPremiseSecondOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "apiKeyOP";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonAnalyticsLicenseFile = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "license";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption installPluginOption = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "installPlugin";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    private StringConsoleOption katalonAnalyticsProjectId = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "analyticsProjectId";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption testSuiteQuery = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testSuiteQuery";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected BooleanConsoleOption katalonLicenseRelease = new BooleanConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRelease";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption maxFailedTest = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "maxFailedTests";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption testCaseTags = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "testCaseTags";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption enableLicenseRetry = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "enableLicenseRetry";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption licenseRetryMaxDuration = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRetryMaxDuration";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption licenseRetryInterval = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRetryInterval";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };
    protected StringConsoleOption licenseRetryMaxJitter = new StringConsoleOption(){

        @Override
        public String getOption() {
            return "licenseRetryMaxJitter";
        }

        @Override
        public boolean isRequired() {
            return false;
        }
    };

    @Override
    public List<ConsoleOption<?>> getConsoleOptionList() {
        List<ConsoleOption<?>> allOptions = super.getConsoleOptionList();
        allOptions.add(this.katalonKatOneServerUrlOption);
        allOptions.add(this.katalonKatOneServerUrlSecondOption);
        allOptions.add(this.testSuitePathOption);
        allOptions.add(this.browserTypeOption);
        allOptions.add(this.executionProfileOption);
        allOptions.add(this.katalonApiKeyOption);
        allOptions.add(this.katalonStoreApiKeySecondOption);
        allOptions.add(this.katalonOrganizationIdOption);
        allOptions.add(this.katalonStoreOrganizationIdSecondOption);
        allOptions.add(this.katalonApiKeyOnPremiseOption);
        allOptions.add(this.katalonApiKeyOnPremiseSecondOption);
        allOptions.add(this.katalonAnalyticsLicenseFile);
        allOptions.add(this.installPluginOption);
        allOptions.add(this.katalonAnalyticsProjectId);
        allOptions.add(this.testSuiteQuery);
        allOptions.add(this.katalonLicenseRelease);
        allOptions.add(this.maxFailedTest);
        allOptions.add(this.testCaseTags);
        allOptions.add(this.enableLicenseRetry);
        allOptions.add(this.licenseRetryMaxDuration);
        allOptions.add(this.licenseRetryInterval);
        allOptions.add(this.licenseRetryMaxJitter);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null && this.overridingOptions.isEmpty()) {
            this.overridingOptions = new OverridingParametersConsoleOptionContributor(currentProject).getConsoleOptionList();
        }
        allOptions.addAll(this.overridingOptions);
        return allOptions;
    }

    @Override
    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        super.setArgumentValue(consoleOption, argumentValue);
        if (consoleOption == this.testSuiteQuery) {
            consoleOption.setValue(argumentValue);
        } else if (consoleOption == this.testSuitePathOption || consoleOption == this.browserTypeOption || consoleOption == this.executionProfileOption || consoleOption == this.installPluginOption || consoleOption == this.testCaseTags || this.overridingOptions.contains(consoleOption)) {
            consoleOption.setValue(argumentValue);
        } else if (consoleOption == this.maxFailedTest) {
            try {
                argumentValue = argumentValue.replaceAll("'", "");
                int value = Integer.valueOf(argumentValue);
                consoleOption.setValue(String.valueOf(value));
            }
            catch (NumberFormatException numberFormatException) {
                consoleOption.setValue(DEFAULT_FAILED_TEST_VALUE);
            }
        }
    }

    @Override
    public IConsoleLauncher getConsoleLauncher(ProjectEntity project, LauncherManager manager) throws InvalidConsoleArgumentException, ExecutionException {
        TestSuiteLauncherOptionParser.validateLicense((String)this.browserTypeOption.getValue());
        try {
            AbstractRunConfiguration runConfig = this.buildRunConfig(project, manager);
            return new ConsoleLauncher(manager, runConfig);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    @Override
    public ReportableLauncher getIDELauncher(ProjectEntity project, LauncherManager manager) throws ExecutionException, InvalidConsoleArgumentException {
        try {
            AbstractRunConfiguration runConfig = this.buildRunConfig(project, manager);
            return LauncherProviderFactory.getInstance().getIdeLauncherProvider().getTestSuiteIDELauncher(manager, runConfig);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private AbstractRunConfiguration buildRunConfig(ProjectEntity project, LauncherManager manager) throws InvalidConsoleArgumentException, Exception, ExecutionException, ControllerException, IOException {
        TestSuiteEntity testSuite = TestSuiteLauncherOptionParser.getTestSuite(project, (String)this.testSuitePathOption.getValue());
        return this.internallyBuildRunConfig(project, testSuite, manager);
    }

    protected AbstractRunConfiguration internallyBuildRunConfig(ProjectEntity project, TestSuiteEntity testSuite, LauncherManager manager) throws Exception, ExecutionException, InvalidConsoleArgumentException, ControllerException, IOException {
        ExecutionProfileEntity executionProfile;
        testSuite = this.preExecution(testSuite);
        TestSuiteExecutedEntity executedEntity = new TestSuiteExecutedEntity(testSuite);
        executedEntity.setReportLocation(this.reportableSetting.getReportLocationSetting());
        Rerunable rerunable = this.rerunSetting.mergeWith(executedEntity.getRerunSetting());
        if (rerunable instanceof DefaultRerunSetting) {
            executedEntity.setRerunSetting((DefaultRerunSetting)rerunable);
        } else {
            executedEntity.setRerunSetting(this.rerunSetting);
        }
        executedEntity.setWebServiceSettings(this.webServiceSettings);
        executedEntity.setFailedThreshold(manager.getFailedThreshold());
        if (this.testSuiteQuery.getValue() == null) {
            executedEntity.prepareTestCases();
        } else {
            executedEntity.prepareTestCasesWithTestSuiteQuery((String)this.testSuiteQuery.getValue());
        }
        AbstractRunConfiguration runConfig = (AbstractRunConfiguration)this.createRunConfiguration(project, testSuite, (String)this.browserTypeOption.getValue());
        String profileName = (String)this.executionProfileOption.getValue();
        if (StringUtils.isBlank((CharSequence)profileName)) {
            profileName = "default";
        }
        if ((executionProfile = GlobalVariableController.getInstance().getExecutionProfile(profileName, project)) == null) {
            throw new ExecutionException(MessageFormat.format(ExecutionMessageConstants.CONSOLE_MSG_PROFILE_NOT_FOUND, profileName));
        }
        runConfig.setExecutionProfile(executionProfile);
        runConfig.setOverridingGlobalVariables(this.getOverridingGlobalVariables());
        runConfig.setOverridingProtectedGlobalVariables(this.getOverridingProtectedGlobalVariables());
        runConfig.setExecutionUUID((String)this.executionUUIDOption.getValue());
        runConfig.setEnableProfiling((Boolean)this.enableProfilingOption.getValue());
        Map<String, Object> globalVariables = runConfig.getOverridingGlobalVariables();
        globalVariables.putAll(EmailVariableBinding.getVariablesForTestSuiteEmailSettings(testSuite));
        executedEntity.setEmailConfig(MailUtil.overrideEmailSettings(this.reportableSetting.getEmailConfig(project), executionProfile, globalVariables));
        Map<String, String> additionalInfo = this.infoOptionContributor.getOptionValues();
        runConfig.setAdditionalInfo(additionalInfo);
        runConfig.build((FileEntity)testSuite, executedEntity);
        GlobalVariableController.getInstance().generateGlobalVariableLibFile(project, null);
        return runConfig;
    }

    protected IRunConfiguration createRunConfiguration(ProjectEntity projectEntity, TestSuiteEntity testSuite, String browserType) throws ExecutionException, InvalidConsoleArgumentException, URISyntaxException, TestCloudException {
        IRunConfiguration runConfig = RunConfigurationCollector.getInstance().getRunConfiguration(browserType, projectEntity.getFolderLocation());
        if (runConfig == null) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_INVALID_BROWSER_X, browserType));
        }
        return runConfig;
    }

    protected static TestSuiteEntity getTestSuite(ProjectEntity projectEntity, String testSuiteID) throws InvalidConsoleArgumentException {
        try {
            TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteID, projectEntity);
            if (testSuite == null) {
                throw TestSuiteLauncherOptionParser.throwInvalidTestSuiteIdException(testSuiteID);
            }
            return testSuite;
        }
        catch (Exception exception) {
            throw TestSuiteLauncherOptionParser.throwInvalidTestSuiteIdException(testSuiteID);
        }
    }

    private static void validateLicense(String browserType) throws ExecutionException {
        if (StringUtils.equals((CharSequence)browserType, (CharSequence)GlobalStringConstants.TESTCLOUD_NAME)) {
            if (ConsoleLicenseService.getInstance().isValidTestCloudLicense()) {
                return;
            }
            String message = ConsoleLicenseService.getInstance().getReasonTerminateTestSuite();
            throw new ExecutionException(message);
        }
        if (ConsoleLicenseService.getInstance().isValidKRELicense()) {
            return;
        }
        String message = ConsoleLicenseService.getInstance().getReasonTerminateTestSuite();
        throw new ExecutionException(message);
    }

    private static InvalidConsoleArgumentException throwInvalidTestSuiteIdException(String testSuiteID) {
        return new InvalidConsoleArgumentException(MessageFormat.format(StringConstants.MNG_PRT_TEST_SUITE_X_NOT_FOUND, testSuiteID));
    }

    private TestSuiteEntity preExecution(TestSuiteEntity testSuite) {
        if (this.testCaseTags.getValue() != null) {
            testSuite = TagsLauncherOptionParserDescription.getTestCaseWithTags(this.testCaseTags, testSuite);
        }
        return testSuite;
    }
}

