/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.generator;

import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.exception.SyntaxErrorException;
import com.kms.katalon.execution.finders.TestDataValueFinder;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class TestCaseBindingStringBuilder {
    private int iterationIdx;
    private IExecutedEntity testCaseExecutedEntity;
    protected Map<String, Object> variableBinding;
    private StringBuilder syntaxErrorMessage;
    private String iterationVariableName;

    public TestCaseBindingStringBuilder(int iterationIdx, IExecutedEntity testCaseExecutedEntity) {
        this.iterationIdx = iterationIdx;
        this.testCaseExecutedEntity = testCaseExecutedEntity;
        this.variableBinding = new HashMap<String, Object>();
        this.syntaxErrorMessage = new StringBuilder();
        this.iterationVariableName = new String();
    }

    private String getTestCaseBindingName() {
        Object testCaseBindingName = this.testCaseExecutedEntity.getSourceId();
        if (this.testCaseExecutedEntity.getTotalTestCases() > 1) {
            testCaseBindingName = (String)testCaseBindingName + " - Iteration " + Integer.toString(this.iterationIdx + 1);
        }
        return testCaseBindingName;
    }

    public String build() {
        TestCaseBinding testCaseBinding = new TestCaseBinding(this.getTestCaseBindingName(), this.testCaseExecutedEntity.getSourceId(), this.variableBinding.isEmpty() ? null : this.variableBinding);
        testCaseBinding.setIterationVariableName(this.iterationVariableName);
        String testCaseBindingJson = JsonUtil.toJson((Object)testCaseBinding, (boolean)false);
        return testCaseBindingJson;
    }

    public boolean hasErrors() {
        return this.syntaxErrorMessage.length() > 0;
    }

    public String getErrorMessage() {
        return this.syntaxErrorMessage.toString();
    }

    public VariableEntity getVariableEntity(VariableLink variableLink) {
        try {
            return TestSuiteController.getInstance().getVariable(this.testCaseExecutedEntity.getSourceId(), variableLink);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void append(VariableLink variableLink, Map<String, TestData> testDataMap) {
        VariableEntity variableEntity = this.getVariableEntity(variableLink);
        if (variableEntity == null) {
            return;
        }
        try {
            String variableName = variableEntity.getName();
            Object variableValue = this.getVariableValue(variableName, variableLink, testDataMap);
            if (variableValue != null) {
                this.variableBinding.put(variableName, variableValue);
            }
        }
        catch (SyntaxErrorException e) {
            this.syntaxErrorMessage.append(e.getMessage()).append(SyntaxUtil.LINE_SEPARATOR);
        }
    }

    protected Object getVariableValue(String variableName, VariableLink variableLink, Map<String, TestData> testDataMap) throws SyntaxErrorException {
        Object variableValue = variableLink.getValue();
        try {
            switch (variableLink.getType()) {
                case DATA_COLUMN: {
                    variableValue = this.getValueByColumnName(variableName, variableLink, testDataMap);
                    break;
                }
                case DATA_COLUMN_INDEX: {
                    variableValue = this.getValueByColumnIndex(variableName, variableLink, testDataMap);
                    break;
                }
                case DEFAULT: {
                    variableValue = null;
                    break;
                }
                case SCRIPT_VARIABLE: {
                    break;
                }
                default: {
                    throw new NotImplementedException(variableLink.getType().name());
                }
            }
            return variableValue;
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new SyntaxErrorException(this.getErrorSyntaxMessageWithReason(variableName, variableValue.toString(), ex.getMessage()));
        }
    }

    protected Object getValueByColumnName(final String variableName, final VariableLink variableLink, Map<String, TestData> testDataMap) throws SyntaxErrorException, IOException {
        Object object = new TestDataValueFinder(variableLink, testDataMap, this.testCaseExecutedEntity){

            @Override
            protected int getColumnIndex(TestData testData) throws SyntaxErrorException, IOException {
                String columnName = variableLink.getValue();
                if (StringUtils.isEmpty((String)columnName)) {
                    throw new SyntaxErrorException(TestCaseBindingStringBuilder.this.getErrorSyntaxMessageWithReason(variableName, "", ExecutionMessageConstants.ERR_COLUMN_NAME_CANNOT_EMPTY));
                }
                return ArrayUtils.indexOf((Object[])testData.getColumnNames(), (Object)columnName) + 1;
            }
        }.getVariableValue(this.getErrorSyntaxMessageWithReason(variableName, variableLink.getValue(), ExecutionMessageConstants.ERR_TEST_DATA_VALUE_CANNOT_EMPTY), this.iterationIdx);
        if (object == null) {
            return object;
        }
        if (object instanceof String) {
            return GroovyStringUtil.toGroovyStringFormat((String)object.toString());
        }
        return object.toString();
    }

    protected Object getValueByColumnIndex(final String variableName, final VariableLink variableLink, Map<String, TestData> testDataMap) throws IOException, SyntaxErrorException {
        Object object = new TestDataValueFinder(variableLink, testDataMap, this.testCaseExecutedEntity){

            @Override
            protected int getColumnIndex(TestData testData) throws SyntaxErrorException, IOException {
                String columnIndexAsString = variableLink.getValue();
                if (StringUtils.isEmpty((String)columnIndexAsString) || !TestCaseBindingStringBuilder.this.isIntegerFormat(columnIndexAsString)) {
                    throw new SyntaxErrorException(TestCaseBindingStringBuilder.this.getErrorSyntaxMessageWithReason(variableName, "", ExecutionMessageConstants.ERR_VARIABLE_VALUE_NOT_INTEGER_FORMAT));
                }
                return Integer.valueOf(columnIndexAsString);
            }
        }.getVariableValue(this.getErrorSyntaxMessageWithReason(variableName, variableLink.getValue(), ExecutionMessageConstants.ERR_COLUMN_NAME_CANNOT_EMPTY), this.iterationIdx);
        if (object == null) {
            return object;
        }
        if (object instanceof String) {
            return GroovyStringUtil.toGroovyStringFormat((String)object.toString());
        }
        return object.toString();
    }

    private boolean isIntegerFormat(String integerAsString) {
        return StringUtils.isNotEmpty((String)integerAsString) && StringUtils.isNumeric((String)integerAsString);
    }

    protected String getErrorSyntaxMessageWithReason(String variableName, String variableValue, String reason) {
        return "Wrong syntax at [Test case ID: " + this.testCaseExecutedEntity.getSourceId() + ", Variable name: " + variableName + ", Variable value: " + this.getDisplayVariableValue(variableValue) + "]. Reason: " + reason;
    }

    private String getDisplayVariableValue(String variableValue) {
        String displayedVariableValue = variableValue;
        if (variableValue == null) {
            displayedVariableValue = "null";
        } else if (variableValue.isEmpty()) {
            displayedVariableValue = "<empty string>";
        }
        return displayedVariableValue;
    }

    public IExecutedEntity getTestCaseExecutedEntity() {
        return this.testCaseExecutedEntity;
    }

    public void setIterationVariableName(VariableEntity variableEntity) {
        if (variableEntity != null) {
            this.iterationVariableName = variableEntity.getName();
        }
    }

    public String getIterationVariableName() {
        return this.iterationVariableName;
    }
}

