/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testdata.parts;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.impl.util.EventUtil;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPartEvent;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.composer.testdata.constants.ComposerTestdataMessageConstants;
import com.kms.katalon.composer.testdata.constants.StringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testdata.events.TestDataUpdatedEvent;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.xml.sax.SAXParseException;

public abstract class TestDataMainPart
extends CPart
implements EventHandler,
IPartListener,
IComposerPartEvent {
    public static final int MAX_LABEL_WIDTH = 70;
    protected static final int MAX_COLUMN_COUNT = 100;
    protected static final int COLUMN_WIDTH = 200;
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    protected MDirtyable dirtyable;
    @Inject
    protected EModelService modelService;
    @Inject
    protected EPartService partService;
    @Inject
    protected MApplication application;
    protected MPart mpart;
    protected DataFileEntity originalDataFile;
    protected DataFileEntity cloneDataFile;
    private boolean isConfirmDialogShowed = false;
    protected Set<Thread> currentThreads;
    protected ModifyListener modifyListener;

    public void createControls(Composite parent, MPart mpart) {
        this.mpart = mpart;
        this.initialize(mpart, this.partService);
        this.currentThreads = new HashSet<Thread>();
        this.isConfirmDialogShowed = false;
        this.createModifyListener();
        this.createFileInfoPart(parent);
        this.createDataTablePart(parent);
        this.registerEventHandlers();
        this.updateDataFile((DataFileEntity)mpart.getObject());
        this.initValues();
        this.dirtyable.setDirty(false);
    }

    protected abstract void initValues();

    protected abstract EPartService getPartService();

    private void registerEventHandlers() {
        this.eventBroker.subscribe("TESTDATA/UPDATE", (EventHandler)this);
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", (EventHandler)this);
        this.getPartService().addPartListener((IPartListener)this);
    }

    protected abstract Composite createFileInfoPart(Composite var1);

    protected abstract Composite createDataTablePart(Composite var1);

    protected abstract void updateChildInfo(DataFileEntity var1);

    protected void updateDataFile(DataFileEntity dataFile) {
        this.originalDataFile = dataFile;
        this.mpart.setLabel(dataFile.getName());
        this.mpart.setElementId(EntityPartUtil.getTestDataPartId((String)dataFile.getId()));
        this.updateChildInfo(dataFile);
    }

    public void handleEvent(Event event) {
        if (event.getTopic().equals("TESTDATA/UPDATE")) {
            Object object = event.getProperty("org.eclipse.e4.data");
            if (object == null) {
                return;
            }
            if (object instanceof TestDataUpdatedEvent) {
                TestDataUpdatedEvent testData = (TestDataUpdatedEvent)object;
                String elementId = EntityPartUtil.getTestDataPartId((String)testData.getOriginalPk());
                String publisher = testData.getPublisherPartId();
                if (!this.mpart.getElementId().equals(publisher) && elementId.equalsIgnoreCase(this.mpart.getElementId())) {
                    DataFileEntity dataFile = testData.getDataFileEntity();
                    boolean oldDirty = this.dirtyable.isDirty();
                    this.updateDataFile(dataFile);
                    this.dirtyable.setDirty(oldDirty);
                }
            }
        } else if (event.getTopic().equals("EXPLORER/REFRESH_SELECTED_ITEM")) {
            try {
                Object selectedTreeEntityObject = event.getProperty("org.eclipse.e4.data");
                if (selectedTreeEntityObject != null) {
                    TestDataTreeEntity selectedTreeEntity;
                    DataFileEntity refreshedDataFileEntity;
                    if (selectedTreeEntityObject instanceof TestDataTreeEntity && (refreshedDataFileEntity = (selectedTreeEntity = (TestDataTreeEntity)selectedTreeEntityObject).getObject()).getId().equals(this.originalDataFile.getId())) {
                        if (TestDataController.getInstance().getTestData(refreshedDataFileEntity.getId()) != null) {
                            if (this.dirtyable.isDirty()) {
                                this.verifySourceChanged();
                            } else {
                                this.updateDataFile(refreshedDataFileEntity);
                                this.dirtyable.setDirty(false);
                            }
                        } else {
                            this.dispose();
                        }
                    }
                    if (selectedTreeEntityObject instanceof FolderTreeEntity) {
                        FolderEntity folderEntity = ((FolderTreeEntity)selectedTreeEntityObject).getObject();
                        if (this.originalDataFile.getId().contains(folderEntity.getId() + File.separator) && TestDataController.getInstance().getTestData(this.originalDataFile.getId()) == null) {
                            this.dispose();
                        }
                    }
                }
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    @PreDestroy
    public void dispose() {
        super.dispose();
        this.eventBroker.unsubscribe((EventHandler)this);
        MPartStack mStackPart = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        mStackPart.getChildren().remove(this.mpart);
    }

    private void createModifyListener() {
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestDataMainPart.this.dirtyable.setDirty(true);
            }
        };
    }

    protected void sendTestDataUpdatedEvent(String oldPk) {
        this.eventBroker.post("TESTDATA/UPDATE", (Object)new TestDataUpdatedEvent(oldPk, (FileEntity)this.originalDataFile, TestDataUpdatedEvent.TriggeredBy.CONTENT_MODIFICATION, this.mpart.getElementId()));
    }

    private void verifySourceChanged() {
        try {
            if (this.originalDataFile != null) {
                DataFileEntity sourceDataFile = TestDataController.getInstance().getTestData(this.originalDataFile.getId());
                if (sourceDataFile != null) {
                    if (!sourceDataFile.equals((Object)this.originalDataFile) && !this.isConfirmDialogShowed) {
                        this.isConfirmDialogShowed = true;
                        if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)ComposerTestdataMessageConstants.PA_CONFIRM_TITLE_FILE_CHANGED, (String)MessageFormat.format(ComposerTestdataMessageConstants.PA_CONFIRM_MSG_RELOAD_FILE, this.originalDataFile.getLocation()))) {
                            this.updateDataFile(sourceDataFile);
                            this.dirtyable.setDirty(false);
                        }
                        this.isConfirmDialogShowed = false;
                    }
                } else {
                    FolderTreeEntity parentFolderTreeEntity = this.getParentFolderTreeEntity(this.originalDataFile.getParentFolder(), FolderController.getInstance().getTestDataRoot(this.originalDataFile.getProject()));
                    if (parentFolderTreeEntity != null) {
                        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentFolderTreeEntity);
                    }
                    this.dispose();
                }
            }
        }
        catch (UnmarshalException e) {
            if (!this.isConfirmDialogShowed) {
                this.isConfirmDialogShowed = true;
                SAXParseException saxParserException = (SAXParseException)e.getLinkedException().getCause();
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)StringConstants.ERROR_TITLE, (String)MessageFormat.format(ComposerTestdataMessageConstants.PA_ERROR_MSG_FILE_X_IS_WRONG_FORMAT_AT_LINE_Y, this.originalDataFile.getLocation(), saxParserException.getLineNumber()));
                this.isConfirmDialogShowed = false;
                try {
                    FolderTreeEntity parentFolderTreeEntity = this.getParentFolderTreeEntity(this.originalDataFile.getParentFolder(), FolderController.getInstance().getTestDataRoot(this.originalDataFile.getProject()));
                    if (parentFolderTreeEntity != null) {
                        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentFolderTreeEntity);
                    }
                    this.dispose();
                }
                catch (Exception exception) {
                    LoggerSingleton.logError((Throwable)e);
                }
            }
            LoggerSingleton.logError((Throwable)e);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Focus
    private void onFocused() {
        this.verifySourceChanged();
    }

    private FolderTreeEntity getParentFolderTreeEntity(FolderEntity folderEntity, FolderEntity rootFolder) {
        if (folderEntity == null || folderEntity.equals((Object)rootFolder)) {
            return null;
        }
        return new FolderTreeEntity(folderEntity, (ITreeEntity)this.getParentFolderTreeEntity(folderEntity.getParentFolder(), rootFolder));
    }

    @PreDestroy
    public void onClose() {
        EventUtil.post((String)"PROPERTIES/ENTITY", null);
        this.eventBroker.unsubscribe((EventHandler)this);
        for (Thread currentThread : this.currentThreads) {
            if (!currentThread.isAlive()) continue;
            currentThread.interrupt();
        }
        Iterator<Thread> threadIterator = null;
    }

    public void setDirty(boolean dirty) {
        this.dirtyable.setDirty(dirty);
    }

    public void partActivated(MPart part) {
    }

    public void partBroughtToTop(MPart part) {
    }

    public void partDeactivated(MPart part) {
        if (part == this.mpart) {
            this.removePart();
        }
    }

    public void partHidden(MPart part) {
        if (part == this.mpart) {
            this.removePart();
        }
    }

    public void partVisible(MPart part) {
    }

    private void removePart() {
        this.getPartService().removePartListener((IPartListener)this);
        if (!this.mpart.isVisible()) {
            this.getPartService().savePart(this.mpart, false);
        }
    }

    public DataFileEntity getDataFile() {
        return this.originalDataFile;
    }

    public String getEntityId() {
        return this.getDataFile().getIdForDisplay();
    }

    protected void refreshTreeEntity() {
        try {
            TestDataTreeEntity testDataTreeEntity = TreeEntityUtil.getTestDataTreeEntity((DataFileEntity)this.originalDataFile, (ProjectEntity)ProjectController.getInstance().getCurrentProject());
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)testDataTreeEntity);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    public void onSelect(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/bringToTop") Event event) {
        if (this.mpart == null || this.originalDataFile == null) {
            return;
        }
        MPart part = EventUtil.getPart((Event)event);
        if (part == null || !StringUtils.equals((String)part.getElementId(), (String)this.mpart.getElementId())) {
            return;
        }
        EventUtil.post((String)"PROPERTIES/ENTITY", (Object)this.originalDataFile);
    }

    @Inject
    @Optional
    public void onChangeEntityProperties(@UIEventTopic(value="PROPERTIES/ENTITY_UPDATED") Event event) {
        Object eventData = EventUtil.getData((Event)event);
        if (!(eventData instanceof DataFileEntity)) {
            return;
        }
        DataFileEntity updatedEntity = (DataFileEntity)eventData;
        if (!StringUtils.equals((String)updatedEntity.getIdForDisplay(), (String)this.getEntityId())) {
            return;
        }
        this.originalDataFile.setTag(updatedEntity.getTag());
        this.originalDataFile.setDescription(updatedEntity.getDescription());
    }
}

