/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarRequest;

public class CurlCommandGenerator {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int MAX_BODY_SIZE_BYTES = 51200;
    private static final String FILE_UPLOAD_PREFIX = "FILE_UPLOAD:";
    private static final String NEWLINE_PATTERN = "\r?\n";
    private static final String BOUNDARY_PREFIX = "--";
    private static final String BOUNDARY_SUFFIX = "--";
    private static final String SHELL_ESCAPED_SINGLE_QUOTE = "'\\''";

    private CurlCommandGenerator() {
    }

    public static String generateCurlCommand(HarEntry harEntry) {
        if (harEntry == null || harEntry.getRequest() == null) {
            return "";
        }
        HarRequest request = harEntry.getRequest();
        ArrayList<String> curlParts = new ArrayList<String>();
        curlParts.add("curl");
        curlParts.add("--location");
        CurlCommandGenerator.addMethodIfNotGet(curlParts, request.getMethod());
        Map<String, String> uniqueHeaders = CurlCommandGenerator.collectHeaders(request.getHeaders());
        CurlCommandGenerator.handlePostData(curlParts, uniqueHeaders, request);
        CurlCommandGenerator.addHeadersAndUrl(curlParts, uniqueHeaders, request);
        return String.join((CharSequence)" ", curlParts);
    }

    private static void addMethodIfNotGet(List<String> curlParts, String method) {
        if (!"GET".equalsIgnoreCase(method)) {
            curlParts.add("--request");
            curlParts.add(method);
        }
    }

    private static Map<String, String> collectHeaders(List<HarNameValuePair> headers) {
        LinkedHashMap<String, String> uniqueHeaders = new LinkedHashMap<String, String>();
        for (HarNameValuePair header : headers) {
            if (header.getName() == null || header.getValue() == null) continue;
            String key = header.getName().toLowerCase();
            String sanitized = header.getValue().replace("\n", "").replace("\r", "").replace("'", SHELL_ESCAPED_SINGLE_QUOTE);
            uniqueHeaders.putIfAbsent(key, String.format("%s: %s", header.getName(), sanitized));
        }
        return uniqueHeaders;
    }

    private static boolean handlePostData(List<String> curlParts, Map<String, String> uniqueHeaders, HarRequest request) {
        HarPostData postData = request.getPostData();
        if (postData == null) {
            return false;
        }
        if (CurlCommandGenerator.handleFileUploadComment(curlParts, uniqueHeaders, postData, request)) {
            return true;
        }
        if (CurlCommandGenerator.handleMultipartFormData(curlParts, uniqueHeaders, postData)) {
            return true;
        }
        if (CurlCommandGenerator.handleUrlEncodedFormData(curlParts, postData)) {
            return true;
        }
        CurlCommandGenerator.handleTextBasedBody(curlParts, postData);
        return true;
    }

    private static boolean handleFileUploadComment(List<String> curlParts, Map<String, String> uniqueHeaders, HarPostData postData, HarRequest request) {
        String comment = postData.getComment();
        if (comment == null || !comment.startsWith(FILE_UPLOAD_PREFIX)) {
            return false;
        }
        String filePath = comment.substring(FILE_UPLOAD_PREFIX.length()).trim();
        if (filePath.isEmpty()) {
            return false;
        }
        curlParts.add("--form");
        curlParts.add(String.format("'file=@%s'", filePath.replace("'", SHELL_ESCAPED_SINGLE_QUOTE)));
        uniqueHeaders.remove("content-type");
        return true;
    }

    private static boolean handleMultipartFormData(List<String> curlParts, Map<String, String> uniqueHeaders, HarPostData postData) {
        String mimeType = postData.getMimeType();
        if (mimeType == null || !mimeType.toLowerCase().startsWith("multipart/form-data")) {
            return false;
        }
        String body = postData.getText();
        if (body == null || body.isEmpty()) {
            return false;
        }
        List<MultipartField> fields = CurlCommandGenerator.parseMultipartFormData(body);
        for (MultipartField field : fields) {
            curlParts.add("--form");
            String escapedName = CurlCommandGenerator.safe(field.name());
            String escapedValue = CurlCommandGenerator.safe(field.value());
            if (field.isFile()) {
                curlParts.add(String.format("'%s=@%s'", escapedName, escapedValue));
                continue;
            }
            curlParts.add(String.format("'%s=%s'", escapedName, escapedValue));
        }
        return true;
    }

    private static boolean handleUrlEncodedFormData(List<String> curlParts, HarPostData postData) {
        String formData;
        boolean isUrlEncoded;
        String mimeType = postData.getMimeType();
        boolean bl = isUrlEncoded = mimeType != null && mimeType.toLowerCase().contains("application/x-www-form-urlencoded");
        if (!isUrlEncoded) {
            return false;
        }
        if (postData.getParams() != null && !postData.getParams().isEmpty() && !(formData = postData.getParams().stream().filter(p -> p.getName() != null && p.getValue() != null).map(p -> String.format("%s=%s", p.getName(), p.getValue())).collect(Collectors.joining("&"))).isEmpty()) {
            curlParts.add("--data-urlencode");
            curlParts.add(String.format("'%s'", formData.replace("'", SHELL_ESCAPED_SINGLE_QUOTE)));
            return true;
        }
        String text = postData.getText();
        if (text != null && !text.trim().isEmpty()) {
            curlParts.add("--data-urlencode");
            curlParts.add(String.format("'%s'", text.replace("'", SHELL_ESCAPED_SINGLE_QUOTE)));
            return true;
        }
        return false;
    }

    private static void handleTextBasedBody(List<String> curlParts, HarPostData postData) {
        String body = postData.getText();
        if (body == null || body.isEmpty()) {
            return;
        }
        if (body.getBytes().length > 51200) {
            curlParts.add("--data");
            curlParts.add("'[Request body truncated: exceeds 50KB limit]'");
            return;
        }
        String processedBody = CurlCommandGenerator.processBodyContent(body, postData.getMimeType());
        curlParts.add("--data");
        curlParts.add(String.format("'%s'", processedBody.replace("'", SHELL_ESCAPED_SINGLE_QUOTE)));
    }

    private static String processBodyContent(String body, String mimeType) {
        if (mimeType != null && mimeType.toLowerCase().contains("json") || CurlCommandGenerator.looksLikeJson(body)) {
            return CurlCommandGenerator.minifyJson(body);
        }
        return body;
    }

    private static String safe(String value) {
        return value == null ? "" : value.replace("'", SHELL_ESCAPED_SINGLE_QUOTE);
    }

    private static void addHeadersAndUrl(List<String> curlParts, Map<String, String> headers, HarRequest request) {
        for (String headerValue : headers.values()) {
            curlParts.add("--header");
            curlParts.add(String.format("'%s'", headerValue));
        }
        String url = request.getUrl();
        if (url != null) {
            curlParts.add(String.format("'%s'", url.replace("'", SHELL_ESCAPED_SINGLE_QUOTE)));
        }
    }

    private static boolean looksLikeJson(String body) {
        if (body == null) {
            return false;
        }
        String trimmed = body.trim();
        return trimmed.startsWith("{") || trimmed.startsWith("[");
    }

    private static String minifyJson(String json) {
        try {
            Object parsed = objectMapper.readValue(json, Object.class);
            return objectMapper.writeValueAsString(parsed);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return json.replaceAll("\\s+", " ").trim();
        }
    }

    private static List<MultipartField> parseMultipartFormData(String body) {
        String[] parts;
        String[] lines;
        ArrayList<MultipartField> fields = new ArrayList<MultipartField>();
        String boundary = null;
        String[] stringArray = lines = body.split(NEWLINE_PATTERN);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith("--")) {
                boundary = line.substring(2);
                break;
            }
            ++n2;
        }
        if (boundary == null) {
            return fields;
        }
        String[] stringArray2 = parts = body.split("--" + Pattern.quote(boundary));
        int n3 = parts.length;
        n = 0;
        while (n < n3) {
            String[] partLines;
            String contentDisposition;
            String part = stringArray2[n];
            if (!(part = part.trim()).isEmpty() && !part.equals("--") && (contentDisposition = (partLines = part.split(NEWLINE_PATTERN))[0]).startsWith("Content-Disposition:")) {
                String name = CurlCommandGenerator.extractFieldName(contentDisposition);
                boolean isFile = contentDisposition.contains("filename=");
                String value = part.substring(part.indexOf("\r\n\r\n") + 4).trim();
                fields.add(new MultipartField(name, value, isFile));
            }
            ++n;
        }
        return fields;
    }

    private static String extractFieldName(String contentDisposition) {
        int nameIndex = contentDisposition.indexOf("name=\"");
        if (nameIndex == -1) {
            return null;
        }
        int start = nameIndex + 6;
        int end = contentDisposition.indexOf("\"", start);
        if (end == -1) {
            return null;
        }
        return contentDisposition.substring(start, end);
    }

    private record MultipartField(String name, String value, boolean isFile) {
    }
}

