/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webservice.common;

import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.webservice.common.ScriptSnippet;
import com.kms.katalon.util.SAXReaderProvider;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.xml.sax.SAXException;

public class VerificationScriptSnippetFactory {
    private static final String SNIPPET_NODE = "snippet";
    private static final String SNIPPET_NAME_NODE = "name";
    private static final String SNIPPET_SCRIPT_NODE = "script";
    private static final String SNIPPET_COMMON_NODE = "common";
    private static List<ScriptSnippet> snippets = new ArrayList<ScriptSnippet>();
    private static ScriptSnippet commonScriptSnippet;

    private static List<ScriptSnippet> loadSnippets() {
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(VerificationScriptSnippetFactory.class), (IPath)new Path("/resources/snippet/verification_snippet.xml"), null);
        try {
            SAXReader reader = SAXReaderProvider.newInstance();
            Document document = reader.read(url);
            Element rootElement = document.getRootElement();
            for (Object snippetObj : rootElement.elements(SNIPPET_NODE)) {
                String snippetScript;
                Element snippetElement = (Element)snippetObj;
                String snippetName = snippetElement.elementText(SNIPPET_NAME_NODE);
                ScriptSnippet snippet = new ScriptSnippet(snippetName, snippetScript = snippetElement.element(SNIPPET_SCRIPT_NODE).getText().trim());
                if (snippet.getName().equals(SNIPPET_COMMON_NODE)) {
                    commonScriptSnippet = snippet;
                    continue;
                }
                snippets.add(snippet);
            }
        }
        catch (DocumentException e) {
            throw new KatalonRuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new KatalonRuntimeException((Throwable)e);
        }
        return snippets;
    }

    public static List<ScriptSnippet> getSnippets() {
        if (snippets.isEmpty()) {
            VerificationScriptSnippetFactory.loadSnippets();
        }
        return snippets;
    }

    public static ScriptSnippet getCommonScriptSnippet() {
        if (commonScriptSnippet == null) {
            VerificationScriptSnippetFactory.loadSnippets();
        }
        return commonScriptSnippet;
    }
}

