/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.capability.composer.common.page;

import com.katalon.capability.composer.common.component.CapabilityComposite;
import com.katalon.capability.composer.common.constant.CapabilityUITextConstant;
import com.katalon.capability.composer.common.dialog.ImportCapabilitiesDialog;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.controller.ICapabilityController;
import com.katalon.capability.dto.ImportCapabilityRequest;
import com.katalon.capability.model.CapabilitySetting;
import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CapabilityPage
extends PreferencePageWithHelp {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilityPage.class);
    protected CapabilityComposite capabilityComposite;
    @Inject
    protected ICapabilityController capabilityController;
    @Inject
    protected IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private Button btnImport;
    private Button btnExport;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        try {
            CapabilitySetting capabilitySetting = this.capabilityController.getCapability(this.getDriverType());
            this.capabilityComposite = new CapabilityComposite(container, 0, capabilitySetting);
        }
        catch (Exception exception) {
            LOGGER.error("Exception while createContents", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)"Cannot load capability", (String)exception.getMessage());
        }
        return container;
    }

    protected void setCapability(CapabilitySetting capabilitySetting) {
        this.capabilityComposite.setCapability(capabilitySetting);
    }

    protected abstract DriverType getDriverType();

    public boolean performOk() {
        block3: {
            ProjectEntity projectEntity = ProjectController.getInstance().getCurrentProject();
            try {
                if (projectEntity != null && this.capabilityComposite != null && this.capabilityComposite.getCapability() != null) break block3;
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Exception while performOk", (Throwable)e);
                MessageDialog.openError(null, (String)"Error", (String)"Unable to save the project settings");
                return false;
            }
        }
        CapabilitySetting capabilitySetting = this.capabilityComposite.getCapability();
        this.capabilityController.saveCapability(capabilitySetting);
        return true;
    }

    protected void performDefaults() {
        try {
            CapabilitySetting capabilitySetting = this.capabilityController.getCapability(this.getDriverType());
            this.setCapability(capabilitySetting);
        }
        catch (Exception exception) {
            LOGGER.error("Exception while performDefaults", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)"Cannot load capability", (String)exception.getMessage());
        }
        super.performDefaults();
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite buttonBar = this.getApplyButton().getParent();
        GridLayout buttonBarLayout = (GridLayout)buttonBar.getLayout();
        buttonBarLayout.numColumns += 2;
        this.btnImport = new Button(buttonBar, 0x1000000);
        this.btnImport.setText("Import");
        this.setButtonLayoutData(this.btnImport);
        this.btnImport.moveAbove((Control)this.getDefaultsButton());
        this.btnExport = new Button(buttonBar, 0x1000000);
        this.btnExport.setText("Export");
        this.setButtonLayoutData(this.btnExport);
        this.btnExport.moveAbove((Control)this.getDefaultsButton());
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CapabilityPage.this.canUseImportExportDesiredCapabilities()) {
                    CapabilityPage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                ImportCapabilitiesDialog importDialog = new ImportCapabilitiesDialog(CapabilityPage.this.getShell());
                if (importDialog.open() == 0) {
                    CapabilityPage.this.importPropertiesFromFile(importDialog.getFilePath(), importDialog.isOverridingExistingProperties());
                }
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!CapabilityPage.this.canUseImportExportDesiredCapabilities()) {
                    CapabilityPage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                FileDialog exportFileDialog = new FileDialog(CapabilityPage.this.getShell(), 8192);
                exportFileDialog.setFilterNames(CapabilityUITextConstant.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_NAMES);
                exportFileDialog.setFilterExtensions(CapabilityUITextConstant.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_EXTS);
                exportFileDialog.setOverwrite(true);
                exportFileDialog.setFileName(CapabilityPage.this.generateDefaultExportFileName());
                String filePath = exportFileDialog.open();
                if (filePath != null) {
                    CapabilityPage.this.exportPropertiesToFile(filePath);
                }
            }
        });
    }

    protected void exportPropertiesToFile(String exportFilePath) {
        try {
            this.capabilityController.exportCapability(exportFilePath, this.capabilityComposite.getCapability());
        }
        catch (Exception exception) {
            LOGGER.error("Exception while exportPropertiesToFile", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format("Unable to export to file {0}", exportFilePath), (String)exception.getMessage());
        }
    }

    protected void importPropertiesFromFile(String importFilePath, boolean isOverridingExistingProperties) {
        try {
            CapabilitySetting capabilitySetting = this.capabilityController.importCapability(new ImportCapabilityRequest(this.getDriverType(), importFilePath, isOverridingExistingProperties));
            this.setCapability(capabilitySetting);
        }
        catch (Exception exception) {
            LOGGER.error("Exception while importPropertiesFromFile", (Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format("Unable to import from file {0}", importFilePath), (String)exception.getMessage());
        }
    }

    protected String generateDefaultExportFileName() {
        String driverTypeName = this.getDriverType().name().toLowerCase();
        driverTypeName = driverTypeName.substring(0, driverTypeName.indexOf("_driver"));
        return driverTypeName + "_caps.json";
    }

    private boolean canUseImportExportDesiredCapabilities() {
        return this.featureController.canUse(ProductFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
    }
}

