/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.importproject.components;

import com.kms.katalon.composer.importproject.constants.StringConstants;
import com.kms.katalon.entity.util.ImportDuplicateEntityParameter;
import com.kms.katalon.entity.util.ImportType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DuplicateEntityDialog
extends Dialog {
    private static final String DIALOG_MESSAGE_SUFFIX = StringConstants.COMP_DIALOG_MSG_SUFFIX;
    private static final String DIALOG_MESSAGE_PREFIX = StringConstants.COMP_DIALOG_MSG_PREFIX;
    private static final String MERGE_BUTTON_LABEL = StringConstants.COMP_BTN_MERGE;
    private static final String OVERRIDE_BUTTON_LABEL = StringConstants.COMP_BTN_OVERRIDE;
    private static final String CREATE_NEW_BUTTON_LABEL = StringConstants.COMP_BTN_CREATE_NEW;
    public static final int MERGE_BUTTON_ID = 4;
    public static final int OVERRIDE_BUTTON_ID = 3;
    public static final int CREAT_NEW_BUTTON_ID = 2;
    private static final String DIALOG_TITLE = StringConstants.COMP_DIALOG_TITLE_IMPORT_PROJECT;
    private static final String APPLY_TO_ALL_CHECKBOX_TEXT = StringConstants.COMP_CHKBOX_APPLY_TO_ALL;
    private ImportDuplicateEntityParameter importParams;
    private Button applyToAllCb;
    private boolean isApplyToAll;

    public DuplicateEntityDialog(Shell parentShell, ImportDuplicateEntityParameter importParams) {
        super(parentShell);
        this.importParams = importParams;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DIALOG_MESSAGE_PREFIX).append(this.importParams.getMessage()).append(DIALOG_MESSAGE_SUFFIX);
        Label label = new Label(container, 0);
        label.setText(stringBuilder.toString());
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.pack();
        container.layout(true, true);
        Point newSize = container.computeSize(-1, -1, true);
        container.setSize(newSize);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button newButton = this.createButton(parent, 2, CREATE_NEW_BUTTON_LABEL, true);
        newButton.setEnabled(false);
        Button overrideButton = this.createButton(parent, 3, OVERRIDE_BUTTON_LABEL, false);
        overrideButton.setEnabled(false);
        Button mergeButton = this.createButton(parent, 4, MERGE_BUTTON_LABEL, false);
        mergeButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        ImportType[] importTypeArray = this.importParams.getAvailableImportTypes();
        int n = importTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ImportType importType = importTypeArray[n2];
            switch (importType) {
                case New: {
                    newButton.setEnabled(true);
                    break;
                }
                case Override: {
                    overrideButton.setEnabled(true);
                    break;
                }
                case Merge: {
                    mergeButton.setEnabled(true);
                    break;
                }
            }
            ++n2;
        }
    }

    protected Control createButtonBar(Composite parent) {
        this.createApplyToAllComposite(parent);
        return super.createButtonBar(parent);
    }

    private void createApplyToAllComposite(Composite parent) {
        Composite applyToAllComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 10;
        applyToAllComposite.setLayout((Layout)gridLayout);
        GridData data = new GridData(34);
        applyToAllComposite.setLayoutData((Object)data);
        this.applyToAllCb = new Button(applyToAllComposite, 32);
        this.applyToAllCb.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.applyToAllCb.setText(APPLY_TO_ALL_CHECKBOX_TEXT);
        this.isApplyToAll = false;
        this.applyToAllCb.setSelection(this.isApplyToAll);
        this.applyToAllCb.pack();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.isApplyToAll = this.applyToAllCb.getSelection();
        this.close();
    }

    public boolean getIsApplyToAll() {
        return this.isApplyToAll;
    }
}

