/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.components.impl.providers;

import com.kms.katalon.composer.components.impl.providers.TypeCheckedStyleCellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;

public abstract class MouseCursorColumnLabelProvider<T>
extends TypeCheckedStyleCellLabelProvider<T> {
    public MouseCursorColumnLabelProvider(int columnIndex) {
        super(columnIndex);
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        super.initialize(viewer, column);
        this.registerMouseListeners(viewer);
    }

    private void registerMouseListeners(ColumnViewer viewer) {
        Control table = this.getControl(viewer);
        final CellClickedListener mouseListener = new CellClickedListener();
        table.addMouseListener((MouseListener)mouseListener);
        final MoveMouseOnCellListener mouseMoveListener = new MoveMouseOnCellListener();
        table.addMouseMoveListener((MouseMoveListener)mouseMoveListener);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control control = (Control)e.getSource();
                control.removeMouseListener((MouseListener)mouseListener);
                control.removeMouseMoveListener((MouseMoveListener)mouseMoveListener);
            }
        });
    }

    protected boolean shouldShowCursor(ViewerCell cell, Point currentMouseLocation) {
        return cell.getBounds().contains(currentMouseLocation);
    }

    protected abstract void handleMouseDown(MouseEvent var1, ViewerCell var2);

    protected Control getControl(ColumnViewer viewer) {
        return viewer.getControl();
    }

    protected boolean isPlacedMouseHover(ViewerCell cell) {
        return cell != null && cell.getColumnIndex() == this.columnIndex;
    }

    private final class CellClickedListener
    extends MouseAdapter {
        private static final int LEFT_CLICK = 1;

        private CellClickedListener() {
        }

        public void mouseUp(MouseEvent e) {
            if (e.button != 1) {
                return;
            }
            Point currentMouseLocation = new Point(e.x, e.y);
            ColumnViewer viewer = MouseCursorColumnLabelProvider.this.getViewer();
            if (viewer == null) {
                return;
            }
            ViewerCell cell = viewer.getCell(currentMouseLocation);
            if (MouseCursorColumnLabelProvider.this.isPlacedMouseHover(cell) && MouseCursorColumnLabelProvider.this.shouldShowCursor(cell, currentMouseLocation)) {
                MouseCursorColumnLabelProvider.this.handleMouseDown(e, cell);
            }
        }
    }

    private final class MoveMouseOnCellListener
    implements MouseMoveListener {
        private MoveMouseOnCellListener() {
        }

        public void mouseMove(MouseEvent e) {
            ColumnViewer viewer = MouseCursorColumnLabelProvider.this.getViewer();
            if (viewer == null) {
                return;
            }
            Point currentMouseLocation = new Point(e.x, e.y);
            ViewerCell cell = viewer.getCell(currentMouseLocation);
            Control table = MouseCursorColumnLabelProvider.this.getControl(viewer);
            if (cell == null) {
                if (table.getCursor() != null) {
                    table.getCursor().dispose();
                }
                table.setCursor(null);
                return;
            }
            if (!MouseCursorColumnLabelProvider.this.isPlacedMouseHover(cell) || !MouseCursorColumnLabelProvider.this.shouldShowCursor(cell, currentMouseLocation)) {
                int cellIndex = cell.getColumnIndex();
                if (!(MouseCursorColumnLabelProvider.this.getViewer().getLabelProvider(cellIndex) instanceof MouseCursorColumnLabelProvider) || cellIndex == MouseCursorColumnLabelProvider.this.columnIndex) {
                    if (table.getCursor() != null) {
                        table.getCursor().dispose();
                    }
                    table.setCursor(null);
                }
                return;
            }
            if (table.getCursor() == null) {
                table.setCursor(this.newCursor());
            }
        }

        private Cursor newCursor() {
            return new Cursor((Device)MouseCursorColumnLabelProvider.this.getControl(MouseCursorColumnLabelProvider.this.getViewer()).getDisplay(), 21);
        }
    }
}

