/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.models;

import com.katalon.mobile.core.enums.MobileDevicePlatform;
import com.katalon.mobile.core.interfaces.IMobileApplication;
import com.katalon.mobile.core.interfaces.IMobileDevice;
import com.katalon.mobile.core.interfaces.IMobileProvider;
import com.katalon.mobile.models.LocalAndroidDevice;
import com.katalon.mobile.models.LocalIosDevice;
import com.katalon.mobile.models.LocalIosSimulator;
import com.katalon.mobile.utils.AdbUtil;
import com.katalon.mobile.utils.IDeviceUtil;
import com.katalon.mobile.utils.XcrunUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProvider
implements IMobileProvider {
    private static Logger logger = LoggerFactory.getLogger(LocalProvider.class);
    private List<IMobileDevice> iosSimulators = new ArrayList<IMobileDevice>();

    private List<IMobileDevice> getAndroidDevices() {
        ArrayList<IMobileDevice> androidDevices = new ArrayList<IMobileDevice>();
        List<Object> deviceIds = new ArrayList();
        try {
            deviceIds = AdbUtil.getDeviceIds();
        }
        catch (IOException | InterruptedException exception) {
            logger.error("Failed to get android devices", (Throwable)exception);
        }
        for (String string : deviceIds) {
            try {
                LocalAndroidDevice device = new LocalAndroidDevice(string);
                device.setProperties(AdbUtil.getDeviceProperties(string));
                androidDevices.add(device);
            }
            catch (IOException | InterruptedException e) {
                logger.error(String.format("Failed to get android device info (%s)", string), (Throwable)e);
            }
        }
        return androidDevices;
    }

    public List<IMobileDevice> getDevices(MobileDevicePlatform platform) {
        List<Object> devices = new ArrayList();
        if (MobileDevicePlatform.ANDROID.equals((Object)platform)) {
            devices = this.getAndroidDevices();
        } else if (MobileDevicePlatform.IOS.equals((Object)platform)) {
            devices = this.getIosDevices();
        }
        return devices;
    }

    private List<IMobileDevice> getIosDevices() {
        List<Object> devices = new ArrayList();
        try {
            devices = this.getIosRealDevices();
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to get iOS devices", (Throwable)e);
        }
        List<Object> simulators = new ArrayList();
        try {
            simulators = this.getIosSimulators();
        }
        catch (IOException | InterruptedException e) {
            logger.error("Failed to get iOS simulators", (Throwable)e);
        }
        devices.addAll(simulators);
        return devices;
    }

    private List<IMobileDevice> getIosRealDevices() throws IOException, InterruptedException {
        if (!this.isRunningOnMacOSX()) {
            return Collections.emptyList();
        }
        ArrayList<IMobileDevice> iosDevices = new ArrayList<IMobileDevice>();
        List<String> deviceIds = IDeviceUtil.getDeviceIds();
        for (String deviceId : deviceIds) {
            try {
                LocalIosDevice device = new LocalIosDevice(deviceId);
                device.setProperties(IDeviceUtil.getDeviceProperties(deviceId));
                iosDevices.add(device);
            }
            catch (IOException | InterruptedException e) {
                logger.error(String.format("Failed to get iOS device info (%s)", deviceId), (Throwable)e);
            }
        }
        return iosDevices;
    }

    private List<IMobileDevice> getIosSimulators() throws IOException, InterruptedException {
        if (!this.isRunningOnMacOSX()) {
            return Collections.emptyList();
        }
        if (!this.iosSimulators.isEmpty()) {
            return this.iosSimulators;
        }
        ArrayList<IMobileDevice> iosDevices = new ArrayList<IMobileDevice>();
        List<String> simulatorIds = XcrunUtil.getSimulatorIds();
        for (String simulatorId : simulatorIds) {
            try {
                LocalIosSimulator device = new LocalIosSimulator(simulatorId);
                device.setProperties(XcrunUtil.getSimulatorProperties(simulatorId));
                iosDevices.add(device);
            }
            catch (IOException | InterruptedException e) {
                logger.error(String.format("Failed to get iOS simulator info (%s)", simulatorId), (Throwable)e);
            }
        }
        this.iosSimulators = iosDevices;
        return this.iosSimulators;
    }

    public boolean isEnabled() {
        return true;
    }

    private boolean isRunningOnMacOSX() {
        return Platform.getOS().equals("macosx");
    }

    public List<IMobileApplication> getApplications(MobileDevicePlatform platform) {
        return new ArrayList<IMobileApplication>();
    }
}

