/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.mobile.models;

import com.katalon.mobile.core.enums.MobileProvider;
import com.katalon.mobile.core.interfaces.IMobileProvider;
import com.katalon.mobile.core.interfaces.IMobileProviderFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileProviderFactory
implements IMobileProviderFactory {
    private static Logger logger = LoggerFactory.getLogger(MobileProviderFactory.class);
    @Inject
    IEclipseContext context;
    private Map<MobileProvider, IMobileProvider> providerCache = new ConcurrentHashMap<MobileProvider, IMobileProvider>();

    public IMobileProvider getProvider(MobileProvider type) {
        if (type == null) {
            return null;
        }
        IMobileProvider cached = this.providerCache.get(type);
        if (cached != null && cached.isEnabled()) {
            return cached;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.katalon.mobile.core.providers");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String id = element.getAttribute("id");
                if (id != null && id.equalsIgnoreCase(type.name())) {
                    try {
                        Object obj = element.createExecutableExtension("class");
                        if (obj instanceof IMobileProvider) {
                            IMobileProvider provider = (IMobileProvider)obj;
                            ContextInjectionFactory.inject((Object)provider, (IEclipseContext)this.context);
                            if (provider.isEnabled()) {
                                this.providerCache.put(type, provider);
                                return provider;
                            }
                        }
                    }
                    catch (CoreException | InjectionException e) {
                        logger.warn("Failed to create device provider", e);
                        return null;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public List<MobileProvider> getSupportedProviders() {
        ArrayList<MobileProvider> supportedProviders = new ArrayList<MobileProvider>();
        supportedProviders.add(MobileProvider.REMOTE);
        supportedProviders.add(MobileProvider.CUSTOM);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.katalon.mobile.core.providers");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                String id = element.getAttribute("id");
                if (id != null) {
                    try {
                        Object obj = element.createExecutableExtension("class");
                        if (obj instanceof IMobileProvider) {
                            IMobileProvider provider = (IMobileProvider)obj;
                            ContextInjectionFactory.inject((Object)provider, (IEclipseContext)this.context);
                            if (provider.isEnabled()) {
                                supportedProviders.add(MobileProvider.valueOf((String)id));
                            }
                        }
                    }
                    catch (CoreException | InjectionException e) {
                        logger.warn("Failed to check provider availability", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return supportedProviders;
    }
}

